/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.hylo.graph.LFEdgeLabel;
import opennlp.ccg.hylo.graph.LFVertex;
import opennlp.ccg.util.Filter;
import opennlp.ccg.util.FilteredSet;

public class FilteredLFEdgeSet
extends FilteredSet<LFEdge> {
    private VertexView sourceView = null;
    private VertexView targetView = null;
    private LabelView labelView = null;

    public FilteredLFEdgeSet(Set<? extends LFEdge> edges, Filter<? super LFEdge> edgeFilter) {
        super(edges, edgeFilter);
    }

    public Collection<LFVertex> sourceView() {
        return this.sourceView == null ? (this.sourceView = new VertexView(true)) : this.sourceView;
    }

    public Collection<LFVertex> targetView() {
        return this.targetView == null ? (this.targetView = new VertexView(false)) : this.targetView;
    }

    public Collection<LFEdgeLabel> labelView() {
        return this.labelView == null ? (this.labelView = new LabelView()) : this.labelView;
    }

    class LabelView
    extends ComponentView<LFEdgeLabel> {
        LabelView() {
        }

        @Override
        LFEdgeLabel componentOf(LFEdge edge) {
            return edge.getLabel();
        }
    }

    class VertexView
    extends ComponentView<LFVertex> {
        boolean source;

        VertexView(boolean source) {
            this.source = source;
        }

        @Override
        LFVertex componentOf(LFEdge edge) {
            return this.source ? edge.getSource() : edge.getTarget();
        }
    }

    abstract class ComponentView<T>
    extends AbstractCollection<T> {
        ComponentView() {
        }

        abstract T componentOf(LFEdge var1);

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private Iterator<LFEdge> i;
                {
                    this.i = FilteredLFEdgeSet.this.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public T next() {
                    return ComponentView.this.componentOf(this.i.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return FilteredLFEdgeSet.this.size();
        }
    }
}

