/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.Phrase;

public class PhraseWriter
extends FilterWriter {
    final String wordSeparator;
    protected PrintWriter printWriter;

    public PhraseWriter(Writer out) {
        this(out, " ");
    }

    public PhraseWriter(Writer out, String wordSeparator) {
        super(new PrintWriter(out));
        if (wordSeparator == null) {
            throw new IllegalArgumentException("wordSeparator is null");
        }
        this.wordSeparator = wordSeparator;
        this.printWriter = (PrintWriter)this.out;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void writePhrase(Phrase phrase) throws IOException {
        this.preWritePhrase(phrase);
        this.printWriter.print(Alignments.untokenize(phrase, this.wordSeparator));
        this.postWritePhrase(phrase);
    }

    protected void preWritePhrase(Phrase phrase) throws IOException {
    }

    protected void postWritePhrase(Phrase phrase) throws IOException {
        this.printWriter.println();
    }
}

