/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.IndexBase;
import opennlp.ccg.alignment.Phrase;

public class PhraseReader
extends LineNumberReader {
    final IndexBase numberBase;
    public static final IndexBase LINE_NUMBER_BASE = IndexBase.ONE;

    public PhraseReader(Reader in) {
        this(in, Alignments.DEFAULT_PHRASE_NUMBER_BASE);
    }

    public PhraseReader(Reader in, IndexBase numberBase) {
        super(in);
        if (numberBase == null) {
            throw new IllegalArgumentException("numberBase is null");
        }
        this.numberBase = numberBase;
    }

    public IndexBase getNumberBase() {
        return this.numberBase;
    }

    public Integer getPhraseNumber() {
        return LINE_NUMBER_BASE.translate(this.getLineNumber(), this.numberBase);
    }

    public Phrase readPhrase() throws IOException {
        String ln = this.readLine();
        return ln == null ? null : new Phrase(this.getPhraseNumber(), Alignments.tokenize(ln));
    }
}

