/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.ccg.alignment.Alignments;
import opennlp.ccg.alignment.EncodingScheme;
import opennlp.ccg.alignment.IndexBase;
import opennlp.ccg.alignment.Mapping;
import opennlp.ccg.alignment.Status;

public class MappingFormat
extends Format {
    private static final long serialVersionUID = 1L;
    final EncodingScheme encodingScheme;
    final Set<Field> fields;
    final Pattern mappingPattern;
    final Pattern fieldPattern;
    final boolean strict;
    private static Map<EncodingScheme, Set<MappingFormat>> formatCache;

    protected MappingFormat(EncodingScheme scheme, Set<Field> fields, boolean strict) {
        if (scheme == null) {
            throw new IllegalArgumentException("encoding scheme is null");
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields is null");
        }
        this.encodingScheme = scheme;
        this.fields = fields;
        this.strict = strict;
        if (!fields.containsAll(this.encodingScheme.getRequired())) {
            throw new IllegalArgumentException("specified fields does not contain all required fields");
        }
        if (!this.encodingScheme.getOrder().containsAll(fields)) {
            throw new IllegalArgumentException("encoding scheme does not use all the specified fields");
        }
        this.fieldPattern = Pattern.compile(scheme.getFieldDelimiter().toString());
        this.mappingPattern = Pattern.compile("([\\w\\.]+" + scheme.getFieldDelimiter() + ")+[\\w\\.]+");
    }

    public static MappingFormat getInstance(EncodingScheme scheme) {
        return MappingFormat.getInstance(scheme, scheme.getDefaults());
    }

    public static MappingFormat getInstance(EncodingScheme scheme, Set<Field> fields) {
        return MappingFormat.getInstance(scheme, fields, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappingFormat getInstance(EncodingScheme scheme, Set<Field> fields, boolean strict) {
        if (scheme == null) {
            throw new IllegalArgumentException("encoding scheme is null");
        }
        Class<MappingFormat> clazz = MappingFormat.class;
        synchronized (MappingFormat.class) {
            MappingFormat mf = null;
            Set<MappingFormat> fs = null;
            if (formatCache == null) {
                formatCache = new HashMap<EncodingScheme, Set<MappingFormat>>();
            } else {
                fs = formatCache.get(scheme);
            }
            if (fs == null) {
                fs = new HashSet<MappingFormat>();
                formatCache.put(scheme, fs);
            }
            for (MappingFormat f : fs) {
                if (f.strict != strict || !f.fields.equals(fields)) continue;
                mf = f;
                break;
            }
            if (mf == null) {
                mf = new MappingFormat(scheme, fields, strict);
                fs.add(mf);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mf;
        }
    }

    public EncodingScheme getEncodingScheme() {
        return this.encodingScheme;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String formatMapping(Mapping mapping) {
        List<Field> order = this.encodingScheme.getOrder();
        Field field = null;
        int index = -1;
        for (int i = 0; i < order.size(); ++i) {
            Field f = order.get(i);
            if (!this.fields.contains(f)) continue;
            field = f;
            index = i;
            break;
        }
        return this.format(mapping, new StringBuffer(), new FieldPosition(field, index)).toString();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof Mapping)) {
            throw new IllegalArgumentException("not a mapping: " + obj);
        }
        if (pos.getFieldAttribute() == null) {
            int i = pos.getField();
            pos = new FieldPosition(this.fieldAtIndex(i), i);
        }
        return this.format((Mapping)obj, toAppendTo, pos);
    }

    public StringBuffer format(Mapping mapping, StringBuffer toAppendTo, FieldPosition pos) {
        if (mapping.a.equals(Alignments.DEFAULT_INDEX_BASE.nullValue) || mapping.b.equals(Alignments.DEFAULT_INDEX_BASE.nullValue)) {
            throw new IllegalArgumentException("cannot format null mapping: " + mapping);
        }
        Format.Field f = pos.getFieldAttribute();
        if (!(f instanceof Field)) {
            int i = pos.getField();
            pos = new FieldPosition(this.fieldAtIndex(i), i);
        }
        Field field = (Field)f;
        if (!this.encodingScheme.getOrder().contains(field)) {
            throw new IllegalArgumentException("no such field '" + field + "' in scheme " + this.encodingScheme);
        }
        if (!this.fields.contains(field)) {
            throw new IllegalArgumentException("field '" + field + "' not specified for this format");
        }
        int start2 = toAppendTo.length();
        for (Field af : this.encodingScheme.getOrder()) {
            if (!this.fields.contains(af)) continue;
            Object val = null;
            if (af.equals(Field.PHRASE_NUMBER_FIELD)) {
                val = mapping.phraseNumber;
            } else if (af.equals(Field.A_INDEX_FIELD)) {
                val = mapping.a;
            } else if (af.equals(Field.B_INDEX_FIELD)) {
                val = mapping.b;
            } else if (af.equals(Field.STATUS_FIELD)) {
                val = this.strict || this.encodingScheme.getRequired().contains(Field.STATUS_FIELD) ? mapping.status : (mapping.status == Alignments.DEFAULT_STATUS ? null : mapping.status);
            } else if (af.equals(Field.CONFIDENCE_FIELD)) {
                Object object = this.strict || this.encodingScheme.getRequired().contains(Field.CONFIDENCE_FIELD) ? mapping.confidence : (val = mapping.confidence.equals(Alignments.DEFAULT_CONFIDENCE) ? null : mapping.confidence);
            }
            if (val == null) {
                if (this.encodingScheme.getRequired().contains(af)) {
                    throw new IllegalArgumentException("required field " + af + " contains null value");
                }
                if (!field.equals(af)) continue;
                throw new IllegalArgumentException("specified field " + field + " contains null value");
            }
            if (af.equals(Field.PHRASE_NUMBER_FIELD) || af.equals(Field.A_INDEX_FIELD) || af.equals(Field.B_INDEX_FIELD)) {
                boolean pn = af.equals(Field.PHRASE_NUMBER_FIELD);
                IndexBase mappingBase = pn ? this.encodingScheme.getPhraseNumberBase() : this.encodingScheme.getIndexBase();
                IndexBase defaultBase = pn ? Alignments.DEFAULT_PHRASE_NUMBER_BASE : Alignments.DEFAULT_INDEX_BASE;
                val = defaultBase.translate((Integer)val, mappingBase);
            } else if (af.equals(Field.STATUS_FIELD)) {
                val = ((Status)((Object)val)).abbreviation;
            }
            if (start2 < toAppendTo.length()) {
                toAppendTo.append(this.encodingScheme.getFieldDelimiter());
            }
            if (field.equals(af)) {
                pos.setBeginIndex(toAppendTo.length());
            }
            toAppendTo.append(val);
            if (!field.equals(af)) continue;
            pos.setEndIndex(toAppendTo.length());
        }
        return toAppendTo;
    }

    Field fieldAtIndex(int i) throws IndexOutOfBoundsException {
        Field f = this.encodingScheme.getOrder().get(i);
        if (f == null) {
            throw new IndexOutOfBoundsException("no field at position " + i);
        }
        return f;
    }

    public Mapping parseMapping(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Mapping m = (Mapping)this.parseObject(source, pos);
        if (pos.getErrorIndex() != -1) {
            throw new ParseException("problem parsing input \"" + source + "\"", pos.getErrorIndex());
        }
        return m;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Double confidence;
        if (pos == null) {
            throw new NullPointerException("parse position is null");
        }
        int index = pos.getIndex();
        Matcher matcher = this.mappingPattern.matcher(source);
        if (!matcher.matches()) {
            pos.setErrorIndex(index);
            return null;
        }
        if (matcher.start() != index) {
            pos.setErrorIndex(index);
            return null;
        }
        String[] chunks = this.fieldPattern.split(source);
        Iterator<Field> oi = this.encodingScheme.getOrder().iterator();
        HashMap<Field, Status> values = new HashMap<Field, Status>(this.encodingScheme.getOrder().size());
        for (int i = 0; i < chunks.length; ++i) {
            String c = chunks[i];
            if (c.length() == 0 || !oi.hasNext()) {
                pos.setErrorIndex(index);
                return null;
            }
            Field af = null;
            while (oi.hasNext()) {
                Object val;
                block16: {
                    af = oi.next();
                    try {
                        if (af.equals(Field.PHRASE_NUMBER_FIELD) || af.equals(Field.A_INDEX_FIELD) || af.equals(Field.B_INDEX_FIELD)) {
                            boolean pn = af.equals(Field.PHRASE_NUMBER_FIELD);
                            IndexBase mappingBase = pn ? this.encodingScheme.getPhraseNumberBase() : this.encodingScheme.getIndexBase();
                            IndexBase defaultBase = pn ? Alignments.DEFAULT_PHRASE_NUMBER_BASE : Alignments.DEFAULT_INDEX_BASE;
                            try {
                                val = mappingBase.translate(Integer.valueOf(c), defaultBase);
                            }
                            catch (IllegalArgumentException iie) {
                                pos.setErrorIndex(index);
                                return null;
                            }
                            if (((Integer)val).equals(defaultBase.nullValue)) {
                                pos.setErrorIndex(index);
                                return null;
                            }
                            break block16;
                        }
                        val = af.equals(Field.STATUS_FIELD) ? Status.forAbbreviation(c) : (af.equals(Field.CONFIDENCE_FIELD) ? Double.valueOf(c) : null);
                    }
                    catch (NumberFormatException e) {
                        pos.setErrorIndex(index);
                        return null;
                    }
                }
                if (val == null) {
                    if (!this.encodingScheme.getRequired().contains(af) && (!this.strict || !this.fields.contains(af))) continue;
                    pos.setErrorIndex(index);
                    return null;
                }
                values.put(af, (Status)((Object)val));
                break;
            }
            index += c.length();
            if (i >= chunks.length - 1) continue;
            ++index;
        }
        pos.setIndex(matcher.end());
        Set keys = values.keySet();
        if (!keys.containsAll(this.encodingScheme.getRequired()) || this.strict && !keys.containsAll(this.fields)) {
            pos.setErrorIndex(index);
            return null;
        }
        Integer id = values.containsKey(Field.PHRASE_NUMBER_FIELD) ? (Integer)values.get(Field.PHRASE_NUMBER_FIELD) : null;
        Integer first = values.containsKey(Field.A_INDEX_FIELD) ? (Integer)values.get(Field.A_INDEX_FIELD) : null;
        Integer second = values.containsKey(Field.B_INDEX_FIELD) ? (Integer)values.get(Field.B_INDEX_FIELD) : null;
        Status status = (Status)((Object)values.get(Field.STATUS_FIELD));
        if (status == null && Field.STATUS_FIELD.hasDefaultValue()) {
            status = (Status)((Object)Field.STATUS_FIELD.defaultValue);
        }
        if ((confidence = (Double)values.get(Field.CONFIDENCE_FIELD)) == null && Field.CONFIDENCE_FIELD.hasDefaultValue()) {
            confidence = (Double)Field.CONFIDENCE_FIELD.defaultValue;
        }
        return new Mapping(id, first, second, status, confidence);
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 1L;
        Object defaultValue = null;
        public static final Field PHRASE_NUMBER_FIELD = new Field("PHRASE_NUMBER", null);
        public static final Field A_INDEX_FIELD = new Field("A_INDEX", null);
        public static final Field B_INDEX_FIELD = new Field("B_INDEX", null);
        public static final Field STATUS_FIELD = new Field("STATUS", (Object)Alignments.DEFAULT_STATUS);
        public static final Field CONFIDENCE_FIELD = new Field("CONFIDENCE", Alignments.DEFAULT_CONFIDENCE);

        protected Field(String name, Object defaultValue) {
            super(name);
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.defaultValue = defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

