/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.IOException;
import java.io.Writer;
import opennlp.ccg.alignment.Phrase;
import opennlp.ccg.alignment.PhraseWriter;

public class IdentifiedPhraseWriter
extends PhraseWriter {
    final String phraseTag;
    final String phraseIdentifierAttribute;
    final boolean padding;

    public IdentifiedPhraseWriter(Writer out) {
        this(out, " ");
    }

    public IdentifiedPhraseWriter(Writer out, String wordSeparator) {
        this(out, wordSeparator, "s", "snum");
    }

    public IdentifiedPhraseWriter(Writer out, String wordSeparator, String phraseTag, String phraseIdentifierAttribute) {
        this(out, wordSeparator, phraseTag, phraseIdentifierAttribute, false);
    }

    public IdentifiedPhraseWriter(Writer out, String wordSeparator, String phraseTag, String phraseIdentifierAttribute, boolean padding) {
        super(out, wordSeparator);
        if (phraseTag == null) {
            throw new IllegalArgumentException("phraseTag is null");
        }
        if (phraseIdentifierAttribute == null) {
            throw new IllegalArgumentException("phraseIdentifierAttribute is null");
        }
        this.phraseTag = phraseTag;
        this.phraseIdentifierAttribute = phraseIdentifierAttribute;
        this.padding = padding;
    }

    public String getPhraseTag() {
        return this.phraseTag;
    }

    public String getPhraseIdentifierAttribute() {
        return this.phraseIdentifierAttribute;
    }

    public boolean isPadding() {
        return this.padding;
    }

    @Override
    public void preWritePhrase(Phrase phrase) throws IOException {
        String id = phrase.getId();
        if (id == null) {
            throw new IOException("attempt to write phrase with null ID: " + phrase);
        }
        this.printWriter.print('<');
        this.printWriter.print(this.phraseTag);
        this.printWriter.print(' ');
        this.printWriter.print(this.phraseIdentifierAttribute);
        this.printWriter.print("=\"");
        this.printWriter.print(id);
        this.printWriter.print("\">");
        if (this.padding) {
            this.printWriter.print(' ');
        }
    }

    @Override
    public void postWritePhrase(Phrase phrase) throws IOException {
        if (this.padding) {
            this.printWriter.print(' ');
        }
        this.printWriter.print("</");
        this.printWriter.print(this.phraseTag);
        this.printWriter.println(">");
    }
}

