/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import opennlp.ccg.util.Pair;

public class TrieMap<KeyType, DataType> {
    public DataType data;
    private Object childMap = null;
    private TrieMap<KeyType, DataType> parent = null;

    public TrieMap(DataType data) {
        this.data = data;
    }

    protected TrieMap<KeyType, DataType> createNode() {
        return new TrieMap<KeyType, Object>(null);
    }

    public void addChild(KeyType key, TrieMap<KeyType, DataType> child) {
        IdentityHashMap<KeyType, TrieMap<KeyType, DataType>> map;
        child.parent = this;
        if (this.childMap == null) {
            this.childMap = new Pair<KeyType, TrieMap<KeyType, DataType>>(key, child);
            return;
        }
        if (this.childMap instanceof Pair) {
            Pair pair = (Pair)this.childMap;
            map = new IdentityHashMap<KeyType, TrieMap<KeyType, DataType>>();
            map.put((KeyType)pair.a, (TrieMap<KeyType, DataType>)pair.b);
            this.childMap = map;
        } else {
            map = (IdentityHashMap<KeyType, TrieMap<KeyType, DataType>>)this.childMap;
        }
        map.put(key, child);
    }

    public void addChildren(List<KeyType> keys, List<TrieMap<KeyType, DataType>> childNodes) {
        Map<KeyType, TrieMap<KeyType, DataType>> map;
        if (this.childMap == null && keys.size() == 1) {
            TrieMap<KeyType, DataType> child = childNodes.get(0);
            child.parent = this;
            this.childMap = new Pair<KeyType, TrieMap<KeyType, DataType>>(keys.get(0), child);
            return;
        }
        if (this.childMap == null) {
            map = new IdentityHashMap(keys.size());
            this.childMap = map;
        } else if (this.childMap instanceof Pair) {
            Pair pair = (Pair)this.childMap;
            map = new IdentityHashMap(keys.size() + 1);
            map.put((KeyType)pair.a, (TrieMap<KeyType, DataType>)pair.b);
            this.childMap = map;
        } else {
            map = (Map)this.childMap;
        }
        for (int i = 0; i < keys.size(); ++i) {
            TrieMap<KeyType, DataType> child = childNodes.get(i);
            child.parent = this;
            map.put(keys.get(i), child);
        }
    }

    public TrieMap<KeyType, DataType> getParent() {
        return this.parent;
    }

    public TrieMap<KeyType, DataType> getChild(KeyType key) {
        if (this.childMap == null) {
            return null;
        }
        if (this.childMap instanceof Pair) {
            Pair pair = (Pair)this.childMap;
            if (pair.a == key) {
                return (TrieMap)pair.b;
            }
            return null;
        }
        Map map = (Map)this.childMap;
        return (TrieMap)map.get(key);
    }

    public TrieMap<KeyType, DataType> getChildFromList(List<KeyType> keys) {
        TrieMap<KeyType, DataType> next = this;
        for (int pos = 0; pos < keys.size(); ++pos) {
            if ((next = next.getChild(keys.get(pos))) != null) continue;
            return null;
        }
        return next;
    }

    public TrieMap<KeyType, DataType> getChildFromLazyList(List<KeyExtractor<KeyType>> keyExtractors) {
        TrieMap<KeyType, DataType> next = this;
        for (int pos = 0; pos < keyExtractors.size(); ++pos) {
            if ((next = next.getChild(keyExtractors.get(pos).getKey())) != null) continue;
            return null;
        }
        return next;
    }

    public TrieMap<KeyType, DataType> findChild(KeyType key) {
        TrieMap<KeyType, DataType> child = this.getChild(key);
        if (child == null) {
            child = this.createNode();
            this.addChild(key, child);
        }
        return child;
    }

    public TrieMap<KeyType, DataType> findChildFromList(List<KeyType> keys) {
        TrieMap<KeyType, DataType> next = this;
        for (int pos = 0; pos < keys.size(); ++pos) {
            KeyType key = keys.get(pos);
            TrieMap<KeyType, DataType> child = next.getChild(key);
            if (child == null) {
                child = this.createNode();
                next.addChild(key, child);
            }
            next = child;
        }
        return next;
    }

    public TrieMap<KeyType, DataType> findChildFromLazyList(List<KeyExtractor<KeyType>> keyExtractors) {
        TrieMap<KeyType, DataType> next = this;
        for (int pos = 0; pos < keyExtractors.size(); ++pos) {
            KeyType key = keyExtractors.get(pos).getKey();
            TrieMap<KeyType, DataType> child = next.getChild(key);
            if (child == null) {
                child = this.createNode();
                next.addChild(key, child);
            }
            next = child;
        }
        return next;
    }

    public List<KeyType> traceKeys() {
        ArrayList<Object> retval = new ArrayList<Object>();
        TrieMap<KeyType, DataType> currentNode = this;
        TrieMap<KeyType, DataType> currentParent = this.parent;
        while (currentParent != null) {
            if (currentParent.childMap instanceof Pair) {
                Pair pair = (Pair)currentParent.childMap;
                retval.add(pair.a);
            } else {
                Map map = (Map)currentParent.childMap;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != currentNode) continue;
                    retval.add(entry.getKey());
                    break;
                }
            }
            currentNode = currentParent;
            currentParent = currentParent.parent;
        }
        Collections.reverse(retval);
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    private void toString(StringBuffer sb, String indent) {
        sb.append("node: " + this.data);
        if (this.childMap == null) {
            return;
        }
        indent = indent + "  ";
        if (this.childMap instanceof Pair) {
            Pair pair = (Pair)this.childMap;
            this.toString(sb, indent, pair.a, (TrieMap)pair.b);
        } else {
            Map map = (Map)this.childMap;
            ArrayList keys = new ArrayList(map.keySet());
            Comparator toStringComparator = new Comparator<KeyType>(){

                @Override
                public int compare(KeyType o1, KeyType o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            };
            Collections.sort(keys, toStringComparator);
            for (Object key : keys) {
                this.toString(sb, indent, key, (TrieMap)map.get(key));
            }
        }
    }

    private void toString(StringBuffer sb, String indent, Object key, TrieMap<?, ?> child) {
        sb.append("\n").append(indent).append('[').append(key).append("] ");
        super.toString(sb, indent);
    }

    public static interface KeyExtractor<KeyType> {
        public KeyType getKey();
    }
}

