/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.util.Filter;

public class FilteredMap<K, V>
extends AbstractMap<K, V> {
    Map<? extends K, ? extends V> originalMap;
    Filter<? super K> keyFilter;
    private final Map<K, V> map = new LinkedHashMap();

    public FilteredMap(Map<? extends K, ? extends V> originalMap, Filter<? super K> keyFilter) {
        if (keyFilter == null) {
            throw new IllegalArgumentException("keyFilter is null");
        }
        this.originalMap = originalMap;
        this.keyFilter = keyFilter;
        this.putAll(originalMap);
    }

    public Map<? extends K, ? extends V> getOriginalMap() {
        return this.originalMap;
    }

    public Filter<? super K> getKeyFilter() {
        return this.keyFilter;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V put(K key, V value) {
        if (this.keyFilter.allows(key)) {
            return this.map.put(key, value);
        }
        return null;
    }
}

