/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.synsem.AbstractCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GFeatStruc;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import opennlp.ccg.util.DisplayPrefs;
import org.jdom.Content;
import org.jdom.Element;

public final class AtomCat
extends AbstractCat
implements TargetCat {
    private static final long serialVersionUID = 1L;
    private String type;
    public boolean fragCompletion = false;

    public AtomCat(String t) {
        this(t, new GFeatStruc());
    }

    public AtomCat(String t, FeatureStructure fs) {
        this(t, fs, null);
    }

    public AtomCat(String t, FeatureStructure fs, LF lf) {
        super(lf);
        this.type = t;
        this._featStruc = fs;
    }

    public AtomCat(Element acel) {
        super(acel);
        Element fsEl;
        this.type = acel.getAttributeValue("type");
        if (this.type == null) {
            this.type = acel.getAttributeValue("t");
        }
        this._featStruc = (fsEl = acel.getChild("fs")) != null ? new GFeatStruc(fsEl) : new GFeatStruc();
    }

    @Override
    public Element toXml() {
        Element retval = new Element("atomcat");
        retval.setAttribute("type", this.type);
        if ((!this._featStruc.isEmpty() || this._featStruc.getIndex() > 0) && this._featStruc instanceof GFeatStruc) {
            retval.addContent((Content)((GFeatStruc)this._featStruc).toXml());
        }
        super.toXml(retval);
        return retval;
    }

    @Override
    public TargetCat getTarget() {
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Category copy() {
        AtomCat retval = new AtomCat(this.type, this._featStruc.copy(), this._lf == null ? null : this._lf.copy());
        retval.fragCompletion = this.fragCompletion;
        return retval;
    }

    @Override
    public Category shallowCopy() {
        AtomCat retval = new AtomCat(this.type, this._featStruc, this._lf);
        retval.fragCompletion = this.fragCompletion;
        return retval;
    }

    @Override
    public void deepMap(ModFcn mf) {
        super.deepMap(mf);
        this._featStruc.deepMap(mf);
    }

    @Override
    public void unifyCheck(Object u) throws UnifyFailure {
        if (u instanceof AtomCat) {
            AtomCat u_ac = (AtomCat)u;
            if (!this.type.equals(u_ac.type)) {
                throw new UnifyFailure();
            }
            if (this._featStruc != null && u_ac._featStruc != null) {
                this._featStruc.unifyCheck(u_ac._featStruc);
            }
        } else if (!(u instanceof Variable)) {
            throw new UnifyFailure();
        }
    }

    @Override
    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof AtomCat && this.type.equals(((AtomCat)u).type)) {
            AtomCat u_ac = (AtomCat)u;
            FeatureStructure $fs = this._featStruc == null ? u_ac._featStruc : (u_ac._featStruc == null ? this._featStruc : (FeatureStructure)this._featStruc.unify(u_ac._featStruc, sub));
            return new AtomCat(this.type, $fs);
        }
        throw new UnifyFailure();
    }

    @Override
    public Object fill(Substitution s) throws UnifyFailure {
        AtomCat $ac = new AtomCat(this.type, (FeatureStructure)this._featStruc.fill(s), this._lf == null ? null : (LF)this._lf.fill(s));
        return $ac;
    }

    @Override
    public boolean shallowEquals(Object c) {
        if (c instanceof AtomCat) {
            AtomCat ac = (AtomCat)c;
            return this.type.equals(ac.type);
        }
        return false;
    }

    @Override
    public String toString() {
        DisplayPrefs prefs = Grammar.theGrammar.prefs;
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        if (this.fragCompletion) {
            sb.append("_c");
        }
        if (this._featStruc != null && prefs.showFeats) {
            sb.append(this._featStruc.toString());
        }
        if (this._lf != null && prefs.showSem) {
            sb.append(" : ").append(this._lf.toString());
        }
        if (sb.length() == 0) {
            return "UnknownCat";
        }
        return sb.toString();
    }

    @Override
    public String getSupertag() {
        if (this._supertag != null) {
            return this._supertag;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        if (this._featStruc != null) {
            sb.append(this._featStruc.getSupertagInfo());
        }
        this._supertag = sb.length() == 0 ? "UnknownCat" : sb.toString().intern();
        return this._supertag;
    }

    @Override
    public String toTeX() {
        DisplayPrefs prefs = Grammar.theGrammar.prefs;
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        if (this._featStruc != null && prefs.showFeats) {
            sb.append(this._featStruc.toTeX());
        }
        if (sb.length() == 0) {
            return "UnknownCat";
        }
        return sb.toString();
    }

    @Override
    public int hashCodeNoLF(TObjectIntHashMap varMap) {
        int retval = this.type.hashCode();
        if (this._featStruc != null) {
            retval = this._featStruc instanceof GFeatStruc ? (retval += ((GFeatStruc)this._featStruc).hashCode(varMap)) : (retval += this._featStruc.hashCode());
        }
        return retval;
    }

    @Override
    public boolean equalsNoLF(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AtomCat ac = (AtomCat)obj;
        if (this._featStruc != null && ac._featStruc == null) {
            return false;
        }
        if (this._featStruc == null && ac._featStruc != null) {
            return false;
        }
        if (!this.type.equals(ac.type)) {
            return false;
        }
        return this._featStruc == null || !(this._featStruc instanceof GFeatStruc ? !((GFeatStruc)this._featStruc).equals(ac._featStruc, varMap, varMap2) : !this._featStruc.equals(ac._featStruc));
    }

    @Override
    public boolean isFragment() {
        return this.type.equals("frag");
    }
}

