/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.synsem;

import gnu.trove.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.ccg.synsem.Arg;
import opennlp.ccg.synsem.BasicArg;
import opennlp.ccg.synsem.CatReader;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.Dollar;
import opennlp.ccg.synsem.SetArg;
import opennlp.ccg.synsem.Slash;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Content;
import org.jdom.Element;

public class ArgStack
implements Serializable {
    private static final long serialVersionUID = -4610015768742537105L;
    protected Arg[] _list;
    protected boolean _hasDollar = false;
    protected boolean _hasSet = false;

    public ArgStack() {
        this._list = new Arg[0];
    }

    public ArgStack(Arg c) {
        this._list = new Arg[1];
        this._list[0] = c;
        if (c instanceof Dollar) {
            this._hasDollar = true;
        } else if (c instanceof SetArg) {
            this._hasSet = true;
        }
    }

    public ArgStack(Slash s, Category c) {
        this(new BasicArg(s, c));
    }

    public ArgStack(Arg[] list) {
        this._list = list;
        this.checkForDollar();
        this.checkForSet();
    }

    public ArgStack(List<Element> info) {
        ArrayList<Arg> args = new ArrayList<Arg>();
        Iterator<Element> infoIt = info.iterator();
        while (infoIt.hasNext()) {
            Element el = infoIt.next();
            String elName = el.getName();
            if (elName.equals("setarg")) {
                args.add(new SetArg(el));
                this._hasSet = true;
                continue;
            }
            if (elName.equals("dollar")) {
                String name = el.getAttributeValue("name");
                if (name == null) {
                    name = el.getAttributeValue("n");
                }
                args.add(new Dollar(name));
                this._hasDollar = true;
                continue;
            }
            if (elName.equals("slash") || elName.equals("sl")) {
                Slash s = new Slash(el);
                Element argEl = infoIt.next();
                if (argEl.getName().equals("dollar")) {
                    String name = argEl.getAttributeValue("name");
                    if (name == null) {
                        name = argEl.getAttributeValue("n");
                    }
                    args.add(new Dollar(s, name));
                    this._hasDollar = true;
                    continue;
                }
                args.add(new BasicArg(s, CatReader.getCat(argEl)));
                continue;
            }
            System.out.println("Invalid element for creating ArgStack: " + elName);
        }
        this._list = new Arg[args.size()];
        args.toArray(this._list);
    }

    public void toXml(Element catElt) {
        for (Arg arg : this._list) {
            if (arg instanceof SetArg) {
                catElt.addContent((Content)((SetArg)arg).toXml());
                continue;
            }
            if (arg instanceof Dollar) {
                Dollar dollar = (Dollar)arg;
                if (!dollar.getSlash().toString().equals("|.")) {
                    catElt.addContent((Content)dollar.getSlash().toXml());
                }
                Element dollarElt = new Element("dollar");
                dollarElt.setAttribute("name", dollar.name());
                catElt.addContent((Content)dollarElt);
                continue;
            }
            if (!(arg instanceof BasicArg)) continue;
            BasicArg barg = (BasicArg)arg;
            catElt.addContent((Content)barg.getSlash().toXml());
            catElt.addContent((Content)barg.getCat().toXml());
        }
    }

    public void addAt(Arg c, int index) {
        Arg[] $list = new Arg[this._list.length + 1];
        ArgStack.insert(this.subList((int)0, (int)index)._list, $list, 0);
        $list[index] = c;
        ArgStack.insert(this.subList((int)index)._list, $list, index + 1);
        this._list = $list;
        if (c instanceof Dollar) {
            this._hasDollar = true;
        } else if (c instanceof SetArg) {
            this._hasSet = true;
        }
    }

    public void add(Arg c) {
        Arg[] $list = new Arg[this._list.length + 1];
        int last = ArgStack.insert(this._list, $list, 0);
        $list[last] = c;
        this._list = $list;
        if (c instanceof Dollar) {
            this._hasDollar = true;
        } else if (c instanceof SetArg) {
            this._hasSet = true;
        }
    }

    public void addAt(ArgStack cl, int index) {
        Arg[] $list = new Arg[this._list.length + cl._list.length];
        int last = ArgStack.insert(this.subList((int)0, (int)index)._list, $list, 0);
        last = ArgStack.insert(cl._list, $list, last);
        ArgStack.insert(this.subList((int)index)._list, $list, last);
        this._list = $list;
        if (cl.containsDollarArg()) {
            this._hasDollar = true;
        } else if (cl.containsSetArg()) {
            this._hasSet = true;
        }
    }

    public void add(ArgStack cl) {
        Arg[] $list = new Arg[this._list.length + cl._list.length];
        int last = ArgStack.insert(this._list, $list, 0);
        ArgStack.insert(cl._list, $list, last);
        this._list = $list;
        if (cl.containsDollarArg()) {
            this._hasDollar = true;
        } else if (cl.containsSetArg()) {
            this._hasSet = true;
        }
    }

    public void addFront(Arg c) {
        Arg[] $list = new Arg[this._list.length + 1];
        $list[0] = c;
        ArgStack.insert(this._list, $list, 1);
        this._list = $list;
        if (c instanceof Dollar) {
            this._hasDollar = true;
        } else if (c instanceof SetArg) {
            this._hasSet = true;
        }
    }

    public void addFront(ArgStack cl) {
        Arg[] $list = new Arg[this._list.length + cl._list.length];
        int last = ArgStack.insert(cl._list, $list, 0);
        ArgStack.insert(this._list, $list, last);
        this._list = $list;
        if (cl.containsDollarArg()) {
            this._hasDollar = true;
        } else if (cl.containsSetArg()) {
            this._hasSet = true;
        }
    }

    public void insertFront(ArgStack cl) {
        this.insertAt(cl, 0);
    }

    public void insertEnd(ArgStack cl) {
        this.insertAt(cl, this._list.length - 1);
    }

    public void insertAt(ArgStack cl, int index) {
        Arg insertInto = this._list[index];
        if (insertInto instanceof BasicArg) {
            cl.add(insertInto);
            this._list[index] = new SetArg(cl);
            this._hasSet = true;
        } else if (insertInto instanceof SetArg) {
            ((SetArg)insertInto).add(cl);
        } else {
            System.out.println("Problem inserting arg stack: " + cl);
        }
    }

    public int size() {
        return this._list.length;
    }

    public boolean containsDollarArg() {
        return this._hasDollar;
    }

    public boolean containsSetArg() {
        return this._hasSet;
    }

    public Arg get(int i) {
        return this._list[i];
    }

    public void set(int i, Arg c) {
        this._list[i] = c;
        if (c instanceof Dollar) {
            this._hasDollar = true;
        } else if (c instanceof SetArg) {
            this._hasSet = true;
        }
    }

    public Arg getLast() {
        return this._list[this._list.length - 1];
    }

    public void setLast(Arg c) {
        this.set(this._list.length - 1, c);
    }

    public void setSlashHarmonicCompositionResult(boolean harmonicResult) {
        for (int i = 0; i < this._list.length; ++i) {
            this._list[i].setSlashHarmonicCompositionResult(harmonicResult);
        }
    }

    public ArgStack copy() {
        Arg[] $list = new Arg[this._list.length];
        for (int i = 0; i < $list.length; ++i) {
            $list[i] = this._list[i].copy();
        }
        return new ArgStack($list);
    }

    public ArgStack copyWithout(int indexToRemove) {
        Arg[] $list = new Arg[this._list.length - 1];
        if ($list.length < 1) {
            System.out.println("Removing last item from an argument stack!");
        }
        int index = 0;
        for (int i = 0; i < this._list.length; ++i) {
            if (i == indexToRemove) continue;
            $list[index++] = this._list[i].copy();
        }
        return new ArgStack($list);
    }

    public ArgStack subList(int from) {
        return this.subList(from, this._list.length);
    }

    public ArgStack subList(int from, int upto) {
        Arg[] $list;
        if (upto > from) {
            $list = new Arg[upto - from];
            int index = 0;
            for (int i = from; i < upto; ++i) {
                $list[index++] = this._list[i];
            }
        } else {
            $list = new Arg[]{};
        }
        return new ArgStack($list);
    }

    public ArgStack shallowCopy() {
        return new ArgStack(this._list);
    }

    public boolean occurs(Variable v) {
        for (int i = 0; i < this._list.length; ++i) {
            if (!this._list[i].occurs(v)) continue;
            return true;
        }
        return false;
    }

    public ArgStack fill(Substitution s) throws UnifyFailure {
        ArgStack args = new ArgStack();
        for (int i = 0; i < this._list.length; ++i) {
            Object value = this._list[i].fill(s);
            if (value instanceof ArgStack) {
                args.add((ArgStack)value);
                continue;
            }
            args.add((Arg)value);
        }
        return args;
    }

    public void deepMap(ModFcn mf) {
        for (int i = 0; i < this._list.length; ++i) {
            this._list[i].deepMap(mf);
        }
    }

    public boolean containsContrarySlash() {
        for (int i = 0; i < this._list.length; ++i) {
            if (this._list[i] instanceof BasicArg && !((BasicArg)this._list[i]).getSlash().sameDirAsModality()) {
                return true;
            }
            if (!(this._list[i] instanceof SetArg) || !((SetArg)this._list[i]).containsContrarySlash()) continue;
            return true;
        }
        return false;
    }

    public void slashesUnify(Slash s) throws UnifyFailure {
        for (int i = 0; i < this._list.length; ++i) {
            this._list[i].unifySlash(s);
        }
    }

    public int unifySuffix(ArgStack as, Substitution sub) throws UnifyFailure {
        int asIndex = as.size();
        for (int i = this._list.length - 1; i >= 0; --i) {
            this.get(i).unify(as.get(--asIndex), sub);
        }
        return asIndex;
    }

    public ArgStack unify(ArgStack as, Substitution sub) throws UnifyFailure {
        return this.unifyPrefix(as, as.size(), sub);
    }

    public ArgStack unifyPrefix(ArgStack as, int upto, Substitution sub) throws UnifyFailure {
        ArgStack $args = this.containsDollarArg() ? (as.containsDollarArg() ? this.unifyDollarWithDollar(as, upto, sub) : this.unifyDollarWithNoDollar(this.size(), as, upto, sub)) : (as.containsDollarArg() ? as.unifyDollarWithNoDollar(upto, this, this.size(), sub) : (this.size() == upto ? this.unifySimple(as, upto, sub) : this.unifyComplex(as, upto, sub)));
        return $args;
    }

    private ArgStack unifySimple(ArgStack as, int upto, Substitution sub) throws UnifyFailure {
        ArgStack $args = new ArgStack();
        for (int i = upto - 1; i >= 0; --i) {
            $args.addFront((Arg)this._list[i].unify(as.get(i), sub));
        }
        return $args;
    }

    private ArgStack unifyComplex(ArgStack as, int upto, Substitution sub) throws UnifyFailure {
        ArgStack $args = new ArgStack();
        int aIndex = this.size() - 1;
        int bIndex = upto - 1;
        while (aIndex >= 0 && bIndex >= 0) {
            Arg aArg = this.get(aIndex);
            Arg bArg = as.get(bIndex);
            if (aArg instanceof BasicArg && bArg instanceof BasicArg || aArg instanceof SetArg && bArg instanceof SetArg) {
                $args.addFront((Arg)aArg.unify(bArg, sub));
                --aIndex;
                --bIndex;
                continue;
            }
            if (aArg instanceof BasicArg && bArg instanceof SetArg) {
                int setsize = ((SetArg)bArg).size();
                if (setsize <= aIndex + 1) {
                    int stop = aIndex - setsize;
                    while (aIndex > stop) {
                        --aIndex;
                        if (bArg instanceof BasicArg) {
                            $args.addFront((Arg)aArg.unify(bArg, sub));
                            continue;
                        }
                        int idInSet = ((SetArg)bArg).indexOf((BasicArg)aArg);
                        if (idInSet == -1) {
                            throw new UnifyFailure();
                        }
                        $args.addFront((Arg)aArg.unify(((SetArg)bArg).get(idInSet), sub));
                        aArg = this.get(aIndex);
                        bArg = ((SetArg)bArg).copyWithout(idInSet);
                    }
                    --bIndex;
                    continue;
                }
                throw new UnifyFailure();
            }
            if (aArg instanceof SetArg && bArg instanceof BasicArg) {
                throw new UnifyFailure();
            }
            throw new UnifyFailure();
        }
        if (aIndex > -1 || bIndex > -1) {
            throw new UnifyFailure();
        }
        return $args;
    }

    private ArgStack unifyDollarWithNoDollar(int uptoThis, ArgStack otherStack, int uptoOther, Substitution sub) throws UnifyFailure {
        if (!this._hasSet && !otherStack._hasSet && uptoThis > uptoOther + 1 || uptoThis > 1 && uptoOther < 1) {
            throw new UnifyFailure();
        }
        ArgStack $args = new ArgStack();
        otherStack = otherStack.subList(0, uptoOther);
        int otherIndex = uptoOther - 1;
        for (int i = uptoThis - 1; i >= 0; --i) {
            Arg argi = this.get(i);
            if (argi instanceof Dollar) {
                if (i > 0) {
                    throw new UnifyFailure();
                }
                ArgStack $subArgs = otherStack.subList(0, otherIndex + 1);
                ((Dollar)argi).unify($subArgs.copy(), sub);
                otherIndex = 0;
                $args.addFront($subArgs);
                continue;
            }
            if (argi instanceof BasicArg) {
                if (otherIndex < 0) {
                    throw new UnifyFailure();
                }
                Arg otherArg = otherStack.get(otherIndex);
                if (otherArg instanceof BasicArg) {
                    $args.addFront((Arg)argi.unify(otherArg, sub));
                    --otherIndex;
                    continue;
                }
                if (!(otherArg instanceof SetArg)) continue;
                SetArg sa = (SetArg)otherArg;
                int id = sa.indexOf((BasicArg)argi);
                if (id == -1) {
                    throw new UnifyFailure();
                }
                $args.addFront((Arg)argi.unify(sa.get(id), sub));
                otherStack.set(otherIndex, sa.copyWithout(id));
                continue;
            }
            throw new UnifyFailure();
        }
        if (otherIndex > 0) {
            throw new UnifyFailure();
        }
        return $args;
    }

    private ArgStack unifyDollarWithDollar(ArgStack as, int upto, Substitution sub) throws UnifyFailure {
        ArgStack $args;
        if (this.size() == 1) {
            $args = as.subList(0, upto);
            ((Dollar)this.get(0)).unify($args.copy(), sub);
        } else if (upto == 1) {
            $args = this.subList(0, this.size());
            ((Dollar)as.get(0)).unify($args.copy(), sub);
        } else if (upto == this.size()) {
            $args = this.unifySimple(as, upto, sub);
        } else {
            throw new UnifyFailure();
        }
        return $args;
    }

    public void forall(CategoryFcn fcn) {
        for (int i = 0; i < this._list.length; ++i) {
            this._list[i].forall(fcn);
        }
    }

    private void checkForDollar() {
        for (int i = 0; i < this._list.length; ++i) {
            if (!(this._list[i] instanceof Dollar)) continue;
            this._hasDollar = true;
            return;
        }
    }

    private void checkForSet() {
        for (int i = 0; i < this._list.length; ++i) {
            if (!(this._list[i] instanceof SetArg)) continue;
            this._hasSet = true;
            return;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._list.length; ++i) {
            sb.append(this._list[i].toString());
        }
        return sb.toString();
    }

    public String getSupertag() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._list.length; ++i) {
            Arg arg = this._list[i];
            sb.append(arg.getSupertag());
        }
        return sb.toString();
    }

    public String toTeX() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._list.length; ++i) {
            sb.append(this._list[i].toTeX());
        }
        return sb.toString();
    }

    public int hashCode(TObjectIntHashMap varMap) {
        int retval = 0;
        for (int i = 0; i < this._list.length; ++i) {
            retval += this._list[i].hashCode(varMap);
        }
        return retval;
    }

    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ArgStack as = (ArgStack)obj;
        if (this._list.length != as._list.length) {
            return false;
        }
        for (int i = 0; i < this._list.length; ++i) {
            if (this._list[i].equals(as._list[i], varMap, varMap2)) continue;
            return false;
        }
        return true;
    }

    protected static int insert(Arg[] a, Arg[] b, int pos) {
        for (int i = 0; i < a.length; ++i) {
            b[pos++] = a[i];
        }
        return pos;
    }
}

