/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.ml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.supertagger.ml.FeatureExtractor;
import opennlp.ccg.parse.supertagger.ml.STFex;
import opennlp.ccg.parse.tagger.TaggedWord;
import opennlp.ccg.parse.tagger.io.PipeDelimitedFactoredBundleCorpusIterator;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.util.Pair;

public class ZhangLeTrainingExtractor {
    private File outputF;
    private Iterator<List<Word>> incorp;
    private FeatureExtractor fexer = new STFex();

    public ZhangLeTrainingExtractor(File corpus, File outputF, String tokenisation) {
        this(corpus, outputF, tokenisation, new STFex());
    }

    public ZhangLeTrainingExtractor(File corpus, File outputF, String tokenisation, FeatureExtractor fexer) {
        this.fexer = fexer;
        this.outputF = outputF;
        try {
            this.incorp = tokenisation.equalsIgnoreCase("srilm") ? new SRILMFactoredBundleCorpusIterator(new BufferedReader(new FileReader(corpus))) : new PipeDelimitedFactoredBundleCorpusIterator(new BufferedReader(new FileReader(corpus)));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ZhangLeTrainingExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFeats() {
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(this.outputF));
            }
            catch (IOException ex) {
                Logger.getLogger(ZhangLeTrainingExtractor.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (bw != null || this.incorp != null) {
                List<Word> sent = null;
                TreeMap<Integer, TaggedWord> snt = null;
                Iterator<List<Word>> sents = this.incorp;
                while (sents.hasNext()) {
                    sent = sents.next();
                    int index = 0;
                    snt = new TreeMap<Integer, TaggedWord>();
                    for (Word word : sent) {
                        snt.put(index++, new TaggedWord(word));
                    }
                    for (Collection collection : this.fexer.getSentenceFeatures(snt, true)) {
                        try {
                            boolean isLabel = true;
                            for (Pair ftWAct : collection) {
                                if (isLabel) {
                                    bw.write((String)ftWAct.a + " ");
                                    isLabel = false;
                                    continue;
                                }
                                bw.write((String)ftWAct.a + ":" + (Double)ftWAct.b + " ");
                            }
                            bw.newLine();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ZhangLeTrainingExtractor.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
        finally {
            try {
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ZhangLeTrainingExtractor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

