/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.util.List;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.realize.DiversityPruningStrategy;
import opennlp.ccg.synsem.Sign;

public class NgramDiversityPruningStrategy
extends DiversityPruningStrategy {
    protected int order;

    public NgramDiversityPruningStrategy(int order) {
        this(order, true);
    }

    public NgramDiversityPruningStrategy(int order, boolean singleBestPerGroup) {
        this.order = order;
        this.singleBestPerGroup = singleBestPerGroup;
    }

    @Override
    public boolean notCompellinglyDifferent(Sign sign1, Sign sign2) {
        List<Word> words1 = sign1.getWords();
        List<Word> words2 = sign2.getWords();
        int words1Len = words1.size();
        int words2Len = words2.size();
        for (int i = 0; i < this.order - 1 && i < words1Len && i < words2Len; ++i) {
            if (words1.get(i) == words2.get(i)) continue;
            return false;
        }
        int wordsLenDiff = words1Len - words2Len;
        for (int i = words1Len - 1; i > words1Len - this.order && i >= 0 && i >= wordsLenDiff; --i) {
            int j = i - wordsLenDiff;
            if (words1.get(i) == words2.get(j)) continue;
            return false;
        }
        return true;
    }
}

