/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.Collection;
import java.util.Set;
import opennlp.ccg.disjunctivizer.MatchType;
import opennlp.ccg.disjunctivizer.MatchTypeFilter;
import opennlp.ccg.hylo.graph.LFEdge;

public class AlignedEdgeFilter
extends MatchTypeFilter {
    Set<Integer> alignmentIndices;

    public AlignedEdgeFilter(Set<Integer> alignmentIndices, MatchType ... matchTypes) {
        super(matchTypes);
        this.checkAlignmentIndices(alignmentIndices);
        this.alignmentIndices = alignmentIndices;
    }

    public AlignedEdgeFilter(Set<Integer> alignmentIndices, Collection<MatchType> matchTypes) {
        super(matchTypes);
        this.checkAlignmentIndices(alignmentIndices);
        this.alignmentIndices = alignmentIndices;
    }

    private void checkAlignmentIndices(Set<Integer> alignmentIndices) {
        if (alignmentIndices == null) {
            throw new IllegalArgumentException("alignmentIndices is null");
        }
    }

    public Set<Integer> getAlignmentIndices() {
        return this.alignmentIndices;
    }

    public void setAlignmentIndices(Set<Integer> alignmentIndices) {
        this.checkAlignmentIndices(alignmentIndices);
        this.alignmentIndices = alignmentIndices;
    }

    @Override
    public boolean allows(LFEdge edge) {
        for (MatchType t : this.matchTypes) {
            if (t == MatchType.SOURCE_ALIGNED && !this.alignmentIndices.contains(edge.getSource().getIndex())) {
                return false;
            }
            if (t == MatchType.SOURCE_UNALIGNED && this.alignmentIndices.contains(edge.getSource().getIndex())) {
                return false;
            }
            if (t == MatchType.TARGET_ALIGNED && !this.alignmentIndices.contains(edge.getTarget().getIndex())) {
                return false;
            }
            if (t != MatchType.TARGET_UNALIGNED || !this.alignmentIndices.contains(edge.getTarget().getIndex())) continue;
            return false;
        }
        return true;
    }
}

