/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.util.AbstractList;
import java.util.List;

public class Phrase
extends AbstractList<String>
implements Comparable<Phrase> {
    final Integer number;
    final String id;
    final String[] words;

    public Phrase(Integer number, List<String> words) {
        this(number, words.toArray(new String[words.size()]));
    }

    public Phrase(Integer number, String ... words) {
        this(null, number, words);
    }

    public Phrase(String id, Integer number, List<String> words) {
        this(id, number, words.toArray(new String[words.size()]));
    }

    public Phrase(String id, Integer number, String ... words) {
        this.checkObject(number, "number");
        this.checkObject(words, "words");
        for (int i = 0; i < words.length; ++i) {
            this.checkObject(words[i], "word " + i);
        }
        this.number = number;
        this.id = id;
        this.words = words;
    }

    void checkObject(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public String getId() {
        return this.id;
    }

    public Integer getNumber() {
        return this.number;
    }

    @Override
    public String get(int index) {
        return this.words[index];
    }

    @Override
    public int size() {
        return this.words.length;
    }

    @Override
    public int compareTo(Phrase o) {
        return this.getNumber().compareTo(o.getNumber());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Phrase && super.equals(o)) {
            Phrase p = (Phrase)o;
            return this.number.equals(p.number) && (this.id == null && p.id == null || this.id.equals(p.id));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 31 * super.hashCode() + this.number.hashCode();
        return this.id == null ? h : h + this.id.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.number.toString());
        if (this.id != null) {
            sb.append(" (");
            sb.append(this.id);
            sb.append(')');
        }
        sb.append(": ");
        sb.append(super.toString());
        return sb.toString();
    }
}

