/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.extract.ExtractGrammar;
import opennlp.ccgbank.extract.FreqTally;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.jdom.JDOMException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LexExtract {
    public static void extractLex(ExtractGrammar.ExtractionProperties extractProps) throws TransformerException, TransformerConfigurationException, SAXException, IOException, JDOMException {
        System.out.println("Extracting lexicon info:");
        File lexFile = new File(new File(extractProps.destDir), "lexicon.xml");
        File tempFile = new File(new File(extractProps.tempDir), "temp.xml");
        PrintWriter tempOut = new PrintWriter(new FileOutputStream(tempFile), true);
        File ccgbankDir = new File(extractProps.srcDir);
        Object[] ccgbankSections = ccgbankDir.listFiles();
        Arrays.sort(ccgbankSections);
        FreqTally.CAT_FREQ_CUTOFF = extractProps.catFreqCutoff;
        FreqTally.LEX_FREQ_CUTOFF = extractProps.lexFreqCutoff;
        FreqTally.OPEN_FREQ_CUTOFF = extractProps.openFreqCutoff;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer lexExtrTransformer = tFactory.newTransformer(ExtractGrammar.getSource("opennlp.ccgbank/transform/lexExtr.xsl"));
        tempOut.println("<ccg-lexicon>");
        for (int i = extractProps.startSection; i <= extractProps.endSection; ++i) {
            System.out.println("Section " + ((File)ccgbankSections[i]).getName());
            Object[] files = ((File)ccgbankSections[i]).listFiles();
            Arrays.sort(files);
            int fileStart = 0;
            int fileLimit = files.length;
            if (extractProps.fileNum >= 0) {
                fileStart = extractProps.fileNum;
                fileLimit = extractProps.fileNum + 1;
            }
            for (int j = fileStart; j < fileLimit; ++j) {
                String inputFile = ((File)files[j]).getAbsolutePath();
                if (j == fileStart) {
                    System.out.print(((File)files[j]).getName() + " ");
                } else if (j == fileLimit - 1) {
                    System.out.println(" " + ((File)files[j]).getName());
                } else {
                    System.out.print(".");
                }
                if (fileStart == fileLimit - 1) {
                    System.out.println();
                }
                try {
                    lexExtrTransformer.transform(new StreamSource(inputFile), new StreamResult(tempOut));
                }
                catch (Exception exc) {
                    System.out.println("Skipping: " + inputFile);
                    System.out.println(exc.toString());
                }
                tempOut.flush();
            }
        }
        tempOut.println("</ccg-lexicon>");
        tempOut.flush();
        tempOut.close();
        FreqTally.printTally(extractProps);
        System.out.println("Generating lexicon.xml");
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            XMLFilter xmlFilter0 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/filterLex.xsl"));
            XMLFilter xmlFilter1 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/closedCatInsert.xsl"));
            XMLFilter xmlFilter2 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/insertLF.xsl"));
            XMLFilter xmlFilter3 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/insertPunctLF.xsl"));
            XMLFilter xmlFilter4 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/insertOrigPunctsLF.xsl"));
            XMLFilter xmlFilter5 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/addFilterLexFeats.xsl"));
            XMLFilter xmlFilter6 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/insertSemFeats.xsl"));
            XMLFilter xmlFilter7 = saxTFactory.newXMLFilter(ExtractGrammar.getSource("opennlp.ccgbank/transform/markUnmatched.xsl"));
            XMLReader reader = XMLReaderFactory.createXMLReader();
            xmlFilter0.setParent(reader);
            xmlFilter1.setParent(xmlFilter0);
            xmlFilter2.setParent(xmlFilter1);
            xmlFilter3.setParent(xmlFilter2);
            if (extractProps.lexF) {
                xmlFilter5.setParent(xmlFilter3);
                xmlFilter6.setParent(xmlFilter5);
            } else if (extractProps.origPuncts) {
                xmlFilter4.setParent(xmlFilter2);
                xmlFilter6.setParent(xmlFilter4);
            } else {
                xmlFilter6.setParent(xmlFilter3);
            }
            xmlFilter7.setParent(xmlFilter6);
            XMLFilter xmlFilter = xmlFilter7;
            Properties xmlProps = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            xmlProps.setProperty("indent", "yes");
            xmlProps.setProperty("standalone", "no");
            xmlProps.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            Serializer serializer = SerializerFactory.getSerializer((Properties)xmlProps);
            serializer.setOutputStream((OutputStream)new FileOutputStream(lexFile));
            xmlFilter.setContentHandler(serializer.asContentHandler());
            xmlFilter.parse(new InputSource(tempFile.getPath()));
        }
    }
}

