/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import opennlp.ccgbank.CCGBankTaskSources;
import opennlp.ccgbank.CCGBankTaskTemplates;
import opennlp.ccgbank.XSLTProcessor;
import opennlp.ccgbank.parse.TokenMgrError;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class CCGBankTask
extends Task
implements TaskContainer,
ErrorHandler,
ErrorListener {
    File target;
    Set<CCGBankTaskSources> ccgBankTaskSources = new HashSet<CCGBankTaskSources>();
    List<CCGBankTaskTemplates> ccgBankTaskTemplates = new ArrayList<CCGBankTaskTemplates>();
    XSLTProcessor xsltProcessor = null;
    boolean useXMLFilter = true;
    boolean terminateOnError = true;
    boolean terminateOnWarning = false;
    int directoriesProcessed;
    int filesProcessed;
    int warnings;
    int errors;

    public void addTask(Task task) {
        throw new BuildException("nested task \"" + task.getTaskName() + "\" not supported, only sourcesSet or xsltProcessors");
    }

    public void setTarget(File target) {
        this.target = target;
        if (target == null) {
            throw new BuildException("no target specified");
        }
        if (!target.exists()) {
            target.mkdirs();
        } else if (!target.isDirectory()) {
            throw new BuildException("specified target is not a directory");
        }
    }

    public void setTerminateOnError(boolean terminateOnError) {
        this.terminateOnError = terminateOnError;
    }

    public void setTerminateOnWarning(boolean terminateOnWarning) {
        this.terminateOnWarning = terminateOnWarning;
    }

    public void setUseXMLFilter(boolean useXMLFilter) {
        this.useXMLFilter = useXMLFilter;
    }

    public void addConfiguredSources(CCGBankTaskSources sources) {
        this.ccgBankTaskSources.add(sources);
    }

    public void addConfiguredTemplates(CCGBankTaskTemplates templates) {
        this.ccgBankTaskTemplates.add(templates);
    }

    protected void start() throws BuildException {
    }

    protected void finish() throws BuildException {
    }

    protected void nextDirectory(File section) throws BuildException {
    }

    protected InputSource nextFile(File file) throws BuildException {
        try {
            return new InputSource(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException fnfe) {
            throw new BuildException("Unable to find file " + file, (Throwable)fnfe, this.getLocation());
        }
    }

    @Override
    public void error(SAXParseException exception) {
        ++this.errors;
        this.handleError("Error", exception, this.terminateOnError);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        ++this.errors;
        this.handleError("Fatal error", exception, this.terminateOnError);
    }

    @Override
    public void warning(SAXParseException exception) {
        ++this.warnings;
        this.handleError("Warning", exception, this.terminateOnWarning);
    }

    @Override
    public void error(TransformerException exception) {
        ++this.errors;
        this.handleError("Error", exception, this.terminateOnError);
    }

    @Override
    public void fatalError(TransformerException exception) {
        ++this.errors;
        this.handleError("Fatal error", exception, this.terminateOnError);
    }

    @Override
    public void warning(TransformerException exception) {
        ++this.warnings;
        this.handleError("Warning", exception, this.terminateOnWarning);
    }

    void handleError(String prefix, SAXParseException spe, boolean terminate) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(": problem in parse: ");
        sb.append(spe.getSystemId());
        sb.append(" on line ");
        sb.append(spe.getLineNumber());
        sb.append(", column ");
        sb.append(spe.getColumnNumber());
        sb.append(": ");
        sb.append(spe.getMessage());
        if (terminate) {
            throw new BuildException(sb.toString(), (Throwable)spe, this.getLocation());
        }
        this.log(sb.toString());
    }

    void handleError(String prefix, TransformerException te, boolean terminate) {
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(": problem in transform: ");
        sb.append(te.getMessageAndLocation());
        if (terminate) {
            throw new BuildException(sb.toString(), (Throwable)te, this.getLocation());
        }
        this.log(sb.toString());
    }

    public void execute() throws BuildException {
        if (this.ccgBankTaskSources.isEmpty()) {
            throw new BuildException("no sourcesSet specified");
        }
        this.errors = 0;
        this.warnings = 0;
        this.directoriesProcessed = 0;
        this.filesProcessed = 0;
        this.start();
        this.log("Target: " + this.target);
        if (this.xsltProcessor == null) {
            throw new BuildException("null XSLT processor");
        }
        this.xsltProcessor.addAllTemplates(this.ccgBankTaskTemplates);
        try {
            for (CCGBankTaskSources sources : this.ccgBankTaskSources) {
                File prevDir = null;
                File currentDir = null;
                for (File file : sources) {
                    currentDir = file.getParentFile();
                    if (!currentDir.equals(prevDir)) {
                        this.log("Processing " + currentDir + " ...");
                        ++this.directoriesProcessed;
                        this.nextDirectory(currentDir);
                    }
                    prevDir = currentDir;
                    this.log("Processing " + file);
                    ++this.filesProcessed;
                    this.xsltProcessor.process(this.nextFile(file));
                }
            }
        }
        catch (IOException io) {
            throw new BuildException("I/O problem during processing: " + io.getMessage(), (Throwable)io, this.getLocation());
        }
        catch (SAXException se) {
            throw new BuildException("Problem during processing: " + se.getMessage(), (Throwable)se, this.getLocation());
        }
        catch (TransformerException te) {
            throw new BuildException("I/O problem during processing: " + te.getMessageAndLocation(), (Throwable)te, this.getLocation());
        }
        catch (TokenMgrError te) {
            throw new BuildException("I/O problem during processing: " + te.getMessage(), (Throwable)te, this.getLocation());
        }
        finally {
            this.finish();
            StringBuilder sb = new StringBuilder("Processed ");
            sb.append(this.filesProcessed);
            sb.append(" files in ");
            sb.append(this.directoriesProcessed);
            sb.append(" directories with ");
            sb.append(this.errors);
            sb.append(" error");
            if (this.errors != 1) {
                sb.append('s');
            }
            sb.append(" and ");
            sb.append(this.warnings);
            sb.append(" warning");
            if (this.warnings != 1) {
                sb.append('s');
            }
            this.log(sb.toString());
        }
    }
}

