/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.parse.postagger.ml.POSPriorModel;
import opennlp.ccg.parse.tagger.util.ConfigFileProcessor;
import opennlp.ccg.parse.tagger.util.ResultSink;
import opennlp.ccg.realize.hypertagger.TagExtractor;
import opennlp.ccg.realize.hypertagger.ZLMaxentModel;
import opennlp.ccg.util.Pair;

public class ZLPOSTagger
extends TagExtractor {
    ZLMaxentModel model;
    POSPriorModel priorModel;
    int prefixLength = 4;
    int suffixLength = 4;
    double beta = 0.35;
    private HashMap<String, String> goldPred2Tag = new HashMap();

    public ZLPOSTagger() {
    }

    public ZLPOSTagger(ZLMaxentModel model) {
        this();
        this.model = model;
        this.prefixLength = 4;
        this.suffixLength = 4;
        this.beta = 0.35;
    }

    public ZLPOSTagger(ZLMaxentModel model, POSPriorModel priorModel) {
        this();
        this.model = model;
        this.prefixLength = 4;
        this.suffixLength = 4;
        this.beta = 0.35;
        this.priorModel = priorModel;
    }

    public POSPriorModel getPriorModel() {
        return this.priorModel;
    }

    public void setPriorModel(POSPriorModel priorModel) {
        this.priorModel = priorModel;
    }

    @Override
    protected TagExtractor.FeatureList getFeatures(TagExtractor.LfGraphNode n) {
        String basePredName;
        TagExtractor.FeatureList feats = new TagExtractor.FeatureList(this);
        int argchildren = 0;
        feats.addFeature("PN", n.getPredicateName());
        feats.addFeature("FO", Integer.toString(n.getNumChildren()));
        if (n.getMultiParents().size() > 0) {
            for (TagExtractor.LfGraphNode parent : n.getMultiParents()) {
                feats.addFeature("RN", parent.getPredicateName());
                String cls = parent.getPred().getNominal().toString();
                if (cls == null || cls.indexOf(58) <= 0) continue;
                String cfeat = cls.substring(cls.indexOf(58) + 1);
                feats.addFeature("XP", cfeat);
            }
        } else {
            feats.addFeature("RN", "0");
        }
        for (TagExtractor.LfGraphLink lnk : n.getChildren()) {
            feats.addFeature("CT", lnk.getLabel());
            if (lnk.getTarget() == null) continue;
            feats.addFeature("CN", lnk.getTarget().getPredicateName());
            String shortArgName = (String)this.argNameMap.get(lnk.getLabel());
            if (shortArgName == null) continue;
            ++argchildren;
            feats.addFeature(shortArgName + "N", lnk.getTarget().getPredicateName());
            String cls = lnk.getTarget().getPred().getNominal().toString();
            if (cls.indexOf(58) <= 0) continue;
            String cfeat = cls.substring(cls.indexOf(58) + 1);
            String argNumOrName = shortArgName.startsWith("A") ? shortArgName.substring(1) : shortArgName;
            feats.addFeature("X" + argNumOrName + "D", cfeat);
        }
        feats.addFeature("NA", Integer.toString(argchildren));
        Nominal idx = n.getPred().getNominal();
        String cls = idx.toString();
        if (cls.indexOf(58) > 0) {
            String cfeat = cls.substring(cls.indexOf(58) + 1);
            feats.addFeature("XC", cfeat);
        }
        String predname = n.getPredicateName();
        Pattern pat = Pattern.compile("(\\w+)\\.\\d+$");
        Matcher mat = pat.matcher(basePredName = new String(predname));
        if (mat.matches()) {
            basePredName = mat.group(1);
        }
        if (basePredName.length() > this.prefixLength + 1) {
            String prefix = predname.substring(0, this.prefixLength);
            feats.addFeature("PX", prefix);
        }
        if (basePredName.length() > this.suffixLength + 1) {
            String suffix = basePredName.substring(basePredName.length() - this.suffixLength, basePredName.length());
            feats.addFeature("SX", suffix);
        }
        if (basePredName.matches("\\d+")) {
            feats.addFeature("HD", "1");
        } else {
            feats.addFeature("HD", "0");
        }
        if (predname.matches("[A-Z]+") || predname.matches("-+")) {
            if (predname != "PASS") {
                feats.addFeature("UH", "1");
            } else {
                feats.addFeature("UH", "0");
            }
        } else {
            feats.addFeature("UH", "0");
        }
        if (this.priorModel != null) {
            List<Pair<Double, String>> priors = this.priorModel.getPriors(predname);
            double beta = 0.1;
            double best = (Double)priors.get((int)0).a;
            for (Pair<Double, String> prior : priors) {
                if (!((Double)prior.a > beta * best)) break;
                feats.addFeatureWithProb("PPOS", (String)prior.b, (Double)prior.a);
            }
        }
        return feats;
    }

    @Override
    public TagExtractor.FeatureList getFeatures(int index) {
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            if (n.getIndex() != index) continue;
            return this.getFeatures(n);
        }
        return null;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public int getSuffixLength() {
        return this.suffixLength;
    }

    public void setSuffixLength(int suffixLength) {
        this.suffixLength = suffixLength;
    }

    @Override
    public String getAllFeaturesAndAnswer() {
        StringBuilder output = new StringBuilder();
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            String feats = this.getFeatures(n).getAllFeatures();
            String postag = this.goldPred2Tag.get(n.getPred().getNominal().getName());
            output = output.append(postag + " ");
            output = output.append(feats);
            output = output.append("\n");
        }
        return output.toString();
    }

    public String getAllFeaturesAndPOSWithID() {
        String output = "";
        for (TagExtractor.LfGraphNode n : this.nomTable.values()) {
            String feats = this.getFeatures(n).getAllFeatures();
            String postag = n.getPred().getOrigin().getPOS();
            output = output.concat("<" + Integer.toString(LFID) + "> " + postag + " " + feats);
            output = output.concat(postag + " ");
            output = output.concat(feats);
            output = output.concat("\n");
        }
        return output;
    }

    public ArrayList<Pair<String, Double>> getBetaBestPOS(TagExtractor.FeatureList feats) {
        ArrayList<Pair<String, Double>> poss = new ArrayList<Pair<String, Double>>();
        ArrayList<ProbIndexPair> probList = new ArrayList<ProbIndexPair>();
        double[] probs = this.model.eval(feats.getAllFeaturesForMaxent(), true);
        for (int i = 0; i < probs.length; ++i) {
            probList.add(new ProbIndexPair(probs[i], i));
        }
        Collections.sort(probList);
        Collections.reverse(probList);
        double maxProb = ((ProbIndexPair)probList.get((int)0)).prob;
        for (int i = 0; i < probList.size(); ++i) {
            if (!(((ProbIndexPair)probList.get((int)i)).prob >= this.beta * maxProb)) continue;
            poss.add(new Pair<String, Double>(this.model.getOutcome(((ProbIndexPair)probList.get((int)i)).index), ((ProbIndexPair)probList.get((int)i)).prob));
        }
        return poss;
    }

    public ArrayList<Pair<String, Double>> getBetaBestPOS(String[] feats) {
        ArrayList<Pair<String, Double>> poss = new ArrayList<Pair<String, Double>>();
        ArrayList<ProbIndexPair> probList = new ArrayList<ProbIndexPair>();
        double[] probs = this.model.eval(feats, true);
        for (int i = 0; i < probs.length; ++i) {
            probList.add(new ProbIndexPair(probs[i], i));
        }
        Collections.sort(probList);
        Collections.reverse(probList);
        double maxProb = ((ProbIndexPair)probList.get((int)0)).prob;
        for (int i = 0; i < probList.size(); ++i) {
            if (!(((ProbIndexPair)probList.get((int)i)).prob >= this.beta * maxProb)) continue;
            poss.add(new Pair<String, Double>(this.model.getOutcome(((ProbIndexPair)probList.get((int)i)).index), ((ProbIndexPair)probList.get((int)i)).prob));
        }
        return poss;
    }

    public String getBestPOS(TagExtractor.FeatureList feats) {
        double[] probs = this.model.eval(feats.getAllFeaturesForMaxent(), false);
        return new String(this.model.getBestOutcome(probs));
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Override
    public void storeGoldStdPredInfo(String predInfo) {
        String[] preds = predInfo.split("\\s+");
        if (preds != null) {
            for (int i = 1; i < preds.length; ++i) {
                String[] info = preds[i].split(":");
                if (info.length != 4) {
                    System.err.println("Malformed pred-info field, skipping (value was \"" + preds[i] + "\")");
                    continue;
                }
                this.goldPred2Tag.put(info[0], DefaultTokenizer.unescape(info[2]));
            }
        }
    }

    @Override
    public void loadPriorModel(File priorModelFile, File vocabFile) {
        try {
            this.priorModel = new POSPriorModel(priorModelFile.getAbsolutePath(), vocabFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Unable to load prior model or vocab file");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String usage = "\nBasicPOSTagger -c <configFile> (-i <input>) (-o <output> [defaults to <stdout>])\n                 (-b beta value) (-m model file)\n";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        BufferedReader inp = null;
        BufferedWriter out = null;
        try {
            String line;
            String inputCorp = null;
            String configFile = null;
            String output = null;
            String modelFile = null;
            double beta = 0.0;
            boolean test = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i")) {
                    inputCorp = args[++i];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-c")) {
                    configFile = args[++i];
                    continue;
                }
                if (args[i].equals("-m")) {
                    modelFile = args[++i];
                    continue;
                }
                if (args[i].equals("-b")) {
                    beta = Double.parseDouble(args[++i]);
                    continue;
                }
                System.out.println("Unrecognized option: " + args[i]);
            }
            ResultSink rs = new ResultSink(ResultSink.ResultSinkType.POSTAG);
            try {
                inp = new BufferedReader(new FileReader(new File(inputCorp)));
            }
            catch (FileNotFoundException ex) {
                System.err.print("Input corpus " + inputCorp + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            try {
                out = output.equals("<stdout>") ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(new File(output)));
            }
            catch (IOException ex) {
                System.err.print("Output file " + output + " not found.  Exiting...");
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(-1);
            }
            ZLPOSTagger post = new ZLPOSTagger(new ZLMaxentModel(modelFile));
            if (beta > 0.0) {
                post.setBeta(beta);
            }
            int count = 0;
            int wins = 0;
            int tagsPerPred = 0;
            block16: while ((line = inp.readLine()) != null) {
                ++count;
                int pos = line.indexOf(32);
                String gs = line.substring(0, pos);
                String[] feats = line.substring(pos + 1).split("\\s+");
                ArrayList<Pair<String, Double>> ptags = post.getBetaBestPOS(feats);
                tagsPerPred += ptags.size();
                for (Pair<String, Double> p : ptags) {
                    if (!((String)p.a).equals(gs)) continue;
                    ++wins;
                    continue block16;
                }
            }
            out.write("Beta: " + post.getBeta() + "\n");
            out.write("Acc: " + (double)wins / (double)count * 100.0 + "\n");
            out.write("Tags/Pred: " + (double)tagsPerPred / (double)count + "\n");
            out.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                inp.close();
                out.close();
            }
            catch (IOException ex) {
                Logger.getLogger(POSPriorModel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static ZLPOSTagger ZLPOSTaggerFactory(String configFile) throws IOException {
        String modelFile;
        ZLPOSTagger postagger = new ZLPOSTagger();
        String[] pathKeys = new String[]{"priormodel", "priormodelvocab", "maxentmodel"};
        Map<String, String> opts = ConfigFileProcessor.readInConfig(configFile, pathKeys);
        String priorModelFile = opts.get("priormodel");
        if (priorModelFile != null) {
            String vocabFile = opts.get("priormodelvocab");
            if (vocabFile == null) {
                throw new IOException("A vocab file must be specified.");
            }
            postagger.loadPriorModel(new File(priorModelFile), new File(vocabFile));
        }
        if ((modelFile = opts.get("maxentmodel")) == null) {
            throw new IOException("You must specify the maxent model to use.");
        }
        postagger.model = new ZLMaxentModel(modelFile);
        String betaString = opts.get("beta");
        if (betaString != null) {
            double beta;
            postagger.beta = beta = Double.parseDouble(betaString);
        }
        return postagger;
    }

    public class ProbIndexPair
    implements Comparable<ProbIndexPair> {
        public double prob;
        public int index;

        public ProbIndexPair(double prob, int index) {
            this.prob = prob;
            this.index = index;
        }

        @Override
        public int compareTo(ProbIndexPair o) {
            if (this.prob < o.prob) {
                return -1;
            }
            if (this.prob == o.prob) {
                return 0;
            }
            return 1;
        }
    }
}

