/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.util.Set;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.realize.DiversityPruningStrategy;
import opennlp.ccg.synsem.Sign;

public class LexicalDiversityPruningStrategy
extends DiversityPruningStrategy {
    protected Set<String> posValsToUse = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set<String> stemsSeen = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());

    public LexicalDiversityPruningStrategy() {
        String[] poslist;
        for (String pos : poslist = new String[]{"JJ", "JJR", "JJS", "NN", "NNP", "NNS", "NNPS", "RB", "RBR", "RBS", "VB", "VBD", "VBG", "VBN", "VBP", "VBZ"}) {
            this.posValsToUse.add(pos);
        }
    }

    @Override
    public boolean notCompellinglyDifferent(Sign sign1, Sign sign2) {
        this.stemsSeen.clear();
        for (Word w : sign1.getWords()) {
            if (!this.posValsToUse.contains(w.getPOS())) continue;
            this.stemsSeen.add(w.getStem());
        }
        for (Word w : sign2.getWords()) {
            if (!this.posValsToUse.contains(w.getPOS()) || this.stemsSeen.contains(w.getStem())) continue;
            return false;
        }
        return true;
    }
}

