/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.AbstractStandardNgramModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.util.TrieMap;

public class StandardNgramModel
extends AbstractStandardNgramModel {
    public StandardNgramModel(int order, Reader in, boolean useSemClasses) throws IOException {
        super(order, useSemClasses);
        this.numNgrams = new int[order];
        this.readModel(in);
    }

    public StandardNgramModel(int order, Reader in) throws IOException {
        this(order, in, false);
    }

    public StandardNgramModel(int order, String filename, boolean useSemClasses) throws IOException {
        this(order, new BufferedReader(new FileReader(filename)), useSemClasses);
    }

    public StandardNgramModel(int order, String filename) throws IOException {
        this(order, filename, false);
    }

    private void readModel(Reader in) throws IOException {
        StreamTokenizer tokenizer = StandardNgramModel.initTokenizer(in);
        String[] tokens = new String[this.order + 2];
        boolean foundData = false;
        int currentOrder = 0;
        ArrayList<Object> currentPrefix = new ArrayList<Object>();
        ArrayList<Object> currentKeys = null;
        ArrayList<TrieMap<Object, NgramScorer.NgramFloats>> currentChildren = null;
        while (tokenizer.ttype != -1) {
            int i;
            StandardNgramModel.readLine(tokenizer, tokens);
            if (tokens[0] == null) continue;
            if (tokens[0].equals("\\data\\")) {
                foundData = true;
                continue;
            }
            if (!foundData) continue;
            if (tokens[0].equals("ngram")) {
                int n = Integer.parseInt(tokens[1].substring(0, 1));
                int total = Integer.parseInt(tokens[1].substring(2));
                if (n > this.order) continue;
                this.numNgrams[n - 1] = total;
                if (currentChildren == null) {
                    currentChildren = new ArrayList<TrieMap<Object, NgramScorer.NgramFloats>>(total);
                    currentKeys = new ArrayList<Object>(total);
                }
                if (n != this.order) continue;
                int totalNgrams = 0;
                for (i = 0; i < this.order; ++i) {
                    totalNgrams += this.numNgrams[i];
                }
                continue;
            }
            if (tokens[0].equals("\\end\\")) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                break;
            }
            if (tokens[0].equals("\\" + (currentOrder + 1) + "-grams:")) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                ++currentOrder;
                continue;
            }
            if (currentOrder == 0) continue;
            if (currentOrder > this.order) break;
            float logprob = Float.parseFloat(tokens[0]);
            float bow = 0.0f;
            if (currentOrder < this.order && tokens[currentOrder + 1] != null) {
                bow = Float.parseFloat(tokens[currentOrder + 1]);
            }
            for (int i2 = 1; i2 < currentOrder + 1; ++i2) {
                tokens[i2] = tokens[i2].intern();
            }
            boolean samePrefix = currentPrefix.size() == currentOrder - 1;
            for (i = 1; samePrefix && i < currentOrder; ++i) {
                if (tokens[i] == currentPrefix.get(i - 1)) continue;
                samePrefix = false;
            }
            if (!samePrefix) {
                this.addTrieMapChildren(currentPrefix, currentKeys, currentChildren);
                for (i = 1; i < currentOrder; ++i) {
                    currentPrefix.add(tokens[i]);
                }
            }
            String key = tokens[currentOrder];
            currentKeys.add(key);
            currentChildren.add(new TrieMap(new NgramScorer.NgramFloats(logprob, bow)));
        }
        this.openVocab = this.trieMapRoot.getChild("<unk>") != null;
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java opennlp.ccg.ngrams.StandardNgramModel <order> <lmfile> <tokens> (-reverse)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        long start2 = System.currentTimeMillis();
        String order = args[0];
        String lmfile = args[1];
        String tokens = args[2];
        String reversed = args.length >= 4 && args[3].equals("-reverse") ? "reversed " : "";
        System.out.println("Loading " + reversed + "n-gram model with order " + order + " from: " + lmfile);
        StandardNgramModel lm = new StandardNgramModel(Integer.parseInt(order), lmfile);
        if (reversed.length() > 0) {
            lm.setReverse(true);
        }
        System.out.println("openVocab: " + lm.openVocab);
        int secs = (int)(System.currentTimeMillis() - start2) / 1000;
        System.out.println("secs: " + secs);
        System.out.println();
        DefaultTokenizer tokenizer = new DefaultTokenizer();
        List<Word> words = tokenizer.tokenize(tokens);
        System.out.println("scoring: " + tokens);
        System.out.println();
        lm.debugScore = true;
        lm.setWordsToScore(words, true);
        lm.prepareToScoreWords();
        double logprob = lm.logprob();
        double score = StandardNgramModel.convertToProb(logprob);
        System.out.println();
        System.out.println("score: " + score);
        System.out.println("logprob: " + logprob);
        System.out.println("ppl: " + NgramScorer.convertToPPL(logprob / (double)(words.size() - 1)));
    }
}

