/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.ngrams.AbstractStandardNgramModel;
import opennlp.ccg.ngrams.NgramScorer;
import opennlp.ccg.ngrams.SRILMNgramModelType;

public class SRILMNgramModel
extends AbstractStandardNgramModel {
    public SRILMNgramModel(int order, File lmFile, boolean useSemClasses, SRILMNgramModelType modelType) throws IOException {
        super(order, useSemClasses);
        this.loadLMFromFile(order, lmFile, modelType);
    }

    public SRILMNgramModel(int order, File lmFile, SRILMNgramModelType modelType) throws IOException {
        this(order, lmFile, false, modelType);
    }

    protected void loadLMFromFile(int ngramOrder, File lmFile, SRILMNgramModelType lmType) throws IOException {
        if (lmFile == null) {
            throw new IOException("null file");
        }
        if (!lmFile.exists()) {
            throw new IOException("file does not exist: " + lmFile);
        }
        if (lmFile.isDirectory()) {
            throw new IOException("file is a directory: " + lmFile);
        }
        if (!lmFile.canRead()) {
            throw new IOException("unable to read file: " + lmFile);
        }
        this.loadLM(ngramOrder, lmFile.getAbsolutePath(), lmType.ordinal());
    }

    @Override
    public float logProb(int pos, int len) {
        try {
            String[] context;
            List range = this.keysList.subList(pos, pos + len);
            int rangeSize = range.size();
            if (rangeSize == 0) {
                throw new IllegalArgumentException("empty range specified for log prob");
            }
            String[] stringArray = context = rangeSize > 1 ? new String[rangeSize - 1] : null;
            if (context != null) {
                ListIterator contextIterator = range.listIterator(rangeSize - 1);
                int i = 0;
                while (contextIterator.hasPrevious()) {
                    context[i++] = contextIterator.previous().toString();
                }
            }
            return this.doLogProb(range.get(rangeSize - 1).toString(), context);
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    private native void loadLM(int var1, String var2, int var3) throws IOException;

    private native float doLogProb(String var1, String[] var2);

    protected native void finalize() throws Throwable;

    public static void main(String[] args) throws Exception {
        String usage = "Usage: java opennlp.ccg.ngrams.SRILMNgramModel <order> <lmfile> <lmtype> <tokens> (-reverse)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println(usage);
            return;
        }
        long start2 = System.currentTimeMillis();
        String order = args[0];
        String lmfile = args[1];
        String lmType = args[2];
        String tokens = args[3];
        String reversed = args.length >= 5 && args[4].equals("-reverse") ? "reversed " : "";
        System.out.println("Loading " + reversed + "n-gram model with order " + order + " from: " + lmfile);
        SRILMNgramModel lm = new SRILMNgramModel(Integer.parseInt(order), new File(lmfile), SRILMNgramModelType.valueOf(lmType));
        if (reversed.length() > 0) {
            lm.setReverse(true);
        }
        System.out.println("openVocab: " + lm.openVocab);
        int secs = (int)(System.currentTimeMillis() - start2) / 1000;
        System.out.println("secs: " + secs);
        System.out.println();
        DefaultTokenizer tokenizer = new DefaultTokenizer();
        List<Word> words = tokenizer.tokenize(tokens);
        System.out.println("scoring: " + tokens);
        System.out.println();
        lm.debugScore = true;
        lm.setWordsToScore(words, true);
        lm.prepareToScoreWords();
        double logprob = lm.logprob();
        double score = SRILMNgramModel.convertToProb(logprob);
        System.out.println();
        System.out.println("score: " + score);
        System.out.println("logprob: " + logprob);
        System.out.println("ppl: " + NgramScorer.convertToPPL(logprob / (double)(words.size() - 1)));
    }

    static {
        System.loadLibrary("srilmbridge");
    }
}

