/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import opennlp.ccg.hylo.Alt;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.HyloVar;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.Op;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.util.ListMap;

public class Flattener {
    private List<SatOp> preds = new ArrayList<SatOp>();
    private int altCount = 0;
    private int optCount = 0;
    private List<SatOp> roots = new ArrayList<SatOp>();
    private ListMap<SatOp, SatOp> childMap = new ListMap(true);
    private Map<Nominal, SatOp> nomMap = new HashMap<Nominal, SatOp>();
    private Map<Nominal, Integer> depthMap = new HashMap<Nominal, Integer>();
    private Map<Nominal, Nominal> parentMap = new HashMap<Nominal, Nominal>();
    private static Nominal nullNom = new NominalAtom("null");
    private static Proposition nullProp = new Proposition("null");

    public Map<Nominal, Nominal> getHighestParentMap() {
        return this.parentMap;
    }

    public List<SatOp> flatten(LF lf) {
        this.flatten(lf, null, null, 0, new Stack<Alt>(), new TIntArrayList());
        if (this.altCount > 0 || this.optCount > 0) {
            this.propAltsOptsChunks();
        }
        return this.preds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flatten(LF lf, Nominal currentNominal, SatOp parent, int depth, Stack<Alt> alts, TIntArrayList opts) {
        if (lf instanceof SatOp) {
            SatOp satOp = (SatOp)lf;
            currentNominal = satOp.getNominal();
            SatOp dummyParent = Flattener.makeDummySatOp(currentNominal);
            this.addSatOp(dummyParent, parent, depth, alts, opts, lf);
            this.flatten(satOp.getArg(), currentNominal, dummyParent, depth, alts, opts);
            return;
        } else if (lf instanceof Op) {
            Op op2 = (Op)lf;
            SatOp dummyParent = Flattener.makeDummySatOp(currentNominal);
            this.addSatOp(dummyParent, parent, depth, alts, opts, lf);
            if (op2._name.equals("xor")) {
                int altSet = this.altCount++;
                for (int i = 0; i < op2._args.size(); ++i) {
                    alts.push(new Alt(altSet, i));
                    LF arg = op2._args.get(i);
                    this.flatten(arg, currentNominal, dummyParent, depth + 1, alts, opts);
                    alts.pop();
                }
                return;
            } else if (op2._name.equals("opt")) {
                opts.add(this.optCount++);
                LF arg = op2._args.get(0);
                this.flatten(arg, currentNominal, dummyParent, depth + 1, alts, opts);
                opts.remove(opts.size() - 1);
                return;
            } else {
                Iterator<LF> it = op2.getArguments().iterator();
                while (it.hasNext()) {
                    this.flatten(it.next(), currentNominal, dummyParent, depth + 1, alts, opts);
                }
            }
            return;
        } else if (lf instanceof Proposition) {
            if (currentNominal == null) {
                throw new RuntimeException("No current nominal in trying to flatten " + lf);
            }
            SatOp satOp = new SatOp(currentNominal, lf);
            this.addSatOp(satOp, parent, depth, alts, opts, lf);
            return;
        } else {
            if (lf instanceof HyloVar) return;
            if (!(lf instanceof Diamond)) throw new RuntimeException("Unable to flatten " + lf);
            Diamond diamond = (Diamond)lf;
            LF arg = diamond.getArg();
            if (arg instanceof Proposition || arg instanceof Nominal || arg instanceof HyloVar) {
                SatOp satOp = new SatOp(currentNominal, lf);
                this.addSatOp(satOp, parent, depth, alts, opts, lf);
                return;
            } else if (arg instanceof Op && ((Op)arg)._name.equals("conj")) {
                Op argOp = (Op)arg;
                Iterator<LF> args = argOp._args.iterator();
                LF firstArg = args.next();
                if (!(firstArg instanceof Nominal)) {
                    throw new RuntimeException("First arg of diamond is not a nominal: " + firstArg);
                }
                Nominal firstNominalArg = (Nominal)firstArg;
                SatOp satOp = new SatOp(currentNominal, new Diamond(diamond.getMode(), firstNominalArg));
                this.addSatOp(satOp, parent, depth, alts, opts, lf);
                while (args.hasNext()) {
                    this.flatten(args.next(), firstNominalArg, satOp, depth + 1, alts, opts);
                }
                return;
            } else {
                if (!(arg instanceof Op) || !((Op)arg)._name.equals("xor")) throw new RuntimeException("Arg of diamond is not a proposition, nominal or list: " + arg);
                Op argOp = (Op)arg;
                SatOp dummyParent = Flattener.makeDummySatOp(currentNominal);
                this.addSatOp(dummyParent, parent, depth, alts, opts, lf);
                int altSet = this.altCount++;
                for (int i = 0; i < argOp._args.size(); ++i) {
                    alts.push(new Alt(altSet, i));
                    LF disjunct = argOp._args.get(i);
                    if (!(disjunct instanceof Op && ((Op)disjunct)._name.equals("conj") || disjunct instanceof Nominal)) {
                        throw new RuntimeException("Disjunct of diamond is not a conj op or nominal: " + disjunct);
                    }
                    if (disjunct instanceof Op) {
                        Op disjunctOp = (Op)disjunct;
                        Iterator<LF> args = disjunctOp._args.iterator();
                        LF firstArg = args.next();
                        if (!(firstArg instanceof Nominal)) {
                            throw new RuntimeException("First arg of conj op under xor op is not a nominal: " + firstArg);
                        }
                        Nominal disjunctNominal = (Nominal)firstArg;
                        SatOp satOp = new SatOp(currentNominal, new Diamond(diamond.getMode(), disjunctNominal));
                        this.addSatOp(satOp, dummyParent, depth + 1, alts, opts, lf);
                        while (args.hasNext()) {
                            this.flatten(args.next(), disjunctNominal, satOp, depth + 2, alts, opts);
                        }
                    } else {
                        Nominal disjunctNominal = (Nominal)disjunct;
                        SatOp satOp = new SatOp(currentNominal, new Diamond(diamond.getMode(), disjunctNominal));
                        this.addSatOp(satOp, dummyParent, depth + 1, alts, opts, lf);
                    }
                    alts.pop();
                }
            }
        }
    }

    private static SatOp makeDummySatOp(Nominal nom) {
        return new SatOp(nom != null ? nom : nullNom, nullProp);
    }

    private void addSatOp(SatOp satOp, SatOp parent, int depth, Stack<Alt> alts, TIntArrayList opts, LF lf) {
        if (satOp._arg != nullProp) {
            this.preds.add(satOp);
        }
        if (parent == null) {
            this.roots.add(satOp);
        } else {
            this.childMap.put(parent, satOp);
        }
        Nominal nom = satOp._nominal;
        if (!(nom.isShared() || this.nomMap.containsKey(nom) && depth >= this.depthMap.get(nom))) {
            this.nomMap.put(nom, satOp);
            this.depthMap.put(nom, depth);
            this.parentMap.put(nom, parent != null && parent._nominal != nullNom ? parent._nominal : null);
        }
        if (!alts.empty()) {
            satOp.alts = new ArrayList<Alt>(alts);
        }
        if (opts.size() > 0) {
            satOp.opts = new TIntArrayList(opts.toNativeArray());
        }
        satOp.setChunks(lf.getChunks());
    }

    private void propAltsOptsChunks() {
        List<Alt> alts = Collections.emptyList();
        TIntArrayList opts = new TIntArrayList(0);
        TIntArrayList chunks = new TIntArrayList(0);
        for (SatOp root : this.roots) {
            this.propAltsOptsChunks(root, alts, opts, chunks);
        }
    }

    private void propAltsOptsChunks(SatOp satOp, List<Alt> alts, TIntArrayList opts, TIntArrayList chunks) {
        SatOp nom2Pred;
        Nominal nom2;
        SatOp nomPred;
        Nominal nom;
        if (!alts.isEmpty()) {
            if (satOp.alts == null) {
                satOp.alts = new ArrayList<Alt>(3);
            }
            for (Alt alt : alts) {
                if (satOp.alts.contains(alt)) continue;
                satOp.alts.add(alt);
            }
            Collections.sort(satOp.alts);
        }
        if (!opts.isEmpty()) {
            if (satOp.opts == null) {
                satOp.opts = new TIntArrayList(3);
            }
            for (int i = 0; i < opts.size(); ++i) {
                int opt = opts.get(i);
                if (satOp.opts.contains(opt)) continue;
                satOp.opts.add(opt);
            }
            satOp.opts.sort();
        }
        if (!chunks.isEmpty()) {
            if (satOp.chunks == null) {
                satOp.chunks = new TIntArrayList(3);
            }
            for (int i = 0; i < chunks.size(); ++i) {
                int chunk = chunks.get(i);
                if (satOp.chunks.contains(chunk)) continue;
                satOp.chunks.add(chunk);
            }
            satOp.chunks.sort();
        }
        List<Alt> alts2 = satOp.alts != null ? satOp.alts : alts;
        TIntArrayList opts2 = satOp.opts != null ? satOp.opts : opts;
        TIntArrayList chunks2 = satOp.chunks != null ? satOp.chunks : chunks;
        List<SatOp> children = this.childMap.get(satOp);
        if (children != null) {
            for (SatOp child : children) {
                this.propAltsOptsChunks(child, alts2, opts2, chunks2);
            }
        }
        if ((nom = satOp._nominal).isShared() && (nomPred = this.nomMap.get(nom)) != null) {
            this.propAltsOptsChunks(nomPred, alts2, opts2, chunks2);
        }
        if ((nom2 = HyloHelper.getSecondaryNominal(satOp)) != null && nom2.isShared() && (nom2Pred = this.nomMap.get(nom2)) != null) {
            this.propAltsOptsChunks(nom2Pred, alts2, opts2, chunks2);
        }
    }
}

