/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import opennlp.ccg.alignment.AbstractEncodingScheme;
import opennlp.ccg.alignment.Mapping;
import opennlp.ccg.alignment.MappingFormat;
import opennlp.ccg.alignment.MappingGroup;

public class MappingWriter
extends FilterWriter {
    final MappingFormat format;
    private MappingGroup currentGroup;
    private int mappingCount = 0;
    private String mappingDelimiter;
    private String groupDelimiter;

    public MappingWriter(Writer out, MappingFormat format) {
        super(out);
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        this.format = format;
    }

    public MappingFormat getFormat() {
        return this.format;
    }

    public MappingGroup getCurrentGroup() {
        return this.currentGroup;
    }

    void checkWrite() throws IOException {
        if (!this.canWrite()) {
            throw new IOException("unable to write");
        }
    }

    void checkMappingCount() throws IOException {
        if (this.currentGroup != null && this.mappingCount != this.currentGroup.length) {
            throw new IOException("incorrect mapping count for group " + this.currentGroup.phraseNumber + "; expected " + this.currentGroup.length + ", but was " + this.mappingCount);
        }
    }

    public void startGroup(MappingGroup mappingGroup) throws IOException {
        if (this.currentGroup != null) {
            this.endGroup();
        }
        this.currentGroup = mappingGroup;
    }

    public void endGroup() throws IOException {
        if (this.currentGroup == null) {
            throw new IOException("no current group");
        }
        this.checkMappingCount();
        if (this.currentGroup.length > 0) {
            if (this.groupDelimiter == null) {
                Character gd = this.format.encodingScheme.getGroupDelimiter();
                this.groupDelimiter = AbstractEncodingScheme.isLineSeparator(gd) ? System.getProperty("line.separator") : String.valueOf(gd);
            }
            this.out.write(this.groupDelimiter);
        }
        this.currentGroup = null;
        this.mappingCount = 0;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.checkWrite();
        super.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.checkWrite();
        super.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.checkWrite();
        super.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.checkWrite();
        super.write(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        this.checkWrite();
        super.write(str);
    }

    public boolean canWrite() {
        return this.currentGroup != null && this.mappingCount < this.currentGroup.length;
    }

    public void writeMapping(Mapping mapping) throws IOException {
        this.checkWrite();
        if (mapping == null) {
            throw new NullPointerException("null mapping");
        }
        if (mapping.phraseNumber != null && !mapping.phraseNumber.equals(this.currentGroup.phraseNumber)) {
            throw new IOException("mapping from group " + mapping.phraseNumber + ", but current group is " + this.currentGroup.phraseNumber);
        }
        if (this.mappingCount > 0) {
            if (this.mappingDelimiter == null) {
                Character md = this.format.encodingScheme.getMappingDelimiter();
                this.mappingDelimiter = AbstractEncodingScheme.isLineSeparator(md) ? System.getProperty("line.separator") : String.valueOf(md);
            }
            this.out.write(this.mappingDelimiter);
        }
        this.out.write(this.format.formatMapping(mapping));
        ++this.mappingCount;
    }

    @Override
    public void close() throws IOException {
        try {
            this.checkMappingCount();
        }
        finally {
            super.close();
        }
    }
}

