/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.ccg.alignment.EncodingScheme;
import opennlp.ccg.alignment.IndexBase;
import opennlp.ccg.alignment.MappingFormat;

public abstract class AbstractEncodingScheme
implements EncodingScheme {
    protected Character fieldDelimiter;
    protected Character mappingDelimiter;
    protected Character groupDelimiter;
    protected IndexBase phraseNumberBase;
    protected IndexBase indexBase;
    protected List<MappingFormat.Field> order;
    protected Set<MappingFormat.Field> required;
    protected Set<MappingFormat.Field> defaults;
    final boolean fieldDelimSep;
    final boolean mappingDelimSep;
    final boolean groupDelimSep;

    protected AbstractEncodingScheme(Character fieldDelimiter, Character mappingDelimiter, Character groupDelimiter, IndexBase phraseNumberBase, IndexBase indexBase, Set<MappingFormat.Field> defaults, Set<MappingFormat.Field> required, MappingFormat.Field ... order) {
        this.fieldDelimiter = fieldDelimiter;
        this.mappingDelimiter = mappingDelimiter;
        this.groupDelimiter = groupDelimiter;
        this.phraseNumberBase = phraseNumberBase;
        this.indexBase = indexBase;
        this.fieldDelimSep = AbstractEncodingScheme.isLineSeparator(fieldDelimiter);
        this.mappingDelimSep = AbstractEncodingScheme.isLineSeparator(mappingDelimiter);
        this.groupDelimSep = AbstractEncodingScheme.isLineSeparator(groupDelimiter);
        this.defaults = Collections.unmodifiableSet(defaults);
        this.required = Collections.unmodifiableSet(required);
        this.order = Collections.unmodifiableList(Arrays.asList(order));
    }

    static boolean isLineSeparator(Character c) {
        return c.charValue() == '\r' || c.charValue() == '\n';
    }

    @Override
    public boolean isFieldDelimiter(Character c) {
        return this.fieldDelimiter.equals(c) || this.fieldDelimSep && AbstractEncodingScheme.isLineSeparator(c);
    }

    @Override
    public boolean isMappingDelimiter(Character c) {
        return this.mappingDelimiter.equals(c) || this.mappingDelimSep && AbstractEncodingScheme.isLineSeparator(c);
    }

    @Override
    public boolean isGroupDelimiter(Character c) {
        return this.groupDelimiter.equals(c) || this.groupDelimSep && AbstractEncodingScheme.isLineSeparator(c);
    }

    @Override
    public Character getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    @Override
    public Character getMappingDelimiter() {
        return this.mappingDelimiter;
    }

    @Override
    public Character getGroupDelimiter() {
        return this.groupDelimiter;
    }

    @Override
    public IndexBase getPhraseNumberBase() {
        return this.phraseNumberBase;
    }

    @Override
    public IndexBase getIndexBase() {
        return this.indexBase;
    }

    @Override
    public List<MappingFormat.Field> getOrder() {
        return this.order;
    }

    @Override
    public Set<MappingFormat.Field> getRequired() {
        return this.required;
    }

    @Override
    public Set<MappingFormat.Field> getDefaults() {
        return this.defaults;
    }

    public int hashCode() {
        return 37 * this.fieldDelimiter.hashCode() + this.groupDelimiter.hashCode() + this.mappingDelimiter.hashCode() + this.indexBase.hashCode() + this.phraseNumberBase.hashCode() + this.order.hashCode() + this.required.hashCode() + this.defaults.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractEncodingScheme) {
            AbstractEncodingScheme e = (AbstractEncodingScheme)obj;
            return this.fieldDelimiter.equals(e.fieldDelimiter) && this.groupDelimiter.equals(e.groupDelimiter) && this.mappingDelimiter.equals(e.mappingDelimiter) && this.indexBase.equals((Object)e.indexBase) && this.phraseNumberBase.equals((Object)e.phraseNumberBase) && this.order.equals(e.order) && this.required.equals(e.required) && this.defaults.equals(e.defaults);
        }
        return false;
    }
}

