/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ListMap<KeyType, ValType> {
    private THashMap map;

    public ListMap() {
        this(false);
    }

    public ListMap(boolean useIdentityEquals) {
        this.map = useIdentityEquals ? new THashMap((TObjectHashingStrategy)new TObjectIdentityHashingStrategy()) : new THashMap();
    }

    public Object put(KeyType key, ValType value) {
        Object currentVal = this.map.get(key);
        if (currentVal == null) {
            this.map.put(key, value);
        } else if (currentVal instanceof List) {
            List list = (List)currentVal;
            list.add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(currentVal);
            list.add(value);
            this.map.put(key, list);
        }
        return null;
    }

    public List<ValType> get(KeyType key) {
        Object val = this.map.get(key);
        if (val == null || val instanceof List) {
            return (List)val;
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(val);
        this.map.put(key, list);
        return list;
    }

    public void putAll(KeyType key, Collection<ValType> vals) {
        for (ValType val : vals) {
            this.put(key, val);
        }
    }

    public int size() {
        return this.map.size();
    }

    public Set<KeyType> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(KeyType key) {
        return this.map.containsKey(key);
    }

    List<ValType> remove(KeyType key) {
        List<ValType> retval = this.get(key);
        this.map.remove(key);
        return retval;
    }
}

