/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.ngrams.NgramPrecisionModel;
import opennlp.ccg.realize.PruningStrategy;
import opennlp.ccg.realize.Realizer;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.test.Regression;
import opennlp.ccg.test.RegressionInfo;
import opennlp.ccg.test.ScorerMaker;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CrossValidateRealizer
implements ScorerMaker {
    public Regression tester = null;
    public String tmpdir = "tmp";
    private File tmpDir = null;
    public double numFolds = 10.0;
    public ScorerMaker scorerMaker = this;
    public PruningStrategy pruningStrategy = null;

    public CrossValidateRealizer(URL grammarURL) throws IOException {
        this.tester = new Regression();
        System.out.println("Loading grammar from URL: " + grammarURL);
        this.tester.grammar = new Grammar(grammarURL);
        System.out.println();
    }

    public void setupInputs(URL testbedURL) throws IOException {
        this.tmpDir = new File(this.tmpdir);
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdirs();
        }
        try {
            System.out.println("Loading testbed from URL: " + testbedURL);
            SAXBuilder builder = new SAXBuilder();
            Document inputDoc = builder.build(testbedURL.openStream());
            System.out.println();
            Element inputRoot = inputDoc.getRootElement();
            List inputItems = inputRoot.getChildren("item");
            System.out.println("Setting up inputs in tmpdir: " + this.tmpdir);
            Document shuffledDoc = new Document();
            Element shuffledRoot = new Element("regression");
            shuffledDoc.setRootElement(shuffledRoot);
            Random rand = new Random();
            while (inputItems.size() > 0) {
                Element rItem = (Element)inputItems.remove(rand.nextInt(inputItems.size()));
                shuffledRoot.addContent((Content)rItem);
            }
            FileOutputStream shuffledOut = new FileOutputStream(new File(this.tmpDir, "shuffled.xml"));
            this.tester.grammar.serializeXml(shuffledDoc, shuffledOut);
            shuffledOut.close();
            List shuffledItems = shuffledRoot.getChildren("item");
            int numItems = shuffledItems.size();
            Element[] shuffledItemsArray = new Element[numItems];
            shuffledItems.toArray(shuffledItemsArray);
            Element[] shuffledLFsArray = new Element[numItems];
            for (int i = 0; i < numItems; ++i) {
                Element item = shuffledItemsArray[i];
                shuffledLFsArray[i] = item.getChild("lf");
                Element fullWords = item.getChild("full-words");
                item.setContent((Collection)null);
                if (fullWords == null) continue;
                item.addContent((Content)fullWords);
            }
            int itemsPerFold = (int)Math.floor((double)numItems / (this.numFolds * 1.0));
            HashSet<String> testStrings = new HashSet<String>();
            int dups = 0;
            int i = 0;
            while ((double)i < this.numFolds) {
                testStrings.clear();
                dups = 0;
                int foldStart = i * itemsPerFold;
                int foldLimit = (double)i < this.numFolds - 1.0 ? foldStart + itemsPerFold : numItems;
                Document testDoc = new Document();
                Element testRoot = new Element("regression");
                testDoc.setRootElement(testRoot);
                Document trainDoc = new Document();
                Element trainRoot = new Element("regression");
                trainDoc.setRootElement(trainRoot);
                for (int j = 0; j < numItems; ++j) {
                    Element item = shuffledItemsArray[j];
                    item.detach();
                    Element lf = shuffledLFsArray[j];
                    if (foldStart <= j && j < foldLimit) {
                        testRoot.addContent((Content)item);
                        item.addContent((Content)lf);
                        testStrings.add(item.getAttributeValue("string"));
                        continue;
                    }
                    if (this.numFolds < 2.0 && i == 1 && j >= numItems - itemsPerFold) continue;
                    trainRoot.addContent((Content)item);
                }
                List trainingItems = trainRoot.getChildren("item");
                Iterator it = trainingItems.iterator();
                while (it.hasNext()) {
                    Element item = (Element)it.next();
                    if (!testStrings.contains(item.getAttributeValue("string"))) continue;
                    it.remove();
                    ++dups;
                }
                if (dups > 0) {
                    System.out.println("Removing " + dups + " test item duplicate(s) from training, fold " + i);
                }
                FileOutputStream testOut = new FileOutputStream(new File(this.tmpDir, this.testFileName(i)));
                this.tester.grammar.serializeXml(testDoc, testOut);
                testOut.close();
                FileOutputStream trainOut = new FileOutputStream(new File(this.tmpDir, this.trainingFileName(i)));
                this.tester.grammar.serializeXml(trainDoc, trainOut);
                trainOut.close();
                ++i;
            }
            System.out.println();
        }
        catch (JDOMException exc) {
            throw (IOException)new IOException().initCause(exc);
        }
    }

    private String trainingFileName(int foldNum) {
        return "fold" + foldNum + "-train.xml";
    }

    private String testFileName(int foldNum) {
        return "fold" + foldNum + "-test.xml";
    }

    public void prepScorers() throws IOException {
        if (this.tmpDir == null) {
            this.tmpDir = new File(this.tmpdir);
        }
        System.out.println("Preparing scorers in tmpdir: " + this.tmpdir);
        System.out.println();
        int i = 0;
        while ((double)i < this.numFolds) {
            File trainFile = new File(this.tmpDir, this.trainingFileName(i));
            File testFile = new File(this.tmpDir, this.testFileName(i));
            this.scorerMaker.prepScorer(this.tmpDir, i, trainFile, testFile);
            ++i;
        }
        this.scorerMaker.prepScorersSummary(this.tmpDir);
    }

    @Override
    public void setCVR(CrossValidateRealizer cvr) {
    }

    @Override
    public void prepScorer(File tmpDir, int foldNum, File trainFile, File testFile) throws IOException {
    }

    @Override
    public void prepScorersSummary(File tmpDir) throws IOException {
    }

    @Override
    public SignScorer loadScorer(File tmpDir, int foldNum, File trainFile) throws IOException {
        RegressionInfo trainingItems = new RegressionInfo(this.tester.grammar, trainFile);
        String[] targets = new String[trainingItems.numberOfItems()];
        for (int i = 0; i < trainingItems.numberOfItems(); ++i) {
            targets[i] = trainingItems.getItem((int)i).sentence;
        }
        NgramPrecisionModel retval = this.tester.ngramOrder > 0 ? new NgramPrecisionModel(targets, this.tester.ngramOrder, true) : new NgramPrecisionModel(targets, true);
        return retval;
    }

    public void runTest() throws IOException {
        if (this.tmpDir == null) {
            this.tmpDir = new File(this.tmpdir);
        }
        this.tester.doParsing = false;
        this.tester.showStats = false;
        this.tester.realizer = new Realizer(this.tester.grammar);
        if (this.pruningStrategy != null) {
            this.tester.realizer.pruningStrategy = this.pruningStrategy;
        }
        Regression.showRealizerSettings();
        int i = 0;
        while ((double)i < this.numFolds) {
            File trainFile = new File(this.tmpDir, this.trainingFileName(i));
            File testFile = new File(this.tmpDir, this.testFileName(i));
            this.tester.scorer = this.scorerMaker.loadScorer(this.tmpDir, i, trainFile);
            this.tester.runTest(testFile);
            ++i;
        }
        this.tester.showStats();
    }

    public static void main(String[] args) throws IOException {
        String usage = "java opennlp.ccg.test.CrossValidateRealizer (-folds N) (-tmp <tmpdir>) (-setuponly) (-skipsetup) (-preponly) (-skipprep) (-ngramorder N) (-scorermaker <scorermakerclass>) (-pruningstrategy <pruningstrategyclass>) (-g <grammarfile>) (-s <statsfile>) (<testbedfile>)";
        if (args.length > 0 && args[0].equals("-h")) {
            System.out.println("Usage: " + usage);
            System.exit(0);
        }
        double numFolds = 0.0;
        String tmpdir = null;
        boolean setupOnly = false;
        boolean skipSetup = false;
        boolean prepOnly = false;
        boolean skipPrep = false;
        int ngramOrder = 0;
        String scorerMakerClass = null;
        String pruningStrategyClass = null;
        String grammarfile = "grammar.xml";
        String testbedfile = "testbed.xml";
        String statsfile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-folds")) {
                if (!((numFolds = Double.parseDouble(args[++i])) < 1.0) && (!(numFolds >= 2.0) || numFolds == (double)Math.round(numFolds))) continue;
                System.out.println("Error, folds must be 1.x or an int of at least 2");
                System.exit(-1);
                continue;
            }
            if (args[i].equals("-tmp")) {
                tmpdir = args[++i];
                continue;
            }
            if (args[i].equals("-setuponly")) {
                setupOnly = true;
                continue;
            }
            if (args[i].equals("-skipsetup")) {
                skipSetup = true;
                continue;
            }
            if (args[i].equals("-preponly")) {
                prepOnly = true;
                continue;
            }
            if (args[i].equals("-skipprep")) {
                skipPrep = true;
                continue;
            }
            if (args[i].equals("-ngramorder")) {
                ngramOrder = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-scorermaker")) {
                scorerMakerClass = args[++i];
                continue;
            }
            if (args[i].equals("-pruningstrategy")) {
                pruningStrategyClass = args[++i];
                continue;
            }
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-s")) {
                statsfile = args[++i];
                continue;
            }
            testbedfile = args[i];
        }
        URL grammarURL = new File(grammarfile).toURI().toURL();
        CrossValidateRealizer cvr = new CrossValidateRealizer(grammarURL);
        if (numFolds > 0.0) {
            cvr.numFolds = numFolds;
        }
        if (tmpdir != null) {
            cvr.tmpdir = tmpdir;
        }
        if (ngramOrder > 0) {
            cvr.tester.ngramOrder = ngramOrder;
        }
        if (scorerMakerClass != null) {
            try {
                cvr.scorerMaker = (ScorerMaker)Class.forName(scorerMakerClass).newInstance();
                cvr.scorerMaker.setCVR(cvr);
            }
            catch (Exception exc) {
                throw (RuntimeException)new RuntimeException().initCause(exc);
            }
        }
        if (pruningStrategyClass != null) {
            try {
                cvr.pruningStrategy = (PruningStrategy)Class.forName(pruningStrategyClass).newInstance();
            }
            catch (Exception exc) {
                throw (RuntimeException)new RuntimeException().initCause(exc);
            }
        }
        if (statsfile != null) {
            cvr.tester.statsfile = statsfile;
        }
        URL testbedURL = new File(testbedfile).toURI().toURL();
        if (!skipSetup) {
            cvr.setupInputs(testbedURL);
        }
        if (setupOnly) {
            System.exit(0);
        }
        if (!skipPrep) {
            cvr.prepScorers();
        }
        if (prepOnly) {
            System.exit(0);
        }
        System.gc();
        cvr.runTest();
    }
}

