/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.ccg.realize.hypertagger.ItemMap;
import opennlp.ccg.realize.hypertagger.MyIntegerPool;
import opennlp.ccg.realize.hypertagger.ZPair;

public class ZLMaxentModel {
    private MyIntegerPool intPool = new MyIntegerPool(50000);
    private double doubMax = 1.79769E308;
    private ItemMap predMap = new ItemMap(this.intPool);
    private ItemMap outComeMap = new ItemMap(this.intPool);
    private Map<Integer, ArrayList<ZPair<Integer, Double>>> params = new HashMap<Integer, ArrayList<ZPair<Integer, Double>>>();
    private boolean loaded = false;
    private double[] probs;
    private int n_outcome;

    public ZLMaxentModel() {
    }

    public ZLMaxentModel(String modelFilename) {
        this.load(new File(modelFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File modelFile) {
        if (!this.loaded) {
            this.loaded = true;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(modelFile));
                String line = br.readLine();
                if (line.contains("#")) {
                    line = br.readLine();
                }
                int numPreds = Integer.parseInt(line.trim());
                for (int i = 0; i < numPreds; ++i) {
                    line = br.readLine().trim();
                    this.predMap.add(line);
                }
                line = br.readLine();
                int numOutcomes = Integer.parseInt(line);
                for (int j = 0; j < numOutcomes; ++j) {
                    line = br.readLine().trim();
                    this.outComeMap.add(line);
                }
                ArrayList tempParamsMap = new ArrayList();
                int numParameters = this.predMap.size();
                int fid = 0;
                String ln = "";
                for (int q = 0; q < numParameters; ++q) {
                    ln = br.readLine();
                    String[] lineParts = ln.split("\\s+");
                    ArrayList<ZPair<Integer, Integer>> prms = new ArrayList<ZPair<Integer, Integer>>();
                    for (int p = 1; p < lineParts.length; ++p) {
                        Integer oid = this.intPool.getInt(Integer.parseInt(lineParts[p]));
                        prms.add(new ZPair<Integer, Integer>(oid, this.intPool.getInt(fid)));
                        ++fid;
                    }
                    tempParamsMap.add(prms);
                }
                int nTheta = Integer.parseInt(br.readLine().trim());
                double[] theta = new double[nTheta];
                for (int z = 0; z < theta.length; ++z) {
                    theta[z] = Double.parseDouble(br.readLine().trim());
                }
                int index = 0;
                for (ArrayList arrayList : tempParamsMap) {
                    ArrayList tmpParamsList = new ArrayList();
                    for (ZPair mapping : arrayList) {
                        tmpParamsList.add(new ZPair(mapping.a, new Double(theta[(Integer)mapping.b])));
                    }
                    this.params.put(this.intPool.getInt(index), tmpParamsList);
                    ++index;
                }
                this.n_outcome = this.outComeMap.size();
                this.probs = new double[this.n_outcome];
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public String getBestOutcome(double[] probs) {
        double maxprob = 0.0;
        int maxidx = -1;
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] > maxprob)) continue;
            maxidx = i;
            maxprob = probs[i];
        }
        return this.getOutcome(maxidx);
    }

    public double[] eval(String[] context, boolean realValued) {
        for (int i = 0; i < this.probs.length; ++i) {
            this.probs[i] = 0.0;
        }
        ArrayList<ZPair<String, Double>> pred_value = new ArrayList<ZPair<String, Double>>(context.length);
        Double one = new Double(1.0);
        for (int m = 0; m < context.length; ++m) {
            if (realValued) {
                int splitPoint = context[m].lastIndexOf(":");
                pred_value.add(new ZPair<String, Double>(context[m].substring(0, splitPoint), Double.parseDouble(context[m].substring(splitPoint + 1, context[m].length()))));
                continue;
            }
            pred_value.add(new ZPair<String, Double>(context[m], one));
        }
        for (ZPair zPair : pred_value) {
            Integer predID = this.predMap.id((String)zPair.a);
            if (predID == null) continue;
            ArrayList<ZPair<Integer, Double>> featureWeights = this.params.get(predID);
            for (ZPair<Integer, Double> fw : featureWeights) {
                int n = (Integer)fw.a;
                this.probs[n] = this.probs[n] + (Double)fw.b * (Double)zPair.b;
            }
        }
        double sum = 0.0;
        for (int p = 0; p < this.probs.length; ++p) {
            try {
                this.probs[p] = Math.exp(this.probs[p]);
            }
            catch (Exception e) {
                this.probs[p] = this.doubMax;
            }
            sum += this.probs[p];
        }
        int q = 0;
        while (q < this.probs.length) {
            int n = q++;
            this.probs[n] = this.probs[n] / sum;
        }
        return this.probs;
    }

    public String getOutcome(int index) {
        return this.outComeMap.getItem(index);
    }
}

