/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.supertagger.WordAndPOSDictionaryLabellingStrategy;
import opennlp.ccg.parse.supertagger.io.XMLPOSDictionaryReader;
import opennlp.ccg.parse.supertagger.io.XMLWordDictionaryReader;
import opennlp.ccg.parse.supertagger.ml.STFex;
import opennlp.ccg.parse.supertagger.ml.STPriorModel;
import opennlp.ccg.parse.supertagger.ml.ZhangLeTrainingExtractor;
import opennlp.ccg.parse.supertagger.util.STTaggerPOSDictionary;
import opennlp.ccg.parse.supertagger.util.STTaggerWordDictionary;
import opennlp.ccg.parse.supertagger.util.TaggingDictionaryExtractor;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.io.CorpusIterator;
import opennlp.ccg.parse.tagger.io.PipeDelimitedFactoredBundleCorpusIterator;
import opennlp.ccg.parse.tagger.io.SRILMFactoredBundleCorpusIterator;
import opennlp.ccg.parse.tagger.ml.ZLMEM;
import opennlp.ccg.parse.tagger.util.ResultSink;
import opennlp.ccg.util.Pair;

public class JavaSupertaggingApp {
    public static void main(String[] args) throws Exception {
        try {
            OptionParser parser = new OptionParser();
            parser.acceptsAll(Arrays.asList("train", "R"), "extract training features.");
            parser.acceptsAll(Arrays.asList("tag", "T"), "supertag a POS-tagged file.");
            parser.acceptsAll(Arrays.asList("test", "E"), "test tagger against gold standard.");
            parser.acceptsAll(Arrays.asList("tagdictextract", "D"), "extract tagging dictionaries.");
            parser.acceptsAll(Arrays.asList("h", "?"), "show help.");
            ArgumentAcceptingOptionSpec tokenisation = parser.acceptsAll(Arrays.asList("delimiter", "d")).withRequiredArg().ofType(String.class).describedAs("SRILM factor bundles or C&C-style(pipe-delimited) factor bundles [choose one of: \"SRILM\", \"candc\"]");
            ArgumentAcceptingOptionSpec goldstandspec = parser.acceptsAll(Arrays.asList("g", "gold")).withRequiredArg().ofType(File.class).describedAs("the gold standard tagged file [file must have same bundle format as input corpus, \"SRILM\" or \"candc\"]");
            ArgumentAcceptingOptionSpec inputspec = parser.acceptsAll(Arrays.asList("i", "input")).withRequiredArg().ofType(File.class).describedAs("training or tagging/testing file");
            ArgumentAcceptingOptionSpec outputspec = parser.acceptsAll(Arrays.asList("o", "output")).withRequiredArg().ofType(File.class).describedAs("output location (for training feats or tags)");
            ArgumentAcceptingOptionSpec modspec = parser.acceptsAll(Arrays.asList("m", "model")).withRequiredArg().ofType(File.class).describedAs("textual model file (ZhangLe maxent-style) [for tagging/testing only]");
            ArgumentAcceptingOptionSpec priormodspec = parser.acceptsAll(Arrays.asList("priorModelF")).withRequiredArg().ofType(String.class).describedAs("config file for ARPA-formatted FLM [for tagging/testing and feature extractionMUST also give vocab file]");
            ArgumentAcceptingOptionSpec vocabspec = parser.acceptsAll(Arrays.asList("vocabF")).withRequiredArg().ofType(String.class).describedAs("vocab file for ARPA-formatted FLM [for tagging/testing and feature extraction]");
            ArgumentAcceptingOptionSpec kspec = parser.accepts("K").withRequiredArg().ofType(Integer.class).describedAs("K parameter of Clark and Curran [for tagging/testing only]");
            ArgumentAcceptingOptionSpec betaspec = parser.accepts("beta").withRequiredArg().ofType(Double.class).describedAs("beam width for supertagger [for tagging only]");
            ArgumentAcceptingOptionSpec wdictspec = parser.acceptsAll(Arrays.asList("w", "worddict")).withRequiredArg().ofType(File.class).describedAs("path to the word-based tagging dictionary file");
            ArgumentAcceptingOptionSpec pdictspec = parser.acceptsAll(Arrays.asList("p", "posdict")).withRequiredArg().ofType(File.class).describedAs("path to the POS-based tagging dictionary file");
            ArgumentAcceptingOptionSpec seqModel = parser.acceptsAll(Arrays.asList("s", "seqModel")).withOptionalArg().ofType(String.class).describedAs("the tag sequence model (for forward-backward tagging)");
            ArgumentAcceptingOptionSpec fbBeam = parser.acceptsAll(Arrays.asList("fbBeamWidth")).withOptionalArg().ofType(Integer.class).describedAs("maximum width of the forward-backward beam [default = 5]");
            ArgumentAcceptingOptionSpec tagAlgorithm = parser.acceptsAll(Arrays.asList("taggingAlgorithm")).withOptionalArg().ofType(String.class).describedAs("tagging algorithm. choose from {forward-backward, forward} [default = forward-backward]");
            OptionSet options = parser.parse(args);
            if (options.has("?") || args.length == 0) {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            assert (((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("candc") || ((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("srilm"));
            assert (options.has("tag") || options.has("train") || options.has("test") || options.has("D"));
            assert (!options.has("train") || !options.has("tag") && !options.has("test"));
            assert (!options.has("train") || !options.has("D"));
            assert (!options.has("tag") && !options.has("test") || !options.has("D"));
            assert (options.has("seqModel") || !options.has("seqInterp") && !options.has("fbBeamWidth"));
            assert (!options.has("train") || !options.has("m"));
            assert (!options.has("D") || !options.has("m"));
            assert (!options.has("tag") && !options.has("test") && !options.has("D") || options.has("p") && options.has("w"));
            assert (!options.has("tag") && !options.has("test") || options.has("K") && options.has("beta"));
            assert (!options.has("priorModelF") || options.has("vocabF") && options.has("p"));
            STPriorModel stPrior = null;
            if (options.has("priorModelF")) {
                stPrior = new STPriorModel((String)options.valueOf((OptionSpec)priormodspec), (String)options.valueOf((OptionSpec)vocabspec), new XMLPOSDictionaryReader((File)options.valueOf((OptionSpec)pdictspec)).read());
            }
            if (options.has("tag") || options.has("test")) {
                long start2 = System.currentTimeMillis();
                Double beta = (Double)options.valueOf((OptionSpec)betaspec);
                String seqMod = options.has("seqModel") ? (String)options.valueOf((OptionSpec)seqModel) : null;
                Integer fbWidth = options.has("fbBeamWidth") ? (Integer)options.valueOf((OptionSpec)fbBeam) : Integer.valueOf(5);
                String algStr = options.has("taggingAlgorithm") ? (String)options.valueOf((OptionSpec)tagAlgorithm) : "forward-backward";
                Constants.TaggingAlgorithm alg = algStr.equalsIgnoreCase("forward") ? Constants.TaggingAlgorithm.FORWARD : Constants.TaggingAlgorithm.FORWARDBACKWARD;
                STTaggerWordDictionary wd = null;
                STTaggerPOSDictionary pd = null;
                if (options.has("w")) {
                    wd = new XMLWordDictionaryReader((File)options.valueOf((OptionSpec)wdictspec)).read();
                }
                if (options.has("p")) {
                    pd = new XMLPOSDictionaryReader((File)options.valueOf((OptionSpec)pdictspec)).read();
                }
                ZLMEM maxentModel = new ZLMEM((File)options.valueOf((OptionSpec)modspec));
                WordAndPOSDictionaryLabellingStrategy tagger = new WordAndPOSDictionaryLabellingStrategy(wd, pd, options.has("K") ? (Integer)options.valueOf((OptionSpec)kspec) : 20, maxentModel, new STFex(stPrior), seqMod, alg);
                tagger.setMaxSearchBeam(fbWidth);
                maxentModel.verbose = true;
                CorpusIterator corpus = null;
                CorpusIterator goldCorpus = null;
                if (((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("srilm")) {
                    corpus = new SRILMFactoredBundleCorpusIterator(new BufferedReader(new FileReader((File)options.valueOf((OptionSpec)inputspec))));
                } else if (((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("candc")) {
                    corpus = new PipeDelimitedFactoredBundleCorpusIterator(new BufferedReader(new FileReader((File)options.valueOf((OptionSpec)inputspec))));
                }
                if (options.has("test") && ((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("srilm")) {
                    goldCorpus = new SRILMFactoredBundleCorpusIterator(new BufferedReader(new FileReader((File)options.valueOf((OptionSpec)goldstandspec))));
                } else if (options.has("test") && ((String)options.valueOf((OptionSpec)tokenisation)).equalsIgnoreCase("candc")) {
                    goldCorpus = new PipeDelimitedFactoredBundleCorpusIterator(new BufferedReader(new FileReader((File)options.valueOf((OptionSpec)goldstandspec))));
                }
                BufferedWriter outf = new BufferedWriter(new FileWriter((File)options.valueOf((OptionSpec)outputspec)));
                boolean test = options.has("test");
                ResultSink results = new ResultSink();
                int sentCnt = 0;
                tagger.setBetas(new double[]{beta});
                while (corpus.hasNext()) {
                    ++sentCnt;
                    List sent = (List)corpus.next();
                    List<List<Pair<Double, String>>> taggings = tagger.multitag(sent, beta);
                    if (test) {
                        List goldsent = (List)goldCorpus.next();
                        results.addSent(taggings, goldsent);
                    }
                    Iterator sentiter = sent.iterator();
                    outf.write("<s>" + System.getProperty("line.separator"));
                    for (List<Pair<Double, String>> tagging : taggings) {
                        Word nextw = (Word)sentiter.next();
                        outf.write(nextw.getForm() + "\t1\t" + nextw.getPOS() + "\t1.0\t" + tagging.size() + "\t");
                        String tags = "";
                        for (Pair<Double, String> tg : tagging) {
                            tags = tags + "\t" + (String)tg.b + "\t" + tg.a;
                        }
                        outf.write(tags.substring(1) + System.getProperty("line.separator"));
                    }
                    outf.write("</s>" + System.getProperty("line.separator"));
                    if (sentCnt % 10 != 0) continue;
                    outf.flush();
                }
                outf.flush();
                outf.close();
                if (test) {
                    System.err.println(results.report());
                }
                long end = System.currentTimeMillis();
                System.err.println("Time to tag: " + ((double)(end - start2) + 0.0) / 1000.0 + " seconds.");
            } else if (options.has("tagdictextract")) {
                File wd = (File)options.valueOf((OptionSpec)wdictspec);
                File pd = (File)options.valueOf((OptionSpec)pdictspec);
                File inf = (File)options.valueOf((OptionSpec)inputspec);
                TaggingDictionaryExtractor tde = new TaggingDictionaryExtractor(inf, wd, pd, (String)options.valueOf((OptionSpec)tokenisation));
                System.err.println("Extracting dictionaries from: " + inf.toString() + " into files: " + wd.toString() + " and: " + pd.toString() + "\n(wdict and posdict, resp.).");
                tde.extract();
            } else {
                File inf = (File)options.valueOf((OptionSpec)inputspec);
                File outf = (File)options.valueOf((OptionSpec)outputspec);
                STFex fexer = stPrior == null ? new STFex() : new STFex(stPrior);
                ZhangLeTrainingExtractor fexApp = new ZhangLeTrainingExtractor(inf, outf, (String)options.valueOf((OptionSpec)tokenisation), fexer);
                System.err.println("Extracting features from file: " + inf.toString() + ", and placing extracted features in: " + outf.toString() + ".");
                fexApp.writeFeats();
            }
        }
        catch (OptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }
}

