/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import opennlp.ccg.ngrams.FactoredNgramModelFamily;
import opennlp.ccg.ngrams.SRILM_ScorerMaker;
import opennlp.ccg.synsem.SignScorer;

public class SRILM_FactoredScorerMaker
extends SRILM_ScorerMaker {
    public String flmSpecFileBase = "test.flm";

    protected String flmSpecFilename() {
        return this.flmSpecFileBase + "." + this.discountOptionsStr + this.getOrder();
    }

    @Override
    protected String pplFileRoot() {
        return this.flmSpecFilename();
    }

    @Override
    protected String filename(int foldNum) {
        return this.flmSpecFilename() + ".fold" + foldNum;
    }

    protected void writeFoldSpecFile(File tmpDir, int foldNum) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.flmSpecFilename()));
        File foldSpecFile = new File(tmpDir, this.filename(foldNum));
        PrintWriter out = new PrintWriter(new FileWriter(foldSpecFile));
        String dotFoldN = ".fold" + foldNum;
        String line = null;
        while ((line = br.readLine()) != null) {
            int countIndex = line.indexOf(".count");
            if (countIndex > 0) {
                String foldLine = line.substring(0, countIndex);
                foldLine = foldLine + dotFoldN;
                int lmIndex = line.indexOf(".lm", countIndex);
                foldLine = foldLine + line.substring(countIndex, lmIndex);
                foldLine = foldLine + dotFoldN;
                foldLine = foldLine + line.substring(lmIndex);
                out.println(foldLine);
                continue;
            }
            out.println(line);
        }
        out.close();
        br.close();
    }

    @Override
    public void prepScorer(File tmpDir, int foldNum, File trainFile, File testFile) throws IOException {
        this.writeFoldSpecFile(tmpDir, foldNum);
        super.prepScorer(tmpDir, foldNum, trainFile, testFile);
    }

    @Override
    protected void writeTargets(File tbFile, String textfile) throws IOException {
        if (!this.useSemClasses) {
            this.cvr.tester.writeTargetsF(tbFile, textfile);
        } else {
            this.cvr.tester.writeTargetsFSC(tbFile, textfile);
        }
    }

    @Override
    protected String countNgrams(int foldNum) {
        String cmd = "fngram-count -nonull -write-counts -lm " + (this.unk ? "-unk " : "") + "-factor-file " + this.filename(foldNum) + " -text " + this.trainingfile(foldNum) + " -debug " + this.debugLevel;
        return cmd;
    }

    @Override
    protected String scoreNgrams(int foldNum) {
        String lmfile = this.filename(foldNum);
        String cmd2 = "fngram -nonull " + (this.unk ? "-unk " : "") + "-factor-file " + lmfile + " -ppl " + this.testfile(foldNum);
        return cmd2;
    }

    @Override
    public SignScorer loadScorer(File tmpDir, int foldNum, File trainFile) throws IOException {
        File foldSpecFile = new File(tmpDir, this.filename(foldNum));
        String foldSpecPath = foldSpecFile.getCanonicalPath();
        return new FactoredNgramModelFamily(foldSpecPath, this.useSemClasses);
    }
}

