/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;

public class RepetitionScorer
implements SignScorer {
    public double penalty = 1.0;
    public double olderCount = 0.5;
    public double evenOlderCount = 0.25;
    public double oldestCount = 0.125;
    protected Set posValsToUse = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set stemsToIgnore = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set previousItems = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set contextItems = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set olderContextItems = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set evenOlderContextItems = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    protected Set oldestContextItems = new THashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());

    public RepetitionScorer() {
        String[] posVals = new String[]{"NNP", "N", "V", "Adj", "Adv"};
        this.posValsToUse.addAll(Arrays.asList(posVals));
        String[] stems = new String[]{"do", "not"};
        this.stemsToIgnore.addAll(Arrays.asList(stems));
    }

    public void resetContext() {
        this.contextItems.clear();
        this.olderContextItems.clear();
        this.evenOlderContextItems.clear();
        this.oldestContextItems.clear();
    }

    public void ageContext() {
        this.oldestContextItems.clear();
        this.oldestContextItems.addAll(this.evenOlderContextItems);
        this.evenOlderContextItems.clear();
        this.evenOlderContextItems.addAll(this.olderContextItems);
        this.olderContextItems.clear();
        this.olderContextItems.addAll(this.contextItems);
        this.contextItems.clear();
    }

    public void updateContext(Sign sign) {
        List<Word> words = sign.getWords();
        if (words == null) {
            return;
        }
        for (int i = 0; i < words.size(); ++i) {
            Word word = words.get(i);
            this.updateItems(word, this.contextItems);
        }
    }

    protected void updateItems(Word word, Set set) {
        String stem = this.relevantStem(word);
        if (stem != null) {
            set.add(stem);
        }
    }

    protected String relevantStem(Word word) {
        if (!this.posValsToUse.contains(word.getPOS())) {
            return null;
        }
        String stem = word.getStem();
        if (!this.stemsToIgnore.contains(stem)) {
            return stem;
        }
        return null;
    }

    @Override
    public double score(Sign sign, boolean complete) {
        List<Word> words = sign.getWords();
        if (words == null) {
            return 0.0;
        }
        return Math.pow(10.0, -1.0 * this.penalty * this.repeatedItems(words));
    }

    protected double repeatedItems(List words) {
        this.previousItems.clear();
        double retval = 0.0;
        for (int i = 0; i < words.size(); ++i) {
            Word word = (Word)words.get(i);
            retval += this.repeatedItems(word);
            this.updateItems(word, this.previousItems);
        }
        return retval;
    }

    protected double repeatedItems(Word word) {
        String stem = this.relevantStem(word);
        if (stem == null) {
            return 0.0;
        }
        if (this.contextItems.contains(stem) || this.previousItems.contains(stem)) {
            return 1.0;
        }
        if (this.olderContextItems.contains(stem)) {
            return this.olderCount;
        }
        if (this.evenOlderContextItems.contains(stem)) {
            return this.evenOlderCount;
        }
        if (this.oldestContextItems.contains(stem)) {
            return this.oldestCount;
        }
        return 0.0;
    }
}

