/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.util.Pair;

public class EPsScorer {
    public static Results score(LF lf, LF goldLF) {
        Pair<Nominal, Nominal> dep;
        List<SatOp> eps = HyloHelper.flatten(lf);
        List<SatOp> goldEPs = HyloHelper.flatten(goldLF);
        HashSet<SatOp> epsSet = new HashSet<SatOp>(eps);
        HashSet<SatOp> goldEPsSet = new HashSet<SatOp>(goldEPs);
        HashSet<Pair<Nominal, Nominal>> unlabeledDepsSet = new HashSet<Pair<Nominal, Nominal>>();
        HashSet<Pair<Nominal, Nominal>> goldUnlabeledDepsSet = new HashSet<Pair<Nominal, Nominal>>();
        for (SatOp ep : eps) {
            dep = EPsScorer.getDep(ep);
            if (dep == null) continue;
            unlabeledDepsSet.add(dep);
        }
        for (SatOp ep : goldEPs) {
            dep = EPsScorer.getDep(ep);
            if (dep == null) continue;
            goldUnlabeledDepsSet.add(dep);
        }
        Results retval = new Results();
        int recalled = 0;
        int depsRecalled = 0;
        int unlabeledDepsRecalled = 0;
        int goldDeps = goldUnlabeledDepsSet.size();
        for (SatOp ep : goldEPs) {
            boolean isdep = HyloHelper.isRelPred(ep);
            if (epsSet.contains(ep)) {
                ++recalled;
                if (isdep) {
                    ++depsRecalled;
                }
            }
            if (!isdep || !unlabeledDepsSet.contains(EPsScorer.getDep(ep))) continue;
            ++unlabeledDepsRecalled;
        }
        retval.recall = 1.0 * (double)recalled / (double)goldEPs.size();
        retval.depsRecall = goldDeps > 0 ? 1.0 * (double)depsRecalled / (double)goldDeps : 1.0;
        retval.unlabeledDepsRecall = goldDeps > 0 ? 1.0 * (double)unlabeledDepsRecalled / (double)goldDeps : 1.0;
        int precise = 0;
        int depsPrecise = 0;
        int unlabeledDepsPrecise = 0;
        int lfDeps = unlabeledDepsSet.size();
        for (SatOp ep : eps) {
            boolean isdep = HyloHelper.isRelPred(ep);
            if (goldEPsSet.contains(ep)) {
                ++precise;
                if (isdep) {
                    ++depsPrecise;
                }
            }
            if (!isdep || !goldUnlabeledDepsSet.contains(EPsScorer.getDep(ep))) continue;
            ++unlabeledDepsPrecise;
        }
        retval.precision = 1.0 * (double)precise / (double)eps.size();
        retval.depsPrecision = lfDeps > 0 ? 1.0 * (double)depsPrecise / (double)lfDeps : 1.0;
        retval.unlabeledDepsPrecision = lfDeps > 0 ? 1.0 * (double)unlabeledDepsPrecise / (double)lfDeps : 1.0;
        retval.fscore = EPsScorer.fscore(retval.recall, retval.precision);
        retval.depsFscore = EPsScorer.fscore(retval.depsRecall, retval.depsPrecision);
        retval.unlabeledDepsFscore = EPsScorer.fscore(retval.unlabeledDepsRecall, retval.unlabeledDepsPrecision);
        return retval;
    }

    private static Pair<Nominal, Nominal> getDep(SatOp ep) {
        if (HyloHelper.isRelPred(ep)) {
            Nominal n2;
            Nominal n1 = HyloHelper.getPrincipalNominal(ep);
            if (n1.compareTo(n2 = HyloHelper.getSecondaryNominal(ep)) <= 0) {
                return new Pair<Nominal, Nominal>(n1, n2);
            }
            return new Pair<Nominal, Nominal>(n2, n1);
        }
        return null;
    }

    public static double fscore(double recall, double precision) {
        if (recall + precision == 0.0) {
            return 0.0;
        }
        return 2.0 * recall * precision / (recall + precision);
    }

    public static class Results {
        public double recall = 0.0;
        public double precision = 0.0;
        public double fscore = 0.0;
        public double depsRecall = 0.0;
        public double depsPrecision = 0.0;
        public double depsFscore = 0.0;
        public double unlabeledDepsRecall = 0.0;
        public double unlabeledDepsPrecision = 0.0;
        public double unlabeledDepsFscore = 0.0;
        private static final NumberFormat nf = Results.initNF();

        public String toString() {
            return "fscore: " + nf.format(this.fscore) + "  recall: " + nf.format(this.recall) + "  precision: " + nf.format(this.precision) + "  deps fscore: " + nf.format(this.depsFscore) + "  deps recall: " + nf.format(this.depsRecall) + "  deps precision: " + nf.format(this.depsPrecision) + "  unlabeled deps fscore: " + nf.format(this.unlabeledDepsFscore) + "  unlabeled deps recall: " + nf.format(this.unlabeledDepsRecall) + "  unlabeled deps precision: " + nf.format(this.unlabeledDepsPrecision);
        }

        private static NumberFormat initNF() {
            NumberFormat f = NumberFormat.getInstance();
            f.setMinimumIntegerDigits(1);
            f.setMinimumFractionDigits(1);
            f.setMaximumFractionDigits(4);
            return f;
        }
    }
}

