/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.grammar.Rule;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.CategoryFcnAdapter;
import opennlp.ccg.synsem.ComplexCat;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.TargetCat;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GFeatStruc;
import opennlp.ccg.unify.Substitution;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Element;

public abstract class AbstractRule
implements Rule,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _name;
    protected RuleGroup _ruleGroup;
    protected List<Category> _headCats = new ArrayList<Category>();
    private GFeatStruc targetFS = null;
    private CategoryFcn distributeTargetFeaturesFcn = new DistributeTargetFeaturesFcn();

    @Override
    public abstract Element toXml();

    public void applyRule(Sign[] inputs, List<Sign> results) {
        if (inputs.length != this.arity()) {
            throw new RuntimeException("Inputs must have length " + this.arity());
        }
        Category[] cats = new Category[inputs.length];
        for (int i = 0; i < cats.length; ++i) {
            cats[i] = inputs[i].getCategory();
        }
        try {
            List<Category> resultCats = this.applyRule(cats);
            if (resultCats.isEmpty()) {
                return;
            }
            for (int i = 0; i < resultCats.size(); ++i) {
                Category catResult = resultCats.get(i);
                this.distributeTargetFeatures(catResult);
                Category headCat = this._headCats.get(i);
                Sign lexHead = inputs[0].getLexHead();
                for (int j = 0; j < inputs.length; ++j) {
                    if (inputs[j].getCategory() != headCat) continue;
                    lexHead = inputs[j].getLexHead();
                }
                Sign sign = Sign.createDerivedSign(catResult, inputs, this, lexHead);
                results.add(sign);
            }
        }
        catch (UnifyFailure unifyFailure) {
            // empty catch block
        }
    }

    protected void distributeTargetFeatures(Category cat) {
        if (this._ruleGroup == null) {
            return;
        }
        if (this._ruleGroup.grammar.lexicon.getDistributiveAttrs() == null) {
            return;
        }
        if (!(cat instanceof ComplexCat)) {
            return;
        }
        ComplexCat complexCat = (ComplexCat)cat;
        TargetCat targetCat = complexCat.getTarget();
        this.targetFS = (GFeatStruc)targetCat.getFeatureStructure();
        if (this.targetFS == null) {
            return;
        }
        cat.forall(this.distributeTargetFeaturesFcn);
    }

    @Override
    public abstract int arity();

    @Override
    public abstract List<Category> applyRule(Category[] var1) throws UnifyFailure;

    protected void showApplyInstance(Category[] inputs) {
        StringBuffer sb = new StringBuffer();
        sb.append(this._name).append(": ");
        for (int i = 0; i < inputs.length; ++i) {
            sb.append(inputs[i]).append(' ');
        }
        System.out.println(sb);
    }

    protected void showApplyInstance(Category first, Category second) {
        Category[] ca = new Category[]{first, second};
        this.showApplyInstance(ca);
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public RuleGroup getRuleGroup() {
        return this._ruleGroup;
    }

    @Override
    public void setRuleGroup(RuleGroup ruleGroup) {
        this._ruleGroup = ruleGroup;
    }

    protected void appendLFs(Category cat1, Category cat2, Category result, Substitution sub) throws UnifyFailure {
        LF lf = HyloHelper.append(cat1.getLF(), cat2.getLF());
        if (lf != null) {
            lf = (LF)lf.fill(sub);
            HyloHelper.sort(lf);
            HyloHelper.check(lf);
        }
        result.setLF(lf);
    }

    private class DistributeTargetFeaturesFcn
    extends CategoryFcnAdapter
    implements Serializable {
        private static final long serialVersionUID = 5247861522003485434L;

        private DistributeTargetFeaturesFcn() {
        }

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            if (fs == AbstractRule.this.targetFS) {
                return;
            }
            String[] distrAttrs = AbstractRule.this._ruleGroup.grammar.lexicon.getDistributiveAttrs();
            for (int i = 0; i < distrAttrs.length; ++i) {
                Object targetVal = AbstractRule.this.targetFS.getValue(distrAttrs[i]);
                if (targetVal == null || targetVal instanceof Variable) continue;
                fs.setFeature(distrAttrs[i], UnifyControl.copy(targetVal));
            }
        }
    }
}

