/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import opennlp.ccg.util.Filter;

public class CompositeFilter<E>
implements Filter<E> {
    Set<Filter<? super E>> filters;

    public CompositeFilter() {
        this.filters = new HashSet<Filter<? super E>>();
    }

    @SafeVarargs
    public CompositeFilter(Filter<? super E> ... edgeFilters) {
        this(Arrays.asList(edgeFilters));
    }

    public CompositeFilter(Collection<? extends Filter<? super E>> filters) {
        this.filters = new HashSet<Filter<Filter<? super E>>>(filters);
    }

    public Set<? extends Filter<? super E>> filters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public boolean containsFilter(Filter<? super E> filter) {
        return this.filters.contains(filter);
    }

    public boolean addFilter(Filter<? super E> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        return this.filters.add(filter);
    }

    public boolean removeFilter(Filter<? super E> filter) {
        return this.filters.remove(filter);
    }

    @Override
    public boolean allows(E e) {
        for (Filter<E> f : this.filters) {
            if (f.allows(e)) continue;
            return false;
        }
        return true;
    }
}

