/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.tagger.ml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import opennlp.ccg.parse.tagger.Constants;
import opennlp.ccg.parse.tagger.ml.ItemMap;
import opennlp.ccg.util.Pair;

public class ZLMaxentModel {
    public boolean verbose = false;
    private ItemMap predMap = null;
    private ItemMap outComeMap = null;
    ArrayList<ArrayList<Pair<Integer, Integer>>> paramsMap;
    private boolean loaded = false;
    private double[] probs;
    private int n_outcome;
    private double[] theta;
    private Double one = Constants.one;

    public ZLMaxentModel() {
    }

    public ZLMaxentModel(File model) {
        this.load(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File modelFile) {
        if (!this.loaded) {
            this.loaded = true;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(modelFile));
                String line = br.readLine();
                if (line.contains("#")) {
                    line = br.readLine();
                }
                if (this.verbose) {
                    System.err.println("\nReading predicates...");
                }
                int numPreds = Integer.parseInt(line);
                this.predMap = new ItemMap();
                for (int i = 0; i < numPreds; ++i) {
                    line = br.readLine();
                    this.predMap.add(line);
                }
                if (this.verbose) {
                    System.err.println("Reading outcomes...");
                }
                this.outComeMap = new ItemMap();
                line = br.readLine();
                int numOutcomes = Integer.parseInt(line);
                for (int j = 0; j < numOutcomes; ++j) {
                    line = br.readLine();
                    this.outComeMap.add(line);
                }
                if (this.verbose) {
                    System.err.println("Reading parameters...");
                }
                int numParameters = this.predMap.size();
                this.paramsMap = new ArrayList(numParameters);
                int fid = 0;
                String ln = "";
                for (int q = 0; q < numParameters; ++q) {
                    ln = br.readLine();
                    String[] lineParts = ln.split(" ");
                    ArrayList<Pair<Integer, Integer>> prms = new ArrayList<Pair<Integer, Integer>>(Integer.parseInt(lineParts[0]));
                    for (int p = 1; p < lineParts.length; ++p) {
                        Integer oid = Integer.valueOf(lineParts[p]);
                        prms.add(new Pair<Integer, Integer>(oid, fid));
                        ++fid;
                    }
                    this.paramsMap.add(prms);
                }
                int nTheta = Integer.valueOf(br.readLine());
                if (this.verbose) {
                    System.err.println("Number of parameters: " + nTheta);
                }
                this.theta = new double[nTheta];
                for (int z = 0; z < this.theta.length; ++z) {
                    this.theta[z] = Double.parseDouble(br.readLine());
                }
                this.n_outcome = this.outComeMap.size();
                this.probs = new double[this.n_outcome];
                if (this.verbose) {
                    System.err.println("Number of outcomes: " + this.n_outcome);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public String getBestOutcome(double[] probs) {
        double maxprob = 0.0;
        int maxidx = -1;
        for (int i = 0; i < probs.length; ++i) {
            if (!(probs[i] > maxprob)) continue;
            maxidx = i;
            maxprob = probs[i];
        }
        return this.getOutcome(maxidx);
    }

    public double[] eval(Collection<Pair<String, Double>> context, boolean realValued) {
        return this.eval(context, realValued, Constants.Domain.PROB);
    }

    public double[] eval(Collection<Pair<String, Double>> context, boolean realValued, Constants.Domain domain) {
        for (int i = 0; i < this.probs.length; ++i) {
            this.probs[i] = 0.0;
        }
        for (Pair<String, Double> pv : context) {
            Integer predID = this.predMap.id((String)pv.a);
            if (predID == null) continue;
            ArrayList<Pair<Integer, Integer>> featClassAssocs = this.paramsMap.get(predID);
            for (Pair<Integer, Integer> classAndAssoc : featClassAssocs) {
                if (pv.b == this.one) {
                    int n = (Integer)classAndAssoc.a;
                    this.probs[n] = this.probs[n] + this.theta[(Integer)classAndAssoc.b];
                    continue;
                }
                int n = (Integer)classAndAssoc.a;
                this.probs[n] = this.probs[n] + Math.log(Math.exp(this.theta[(Integer)classAndAssoc.b] * (Double)pv.b));
            }
        }
        double sum = 0.0;
        for (int p = 0; p < this.probs.length; ++p) {
            sum += Math.exp(this.probs[p]);
        }
        sum = Math.log(sum);
        int q = 0;
        while (q < this.probs.length) {
            int n = q++;
            this.probs[n] = this.probs[n] - sum;
        }
        if (domain == Constants.Domain.PROB) {
            for (q = 0; q < this.probs.length; ++q) {
                this.probs[q] = Math.exp(this.probs[q]);
            }
        }
        return this.probs;
    }

    public String getOutcome(int index) {
        return this.outComeMap.getItem(index);
    }
}

