/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.grammar.RuleGroup;
import opennlp.ccg.hylo.EPsScorer;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.LexException;
import opennlp.ccg.lexicon.Lexicon;
import opennlp.ccg.lexicon.SupertaggerAdapter;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.parse.Chart;
import opennlp.ccg.parse.Edge;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Supertagger;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignHash;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.util.Pair;

public class Parser {
    public static final String PARSE_TIME_LIMIT = "Parse Time Limit";
    public static final int NO_TIME_LIMIT = 0;
    public static final String PARSE_EDGE_LIMIT = "Parse Edge Limit";
    public static final int NO_EDGE_LIMIT = 0;
    public static final String PARSE_PRUNING_VALUE = "Parse Pruning Value";
    public static final String PARSE_CELL_PRUNING_VALUE = "Parse Cell Pruning Value";
    public static final int NO_PRUNING = 0;
    public static final String PARSE_LAZY_UNPACKING = "Parse Lazy Unpacking";
    public final Grammar grammar;
    public final Lexicon lexicon;
    public final RuleGroup rules;
    public boolean debugParse = false;
    protected SignScorer signScorer = null;
    protected int pruneVal = -1;
    protected int cellPruneVal = -1;
    protected Boolean lazyUnpacking = null;
    protected Supertagger supertagger = null;
    protected boolean stMostToLeastDir = true;
    protected int timeLimit = -1;
    protected int edgeLimit = -1;
    private long startTime = 0L;
    private int lexTime = 0;
    private int parseTime = 0;
    private int chartTime = 0;
    private int unpackingTime = 0;
    private int timeLimitToUse = 0;
    private int edgeLimitToUse = 0;
    private int pruneValToUse = 0;
    private int cellPruneValToUse = 0;
    private boolean lazyUnpackingToUse = true;
    private Chart chart = null;
    private ArrayList<Sign> result;
    private ArrayList<Double> scores;
    private boolean gluingFragments = false;

    public Parser(Grammar grammar) {
        this.grammar = grammar;
        this.lexicon = grammar.lexicon;
        this.rules = grammar.rules;
    }

    public void setSignScorer(SignScorer signScorer) {
        this.signScorer = signScorer;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void setEdgeLimit(int edgeLimit) {
        this.edgeLimit = edgeLimit;
    }

    public void setPruneVal(int n) {
        this.pruneVal = n;
    }

    public void setCellPruneVal(int n) {
        this.cellPruneVal = n;
    }

    public void setLazyUnpacking(Boolean b) {
        this.lazyUnpacking = b;
    }

    public void setSupertagger(Supertagger supertagger) {
        this.supertagger = supertagger;
    }

    public void setSupertaggerMostToLeastRestrictiveDirection(boolean bool) {
        this.stMostToLeastDir = bool;
    }

    public void parse(String s) throws ParseException {
        List<Word> words = this.lexicon.tokenizer.tokenize(s);
        this.parse(words);
    }

    public void parse(List<Word> words) throws ParseException {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        this.timeLimitToUse = this.timeLimit >= 0 ? this.timeLimit : prefs.getInt(PARSE_TIME_LIMIT, 0);
        this.edgeLimitToUse = this.edgeLimit >= 0 ? this.edgeLimit : prefs.getInt(PARSE_EDGE_LIMIT, 0);
        this.pruneValToUse = this.pruneVal >= 0 ? this.pruneVal : prefs.getInt(PARSE_PRUNING_VALUE, 0);
        this.cellPruneValToUse = this.cellPruneVal >= 0 ? this.cellPruneVal : prefs.getInt(PARSE_CELL_PRUNING_VALUE, 0);
        this.lazyUnpackingToUse = this.lazyUnpacking != null ? this.lazyUnpacking.booleanValue() : prefs.getBoolean(PARSE_LAZY_UNPACKING, true);
        if (this.supertagger != null) {
            this.parseWithSupertagger(words);
            return;
        }
        try {
            long lexStartTime = System.currentTimeMillis();
            UnifyControl.startUnifySequence();
            ArrayList<SignHash> entries = new ArrayList<SignHash>(words.size());
            for (Word w : words) {
                entries.add(this.lexicon.getSignsFromWord(w));
            }
            this.lexTime = (int)(System.currentTimeMillis() - lexStartTime);
            this.parseEntries(entries);
        }
        catch (LexException e) {
            this.setGiveUpTime();
            String msg = "Unable to retrieve lexical entries:\n\t" + e.toString();
            if (this.debugParse) {
                System.out.println(msg);
            }
            throw new ParseException(msg);
        }
        catch (ParseException e) {
            this.setGiveUpTime();
            if (this.debugParse) {
                System.out.println(e);
                System.out.println("Chart for failed parse:");
                this.chart.printChart();
            }
            throw e;
        }
    }

    private void parseWithSupertagger(List<Word> words) throws ParseException {
        this.grammar.lexicon.setSupertagger(this.supertagger);
        this.gluingFragments = false;
        if (this.stMostToLeastDir) {
            this.supertagger.resetBeta();
        } else {
            this.supertagger.resetBetaToMax();
        }
        boolean done = false;
        while (!done) {
            try {
                long lexStartTime = System.currentTimeMillis();
                UnifyControl.startUnifySequence();
                ArrayList<SignHash> entries = new ArrayList<SignHash>(words.size());
                this.supertagger.mapWords(words);
                for (int i = 0; i < words.size(); ++i) {
                    this.supertagger.setWord(i);
                    Word word = words.get(i);
                    entries.add(this.lexicon.getSignsFromWord(word));
                }
                this.lexTime = (int)(System.currentTimeMillis() - lexStartTime);
                this.parseEntries(entries);
                done = true;
                this.grammar.lexicon.setSupertagger(null);
                this.gluingFragments = false;
            }
            catch (LexException e) {
                if (this.stMostToLeastDir && this.supertagger.hasMoreBetas()) {
                    this.supertagger.nextBeta();
                    continue;
                }
                this.setGiveUpTime();
                this.grammar.lexicon.setSupertagger(null);
                this.gluingFragments = false;
                String msg = "Unable to retrieve lexical entries:\n\t" + e.toString();
                if (this.debugParse) {
                    System.out.println(msg);
                }
                throw new ParseException(msg);
            }
            catch (ParseException e) {
                boolean outwith;
                boolean bl = outwith = e.getMessage() == "Edge limit exceeded" || e.getMessage() == "Time limit exceeded";
                if (this.stMostToLeastDir && this.supertagger.hasMoreBetas() && !outwith) {
                    this.supertagger.nextBeta();
                    continue;
                }
                if (!this.stMostToLeastDir && this.supertagger.hasLessBetas() && outwith) {
                    this.supertagger.previousBeta();
                    continue;
                }
                if (!this.gluingFragments) {
                    this.supertagger.resetBeta();
                    this.gluingFragments = true;
                    continue;
                }
                this.setGiveUpTime();
                if (this.debugParse) {
                    System.out.println(e);
                    System.out.println("Chart for failed parse:");
                    this.chart.printChart();
                }
                this.grammar.lexicon.setSupertagger(null);
                this.gluingFragments = false;
                throw e;
            }
        }
    }

    public List<Sign> getResult() {
        return this.result;
    }

    public List<Double> getScores() {
        return this.scores;
    }

    public int edgeCount() {
        return this.chart != null ? this.chart.edgeCount() : 0;
    }

    public int unpackingEdgeCount() {
        return this.chart != null ? this.chart.unpackingEdgeCount() : 0;
    }

    public int maxCellSize() {
        return this.chart != null ? this.chart.maxCellSize() : 0;
    }

    public int getLexTime() {
        return this.lexTime;
    }

    public int getParseTime() {
        return this.parseTime;
    }

    public int getChartTime() {
        return this.chartTime;
    }

    public int getUnpackingTime() {
        return this.unpackingTime;
    }

    public double getSupertaggerBeta() {
        return this.supertagger != null ? this.supertagger.getCurrentBetaValue() : 0.0;
    }

    private void parseEntries(List<SignHash> entries) throws ParseException {
        this.startTime = System.currentTimeMillis();
        this.initializeChart(entries);
        if (this.signScorer != null) {
            this.chart.setSignScorer(this.signScorer);
        }
        this.chart.setPruneVal(this.pruneValToUse);
        this.chart.setTimeLimit(this.timeLimitToUse);
        this.chart.setStartTime(this.startTime);
        this.chart.setEdgeLimit(this.edgeLimitToUse);
        this.chart.setCellLimit(this.cellPruneValToUse);
        this.parse(entries.size());
    }

    private void initializeChart(List<SignHash> entries) {
        this.chart = new Chart(entries.size(), this.rules);
        for (int i = 0; i < entries.size(); ++i) {
            SignHash wh = entries.get(i);
            for (Sign sign : wh.getSignsSorted()) {
                Category cat = sign.getCategory();
                UnifyControl.reindex(cat);
                this.chart.insert(i, i, sign);
            }
        }
    }

    private void parse(int size) throws ParseException {
        int k;
        int i;
        int j;
        for (int i2 = 0; i2 < size; ++i2) {
            this.chart.insertCell(i2, i2);
        }
        for (j = 1; j < size; ++j) {
            for (i = j - 1; i >= 0; --i) {
                for (k = i; k < j; ++k) {
                    this.chart.insertCell(i, k, k + 1, j, i, j);
                }
                this.chart.insertCell(i, j);
            }
        }
        if (this.gluingFragments && this.chart.cellIsEmpty(0, size - 1)) {
            for (j = 1; j < size; ++j) {
                for (i = j - 1; i >= 0; --i) {
                    for (k = i; k < j; ++k) {
                        this.chart.insertCellFrag(i, k, k + 1, j, i, j);
                    }
                }
            }
        }
        this.chartTime = (int)(System.currentTimeMillis() - this.startTime);
        this.createResult(size);
        this.parseTime = (int)(System.currentTimeMillis() - this.startTime);
        this.unpackingTime = this.parseTime - this.chartTime;
    }

    private void createResult(int size) throws ParseException {
        this.result = new ArrayList();
        this.scores = new ArrayList();
        List<Edge> unpacked = this.lazyUnpackingToUse ? this.chart.lazyUnpack(0, size - 1) : this.chart.unpack(0, size - 1);
        for (Edge edge : unpacked) {
            this.result.add(edge.sign);
            this.scores.add(edge.score);
        }
        if (this.result.size() == 0) {
            throw new ParseException("Unable to parse");
        }
    }

    private void setGiveUpTime() {
        this.parseTime = this.chartTime = (int)(System.currentTimeMillis() - this.startTime);
        this.unpackingTime = 0;
    }

    public void addSupertaggerLogProbs(Sign gold) {
        List<Word> words = gold.getWords();
        this.supertagger.mapWords(words);
        this.addSupertaggerLogProbs(gold, gold);
        for (int i = 0; i < words.size(); ++i) {
            this.supertagger.setWord(i);
        }
    }

    private void addSupertaggerLogProbs(Sign gold, Sign current) {
        if (current.isLexical()) {
            this.supertagger.setWord(gold.wordIndex(current));
            Map<String, Double> stags = this.supertagger.getSupertags();
            Double lexprob = stags.get(current.getSupertag());
            if (lexprob != null) {
                current.addData(new SupertaggerAdapter.LexLogProb((float)Math.log10(lexprob)));
            }
        } else {
            Sign[] inputs;
            for (Sign s : inputs = current.getDerivationHistory().getInputs()) {
                this.addSupertaggerLogProbs(gold, s);
            }
        }
    }

    public Pair<Sign, Boolean> oracleBest(LF goldLF) {
        Sign retval = null;
        double bestF = 0.0;
        for (Sign sign : this.result) {
            Category cat = sign.getCategory().copy();
            Nominal index = cat.getIndexNominal();
            LF parsedLF = cat.getLF();
            if (parsedLF == null) continue;
            index = HyloHelper.convertNominals(parsedLF, sign, index);
            EPsScorer.Results score = EPsScorer.score(parsedLF, goldLF);
            if (!(score.fscore > bestF)) continue;
            retval = sign;
            bestF = score.fscore;
        }
        return new Pair<Object, Boolean>(retval, bestF == 1.0);
    }
}

