/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.ComposedFeatureExtractor;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;

public class SignScorerInterpolation
implements SignScorer,
FeatureExtractor {
    protected SignScorer[] models;
    protected double[] weights;
    protected ComposedFeatureExtractor composedFeatureExtractor;

    public SignScorerInterpolation(SignScorer[] models) {
        this.models = models;
        this.weights = new double[models.length];
        for (int i = 0; i < models.length; ++i) {
            this.weights[i] = 1.0 / (double)models.length;
        }
    }

    public SignScorerInterpolation(SignScorer[] models, double[] weights) {
        this.models = models;
        this.weights = weights;
        this.composedFeatureExtractor = new ComposedFeatureExtractor(models);
    }

    @Override
    public double score(Sign sign, boolean complete) {
        double retval = 0.0;
        for (int i = 0; i < this.models.length; ++i) {
            retval += this.models[i].score(sign, complete) * this.weights[i];
        }
        return retval;
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        this.composedFeatureExtractor.setAlphabet(alphabet);
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        return this.composedFeatureExtractor.extractFeatures(sign, complete);
    }
}

