/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.lexicon.FactorKey;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.util.Pair;
import opennlp.ccg.util.TrieMap;

public class FactorChainWord
extends Word {
    private static final long serialVersionUID = 952665894357382685L;
    protected Object key;
    protected FactorChainWord prev;

    protected FactorChainWord(Object key, FactorChainWord prev) {
        this.key = key;
        this.prev = prev;
    }

    @Override
    public String getForm() {
        return this.getValFromInterned("W");
    }

    @Override
    public String getPitchAccent() {
        return this.getValFromInterned("A");
    }

    @Override
    protected List<Pair<String, String>> getAttrValPairsList() {
        ArrayList<Pair<String, String>> retval = null;
        FactorChainWord current = this;
        while (current != null) {
            if (current.key instanceof FactorKey) {
                FactorKey fkey = (FactorKey)current.key;
                if (!FactorChainWord.isKnownAttr(fkey.factor)) {
                    if (retval == null) {
                        retval = new ArrayList<Pair<String, String>>(5);
                    }
                    retval.add(0, new Pair<String, String>(fkey.factor, fkey.val));
                }
            }
            current = current.prev;
        }
        return retval;
    }

    @Override
    public String getStem() {
        return this.getValFromInterned("S");
    }

    @Override
    public String getPOS() {
        return this.getValFromInterned("P");
    }

    @Override
    public String getSupertag() {
        return this.getValFromInterned("T");
    }

    @Override
    public String getSemClass() {
        return this.getValFromInterned("C");
    }

    @Override
    public String getVal(String attr) {
        String internedAttr = attr.intern();
        return this.getValFromInterned(internedAttr);
    }

    protected String getValFromInterned(String attr) {
        FactorChainWord current = this;
        while (current != null) {
            if (attr == "W") {
                if (current.key instanceof String) {
                    return (String)current.key;
                }
            } else if (current.key instanceof FactorKey) {
                FactorKey fkey = (FactorKey)current.key;
                if (fkey.factor == attr) {
                    return fkey.val;
                }
            }
            current = current.prev;
        }
        return null;
    }

    public static class Factory
    implements Word.WordFactory {
        protected TrieMap<Object, FactorChainWord> factorChainRoot = new TrieMap(null);

        @Override
        public synchronized Word create(String form) {
            return this.create(this.factorChainRoot, "W", form);
        }

        @Override
        public synchronized Word create(String attr, String val) {
            return this.create(this.factorChainRoot, attr, val);
        }

        @Override
        public synchronized Word create(String form, String pitchAccent, List<Pair<String, String>> attrValPairs, String stem, String POS, String supertag, String semClass) {
            TrieMap<Object, FactorChainWord> currentNode = this.factorChainRoot;
            if (POS != null) {
                currentNode = this.findChild(currentNode, "P", POS);
            }
            if (supertag != null) {
                currentNode = this.findChild(currentNode, "T", supertag);
            }
            if (semClass != null) {
                currentNode = this.findChild(currentNode, "C", semClass);
            }
            if (stem != null) {
                currentNode = this.findChild(currentNode, "S", stem);
            }
            if (form != null) {
                currentNode = this.findChild(currentNode, "W", form);
            }
            if (pitchAccent != null) {
                currentNode = this.findChild(currentNode, "A", pitchAccent);
            }
            if (attrValPairs != null) {
                for (int i = 0; i < attrValPairs.size(); ++i) {
                    Pair<String, String> p = attrValPairs.get(i);
                    String attr = (String)p.a;
                    String val = (String)p.b;
                    currentNode = this.findChild(currentNode, attr, val);
                }
            }
            return (Word)currentNode.data;
        }

        protected Word create(TrieMap<Object, FactorChainWord> currentNode, String attr, String val) {
            TrieMap<Object, FactorChainWord> child = this.findChild(currentNode, attr, val);
            return (Word)child.data;
        }

        protected TrieMap<Object, FactorChainWord> findChild(TrieMap<Object, FactorChainWord> currentNode, String attr, String val) {
            Object key = FactorKey.getKey(attr, val);
            TrieMap<Object, FactorChainWord> child = currentNode.findChild(key);
            if (child.data == null) {
                FactorChainWord parent = (FactorChainWord)currentNode.data;
                child.data = new FactorChainWord(key, parent);
            }
            return child;
        }
    }
}

