/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.grammardoc.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccg.grammardoc.AbstractDocumenter;
import opennlp.ccg.grammardoc.DocumenterException;
import opennlp.ccg.grammardoc.DocumenterSourceException;
import opennlp.ccg.grammardoc.SourceGrammar;
import opennlp.ccg.grammardoc.SourceGrammarFile;
import opennlp.ccg.grammardoc.SourceGrammarFileType;

public class HTMLDocumenter
extends AbstractDocumenter
implements URIResolver {
    private static final int FILE_BUFFER_SIZE = 256;
    private SourceGrammar sourceGrammar;
    private Map<String, Templates> templateCache;
    final TransformerFactory factory = TransformerFactory.newInstance();

    public HTMLDocumenter() {
        super("GrammarDoc HTML Documenter");
        this.templateCache = new HashMap<String, Templates>();
        this.factory.setURIResolver(this);
    }

    @Override
    public void document(SourceGrammar grammar) throws DocumenterException {
        this.sourceGrammar = grammar;
        File destDir = this.documenterContext.getDestinationDirectory();
        this.copyFiles(destDir);
        StringBuilder sb = new StringBuilder();
        for (SourceGrammarFileType fileType : grammar.getSourceGrammarFileTypes()) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(fileType.getFileName());
        }
        String sections = sb.toString();
        for (SourceGrammarFileType fileType : grammar.getSourceGrammarFileTypes()) {
            String baseName = fileType.getFileName();
            StringBuilder fb = new StringBuilder();
            fb.append(baseName.equals(SourceGrammarFileType.GRAMMAR.getFileName()) ? "index" : baseName);
            fb.append(".html");
            String targetName = fb.toString();
            SourceGrammarFile sourceFile = grammar.getSourceGrammarFile(fileType);
            Templates templates = this.loadTemplates(baseName);
            if (templates == null) continue;
            this.documenterContext.log("Generating " + targetName);
            try {
                File f = new File(destDir, targetName);
                StreamResult res = new StreamResult(new BufferedOutputStream(new FileOutputStream(f)));
                res.setSystemId(f);
                Transformer transformer = templates.newTransformer();
                transformer.setURIResolver(this);
                transformer.setParameter("sections", sections);
                transformer.transform(new StreamSource(sourceFile.getSourceFile()), res);
            }
            catch (TransformerException te) {
                throw new DocumenterSourceException("problem transforming output: " + te.getMessageAndLocation(), te, sourceFile);
            }
            catch (IOException ioe) {
                throw new DocumenterException(ioe);
            }
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        StreamSource ss = null;
        if (href != null && href.length() > 0) {
            if (href.endsWith(".xsl")) {
                ss = new StreamSource(this.getResource(href));
            } else {
                File f = new File(this.sourceGrammar.getSourceDirectory(), href);
                if (!f.exists()) {
                    throw new TransformerException("file does not exist: " + f);
                }
                if (f.isDirectory()) {
                    throw new TransformerException("file is a directory: " + f);
                }
                ss = new StreamSource(f);
                ss.setSystemId(f);
            }
        }
        return ss;
    }

    private Templates loadTemplates(String baseName) throws DocumenterException {
        StringBuilder tb = new StringBuilder(baseName);
        tb.append(".xsl");
        String templateName = tb.toString();
        if (!this.templateCache.containsKey(templateName)) {
            InputStream is = this.getResource(templateName.toString());
            if (is == null) {
                return null;
            }
            try {
                this.templateCache.put(templateName, this.factory.newTemplates(new StreamSource(is)));
            }
            catch (TransformerConfigurationException tce) {
                throw new DocumenterException("problem loading template " + templateName.toString() + ": " + tce.getMessageAndLocation(), tce);
            }
        }
        return this.templateCache.get(templateName);
    }

    private void copyFiles(File destDir) throws DocumenterException {
        for (FileName fileName : FileName.values()) {
            this.doCopyFile(fileName, destDir);
        }
    }

    private void doCopyFile(FileName fileName, File destDir) throws DocumenterException {
        InputStream in = this.getResource(fileName.name);
        if (in == null) {
            throw new DocumenterException("Could not find " + fileName.name);
        }
        File f = new File(destDir, fileName.name);
        this.documenterContext.log("Writing " + f.getAbsolutePath());
        try {
            int i;
            FileOutputStream fileOut = new FileOutputStream(f);
            byte[] buffer = new byte[256];
            while ((i = in.read(buffer)) != -1) {
                fileOut.write(buffer, 0, i);
            }
            in.close();
            fileOut.close();
        }
        catch (IOException ioe) {
            throw new DocumenterException("problem copying file: " + ioe.getMessage(), ioe);
        }
    }

    private InputStream getResource(String resourceName) {
        Class<?> cl = this.getClass();
        String cn = cl.getName();
        String pkg = cn.substring(0, cn.lastIndexOf(46));
        StringBuilder sb = new StringBuilder();
        sb.append(pkg.replace('.', '/'));
        sb.append('/');
        sb.append(resourceName);
        return cl.getClassLoader().getResourceAsStream(sb.toString());
    }

    static enum FileName {
        STYLESHEET("grammardoc.css"),
        LEXICON_SCRIPT("lexicon.js");

        final String name;

        private FileName(String name) {
            this.name = name;
        }
    }
}

