/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.disjunctivizer;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.alignment.Alignment;
import opennlp.ccg.alignment.PhrasePosition;
import opennlp.ccg.disjunctivizer.AlignedEdgeFilter;
import opennlp.ccg.disjunctivizer.FilteredLFEdgeSet;
import opennlp.ccg.disjunctivizer.MatchType;
import opennlp.ccg.disjunctivizer.VertexMatchFilter;
import opennlp.ccg.hylo.graph.LFEdge;
import opennlp.ccg.hylo.graph.LFGraph;
import opennlp.ccg.hylo.graph.LFVertex;
import opennlp.ccg.util.CompositeFilter;
import opennlp.ccg.util.Filter;
import opennlp.ccg.util.FilteredMap;
import opennlp.ccg.util.FilteredSet;
import opennlp.ccg.util.VisitedFilter;

public class LFGraphDifference {
    final LFGraph a;
    final LFGraph b;
    final Alignment alignment;
    private Set<LFEdge> deletes;
    private Set<LFEdge> inserts;
    private Set<LFEdge> substitutions;

    public LFGraphDifference(LFGraph a, LFGraph b, Alignment alignment) {
        this.checkGraph(a, PhrasePosition.A);
        this.checkGraph(b, PhrasePosition.B);
        if (alignment == null) {
            throw new IllegalArgumentException("alignment is null");
        }
        this.a = a;
        this.b = b;
        this.alignment = alignment;
    }

    private void checkGraph(LFGraph g, PhrasePosition pos) {
        if (g == null) {
            throw new IllegalArgumentException(pos.name() + " graph is null");
        }
    }

    public LFGraph getA() {
        return this.get(PhrasePosition.A);
    }

    public LFGraph getB() {
        return this.get(PhrasePosition.B);
    }

    public LFGraph get(PhrasePosition position) {
        return position == PhrasePosition.A ? this.a : this.b;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this.a)).hashCode() + ((Object)((Object)this.b)).hashCode() + this.alignment.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LFGraphDifference) {
            LFGraphDifference diff = (LFGraphDifference)obj;
            return ((Object)((Object)this.a)).equals((Object)diff.a) && ((Object)((Object)this.b)).equals((Object)diff.b) && this.alignment.equals(diff.alignment);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("difference for graphs: ");
        for (PhrasePosition pos : PhrasePosition.values()) {
            sb.append((Object)pos);
            sb.append(": ");
            sb.append((Object)this.get(pos));
            sb.append(", ");
        }
        sb.append("alignment: ");
        sb.append(this.alignment.toString());
        return sb.toString();
    }

    public LFGraphDifference reverse() {
        return new LFGraphDifference(this.b, this.a, this.alignment.reverse());
    }

    public Set<LFEdge> deletes() {
        return this.deletes == null ? (this.deletes = this.doDeletes(PhrasePosition.A)) : this.deletes;
    }

    public Set<LFEdge> inserts() {
        return this.inserts == null ? (this.inserts = this.doDeletes(PhrasePosition.B)) : this.inserts;
    }

    Set<LFEdge> doDeletes(PhrasePosition keyPosition) {
        return Collections.unmodifiableSet(new FilteredLFEdgeSet(this.get(keyPosition).edgeSet(), new AlignedEdgeFilter(this.alignment.asMap(keyPosition).keySet(), MatchType.SOURCE_ALIGNED, MatchType.TARGET_UNALIGNED)));
    }

    public Set<LFEdge> insertsFor(LFVertex vertex) {
        Set<Integer> indices = this.alignment.getTargets(vertex.getIndex());
        return indices.isEmpty() ? Collections.EMPTY_SET : new FilteredLFEdgeSet((Set<? extends LFEdge>)this.inserts(), new AlignedEdgeFilter(indices, MatchType.SOURCE_ALIGNED));
    }

    public Set<LFEdge> deletesFor(LFVertex vertex) {
        return new FilteredLFEdgeSet((Set<? extends LFEdge>)this.deletes(), new VertexMatchFilter(vertex, MatchType.SOURCE_MATCH));
    }

    public Set<LFEdge> substitutions() {
        if (this.substitutions == null) {
            this.substitutions = new LinkedHashSet<LFEdge>();
            Set bEdges = this.b.edgeSet();
            AlignedEdgeFilter sourceFilter = null;
            AlignedEdgeFilter targetFilter = null;
            CompositeFilter<LFEdge> filter = new CompositeFilter<LFEdge>();
            for (LFEdge aEdge : this.a.edgeSet()) {
                Set<Integer> sMaps = this.alignment.getTargets(aEdge.getSource().getIndex());
                Set<Integer> tMaps = this.alignment.getTargets(aEdge.getTarget().getIndex());
                if (sMaps.isEmpty() || tMaps.isEmpty()) continue;
                if (sourceFilter == null) {
                    sourceFilter = new AlignedEdgeFilter(sMaps, MatchType.SOURCE_ALIGNED, MatchType.TARGET_UNALIGNED);
                    targetFilter = new AlignedEdgeFilter(tMaps, MatchType.TARGET_ALIGNED, MatchType.SOURCE_UNALIGNED);
                    filter.addFilter(sourceFilter);
                    filter.addFilter(targetFilter);
                } else {
                    sourceFilter.setAlignmentIndices(sMaps);
                    targetFilter.setAlignmentIndices(tMaps);
                }
                this.substitutions.addAll(new FilteredLFEdgeSet(bEdges, (Filter<? super LFEdge>)filter));
            }
        }
        return Collections.unmodifiableSet(this.substitutions);
    }

    public Set<LFEdge> substitutionsFor(LFEdge edge) {
        Set<Integer> srcMapsTo = this.alignment.getTargets(edge.getSource().getIndex());
        Set<Integer> trgMapsTo = this.alignment.getTargets(edge.getTarget().getIndex());
        return srcMapsTo.isEmpty() || trgMapsTo.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(new FilteredLFEdgeSet((Set<? extends LFEdge>)this.substitutions(), new CompositeFilter(new AlignedEdgeFilter(srcMapsTo, MatchType.SOURCE_ALIGNED), new AlignedEdgeFilter(trgMapsTo, MatchType.TARGET_ALIGNED))));
    }

    public Map<LFVertex, Set<LFEdge>> substitutionsBySource() {
        Set<LFEdge> subs = this.substitutions();
        return subs.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new FilteredMap<LFVertex, FilteredLFEdgeSet>(new SourceView(), new VisitedFilter()));
    }

    public Map<LFVertex, Set<LFEdge>> substitutionsBySourceFor(LFEdge edge) {
        SubstitutedSourceView subsBySource = this.substitutionsBySource();
        return subsBySource.isEmpty() ? subsBySource : new SubstitutedSourceView(subsBySource, edge);
    }

    class SubstitutedSourceView
    extends AbstractMap<LFVertex, Set<LFEdge>> {
        Map<LFVertex, Set<LFEdge>> sourceView;
        LFEdge edge;
        private Set<Map.Entry<LFVertex, Set<LFEdge>>> entrySet;

        SubstitutedSourceView(Map<LFVertex, Set<LFEdge>> sourceView, LFEdge edge) {
            this.sourceView = sourceView;
            this.edge = edge;
        }

        @Override
        public Set<Map.Entry<LFVertex, Set<LFEdge>>> entrySet() {
            return this.entrySet == null ? (this.entrySet = new EntrySet()) : this.entrySet;
        }

        class EntrySet
        extends AbstractSet<Map.Entry<LFVertex, Set<LFEdge>>> {
            private Set<Map.Entry<LFVertex, Set<LFEdge>>> entries;
            Set<Integer> srcMapsTo;
            Set<Integer> trgMapsTo;

            EntrySet() {
                this.srcMapsTo = LFGraphDifference.this.alignment.getTargets(SubstitutedSourceView.this.edge.getSource().getIndex());
                this.trgMapsTo = LFGraphDifference.this.alignment.getTargets(SubstitutedSourceView.this.edge.getTarget().getIndex());
            }

            Set<Map.Entry<LFVertex, Set<LFEdge>>> entries() {
                if (this.entries == null) {
                    this.entries = new FilteredSet<Map.Entry<LFVertex, Set<LFEdge>>>(SubstitutedSourceView.this.sourceView.entrySet(), new Filter<Map.Entry<LFVertex, Set<LFEdge>>>(){

                        @Override
                        public boolean allows(Map.Entry<LFVertex, Set<LFEdge>> e) {
                            if (EntrySet.this.srcMapsTo.contains(e.getKey().getIndex())) {
                                for (LFEdge t : e.getValue()) {
                                    if (!EntrySet.this.trgMapsTo.contains(t.getTarget().getIndex())) continue;
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                }
                return this.entries;
            }

            @Override
            public int size() {
                return this.entries().size();
            }

            @Override
            public Iterator<Map.Entry<LFVertex, Set<LFEdge>>> iterator() {
                return new Iterator<Map.Entry<LFVertex, Set<LFEdge>>>(){
                    private Iterator<Map.Entry<LFVertex, Set<LFEdge>>> i;
                    {
                        this.i = EntrySet.this.entries().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<LFVertex, Set<LFEdge>> next() {
                        Map.Entry<LFVertex, Set<LFEdge>> e = this.i.next();
                        return new AbstractMap.SimpleImmutableEntry<LFVertex, Set<LFEdge>>(e.getKey(), new FilteredLFEdgeSet(e.getValue(), (Filter<? super LFEdge>)new Filter<LFEdge>(){

                            @Override
                            public boolean allows(LFEdge e) {
                                return EntrySet.this.trgMapsTo.contains(e.getTarget().getIndex());
                            }
                        }));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }

    class SourceView
    extends AbstractMap<LFVertex, FilteredLFEdgeSet> {
        SourceView() {
        }

        @Override
        public Set<Map.Entry<LFVertex, FilteredLFEdgeSet>> entrySet() {
            return new AbstractSet<Map.Entry<LFVertex, FilteredLFEdgeSet>>(){
                Set<LFEdge> subs;
                {
                    this.subs = LFGraphDifference.this.substitutions();
                }

                @Override
                public int size() {
                    return this.subs.size();
                }

                @Override
                public Iterator<Map.Entry<LFVertex, FilteredLFEdgeSet>> iterator() {
                    return new Iterator<Map.Entry<LFVertex, FilteredLFEdgeSet>>(){
                        private Iterator<LFEdge> edgeIterator = null;

                        @Override
                        public boolean hasNext() {
                            if (this.edgeIterator == null) {
                                this.edgeIterator = subs.iterator();
                            }
                            return this.edgeIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<LFVertex, FilteredLFEdgeSet> next() {
                            if (this.edgeIterator == null) {
                                this.edgeIterator = subs.iterator();
                            }
                            LFVertex src = this.edgeIterator.next().getSource();
                            return new AbstractMap.SimpleImmutableEntry<LFVertex, FilteredLFEdgeSet>(src, new FilteredLFEdgeSet((Set<? extends LFEdge>)subs, new VertexMatchFilter(src, MatchType.SOURCE_MATCH)));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }
}

