/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank.extract;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import opennlp.ccgbank.extract.FreqTally;

public class CatNode {
    public final String cat;
    public final String pos;
    private Map<String, Integer> lexFreq = new HashMap<String, Integer>();
    private Map<String, List<String>> lexOccur = new HashMap<String, List<String>>();

    public CatNode(String cat, String pos) {
        this.cat = cat;
        this.pos = pos;
    }

    public void lexInsert(String lex, String id) {
        if (!this.lexFreq.containsKey(lex)) {
            this.lexFreq.put(lex, 1);
            ArrayList<String> idList = new ArrayList<String>(4);
            idList.add(id);
            this.lexOccur.put(lex, idList);
        } else {
            this.lexFreq.put(lex, this.lexFreq.get(lex) + 1);
            List<String> idList = this.lexOccur.get(lex);
            if (!idList.contains(id) && idList.size() < 4) {
                idList.add(id);
            }
        }
    }

    public int getLexFreq(String lex) {
        Integer retval = this.lexFreq.get(lex);
        if (retval == null) {
            return 0;
        }
        return retval;
    }

    public void printTally(PrintWriter output) {
        List<String> sortedLex = FreqTally.sortTally(this.lexFreq);
        String ccgbankHome = System.getProperty("CCGBANK_HOME", "/home/corpora/EN/ccgbank");
        for (int i = 0; i < 3 && i < sortedLex.size(); ++i) {
            String lex = sortedLex.get(i);
            int freq = this.lexFreq.get(lex);
            output.println("<ul>");
            output.println("<li>");
            output.println(lex + " " + freq);
            List<String> temp = this.lexOccur.get(lex);
            for (String id : temp) {
                String[] idInfo = id.split("\\.");
                StringTokenizer st = new StringTokenizer(id, ".");
                output.println("<ul>");
                String idLink = "";
                String sentNo = "";
                String dir = "";
                if (idInfo.length == 2) {
                    idLink = st.nextToken() + ".html";
                    sentNo = "#Sentence " + st.nextToken();
                    dir = id.substring(4, 6);
                } else {
                    idLink = idInfo[0];
                    sentNo = "#Sentence " + idInfo[0];
                    dir = idInfo[0];
                }
                output.println("<li>");
                output.println(id);
                output.println(" <a href=file://" + ccgbankHome + "/original/data/HTML/" + dir + "/" + idLink + " target=" + sentNo + ">");
                output.println(idLink);
                output.println("</a>");
                output.println("</li>");
                output.println("</ul>");
            }
            output.println("</li>");
            output.println("</ul>");
            output.println("");
            output.flush();
        }
    }
}

