/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccgbank;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import opennlp.ccgbank.CCGBankTaskTemplates;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class XSLTProcessor {
    SAXTransformerFactory transformerFactory = this.newTransformerFactory();
    static final Properties xmlProperties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    List<CCGBankTaskTemplates> taskTemplatesList = new ArrayList<CCGBankTaskTemplates>();
    Serializer serializer = SerializerFactory.getSerializer((Properties)xmlProperties);
    ErrorListener errorListener;

    XSLTProcessor(ErrorListener errorListener) {
        this.errorListener = errorListener;
        this.transformerFactory.setErrorListener(errorListener);
    }

    boolean addAllTemplates(List<CCGBankTaskTemplates> templateList) {
        boolean b = false;
        for (CCGBankTaskTemplates t : templateList) {
            b |= this.addTemplates(t);
        }
        return b;
    }

    boolean addTemplates(CCGBankTaskTemplates taskTemplates) {
        return this.taskTemplatesList.add(taskTemplates);
    }

    abstract void process(InputSource var1) throws IOException, SAXException, TransformerException;

    void setTarget(File file) throws FileNotFoundException {
        this.serializer.setOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        this.serializer.setOutputFormat(xmlProperties);
    }

    void resetSerializer() {
        if (!this.serializer.reset()) {
            this.serializer = SerializerFactory.getSerializer((Properties)xmlProperties);
        }
    }

    SAXTransformerFactory newTransformerFactory() {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (!tf.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            throw new IllegalStateException("SAX transformer factory does not support SAXSource");
        }
        if (!tf.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new IllegalStateException("SAX transformer factory does not support SAXResult");
        }
        return tf;
    }

    List<Templates> makeTemplates(CCGBankTaskTemplates taskTemplates) throws FileNotFoundException, TransformerConfigurationException {
        return this.makeTemplates(Collections.singletonList(taskTemplates));
    }

    List<Templates> makeTemplates(List<CCGBankTaskTemplates> templateList) throws FileNotFoundException, TransformerConfigurationException {
        ArrayList<Templates> l = new ArrayList<Templates>();
        for (CCGBankTaskTemplates taskTemplates : templateList) {
            for (File f : taskTemplates) {
                StreamSource ss = new StreamSource(new BufferedInputStream(new FileInputStream(f)));
                ss.setSystemId(f);
                l.add(this.transformerFactory.newTemplates(ss));
            }
        }
        return Collections.unmodifiableList(l);
    }

    static {
        xmlProperties.setProperty("indent", "yes");
        xmlProperties.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
    }
}

