/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class Interner<T> {
    private Map<T, Reference<T>> weakMap = new WeakHashMap<T, Reference<T>>();
    private boolean softRefs = false;
    private static Interner<Object> globalInterner = null;

    public Interner() {
    }

    public Interner(boolean softRefs) {
        this.softRefs = softRefs;
    }

    public T intern(T obj) {
        if (this.weakMap.containsKey(obj)) {
            Reference<T> ref = this.weakMap.get(obj);
            return ref.get();
        }
        Reference ref = this.softRefs ? new SoftReference<T>(obj) : new WeakReference<T>(obj);
        this.weakMap.put(obj, ref);
        return obj;
    }

    public T getInterned(T obj) {
        Reference<T> ref = this.weakMap.get(obj);
        return ref != null ? (T)ref.get() : null;
    }

    public int size() {
        return this.weakMap.size();
    }

    public static Object globalIntern(Object obj) {
        if (globalInterner == null) {
            globalInterner = new Interner();
        }
        return globalInterner.intern(obj);
    }

    public static Object getGlobalInterned(Object obj) {
        if (globalInterner == null) {
            return null;
        }
        return globalInterner.getInterned(obj);
    }

    public static int globalSize() {
        if (globalInterner == null) {
            return 0;
        }
        return globalInterner.size();
    }

    public static void main(String[] args) {
        Integer interned;
        Integer intI;
        int i;
        Interner<Integer> interner = new Interner<Integer>();
        int SIZE = 100000;
        Integer[] ints = new Integer[SIZE];
        System.out.println("Adding " + SIZE + " ints to interner.");
        for (i = 0; i < SIZE; ++i) {
            ints[i] = new Integer(i);
            Integer interned2 = interner.intern(ints[i]);
            if (interned2 == ints[i]) continue;
            System.out.println("Whoops: ints[" + i + "] not == to interned: " + interned2);
            System.exit(-1);
        }
        System.out.println("interner.size(): " + interner.size());
        System.out.println("Doing gc().");
        System.gc();
        System.out.println("interner.size(): " + interner.size());
        System.out.println();
        System.out.println("Now adding " + SIZE + " equivalent ints to interner.");
        for (i = 0; i < SIZE; ++i) {
            intI = new Integer(i);
            interned = interner.intern(intI);
            if (interned != intI) continue;
            System.out.println("Whoops: intI (i=" + i + ") is == to interned: " + interned);
            System.exit(-1);
        }
        System.out.println("interner.size(): " + interner.size());
        System.out.println();
        System.out.println("Next adding " + SIZE + " new, unreferenced ints to interner.");
        for (i = SIZE; i < SIZE * 2; ++i) {
            intI = new Integer(i);
            interned = interner.intern(intI);
            if (interned == intI) continue;
            System.out.println("Whoops: intI (i=" + i + ") not == to interned: " + interned);
            System.exit(-1);
        }
        System.out.println("interner.size(): " + interner.size());
        System.out.println("Doing gc().");
        System.gc();
        System.out.println("interner.size(): " + interner.size());
        System.out.println();
    }
}

