/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.realize.hypertagger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import opennlp.ccg.realize.hypertagger.FeatureExtractionException;
import opennlp.ccg.realize.hypertagger.LFInfo;
import opennlp.ccg.realize.hypertagger.LFLoader;
import opennlp.ccg.realize.hypertagger.TagExtractor;
import opennlp.ccg.realize.hypertagger.ZLMaxentHypertagger;
import opennlp.ccg.realize.hypertagger.ZLPOSTagger;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.util.Pair;

public class TagExtract {
    private static boolean quiet = false;
    private static File posModelFile;
    private static File hyperModelFile;
    private static File posPriorModelFile;
    private static File htPriorModelFile;
    private static File posVocabFile;
    private static File htVocabFile;
    private static String argnames;
    private TagExtractor tex;
    private BufferedWriter output;

    public TagExtract(TagExtractor t) {
        this.tex = t;
    }

    public static void main(String[] args) throws IOException {
        TagExtractor tex;
        TagExtract t = null;
        OptionParser o = new OptionParser();
        o.acceptsAll(Arrays.asList("help", "h"), "this message");
        o.acceptsAll(Arrays.asList("quiet", "q"), "print no messages");
        o.acceptsAll(Arrays.asList("pos", "pos"), "extract POS features");
        ArgumentAcceptingOptionSpec pos_s = o.acceptsAll(Arrays.asList("p", "pos-model")).withRequiredArg().ofType(File.class).describedAs("POS model to use");
        ArgumentAcceptingOptionSpec outf = o.acceptsAll(Arrays.asList("o", "output")).withRequiredArg().ofType(File.class).describedAs("output file");
        ArgumentAcceptingOptionSpec posPrior_s = o.acceptsAll(Arrays.asList("P", "pos-prior")).withRequiredArg().ofType(File.class).describedAs("POS prior model to use");
        ArgumentAcceptingOptionSpec ht_s = o.acceptsAll(Arrays.asList("y", "hyper-model")).withRequiredArg().ofType(File.class).describedAs("HT model to use as input to 2-pass model (see README)");
        ArgumentAcceptingOptionSpec htPrior_s = o.acceptsAll(Arrays.asList("H", "ht-prior")).withRequiredArg().ofType(File.class).describedAs("HT prior model to use");
        ArgumentAcceptingOptionSpec gr_s = o.acceptsAll(Arrays.asList("g", "grammar")).withRequiredArg().ofType(File.class).describedAs("grammar filename");
        ArgumentAcceptingOptionSpec ht_vocab_s = o.acceptsAll(Arrays.asList("V", "ht-prior-vocab")).withRequiredArg().ofType(File.class).describedAs("HT prior vocab filename");
        ArgumentAcceptingOptionSpec pos_vocab_s = o.acceptsAll(Arrays.asList("v", "pos-prior-vocab")).withRequiredArg().ofType(File.class).describedAs("POS prior vocab filename");
        ArgumentAcceptingOptionSpec corpusDir_s = o.acceptsAll(Arrays.asList("d", "lf-dir")).withRequiredArg().ofType(File.class).describedAs("Directory to change to before searching for XML files");
        ArgumentAcceptingOptionSpec argnames_s = o.acceptsAll(Arrays.asList("an", "argnames")).withRequiredArg().describedAs("Names of argument roles in format name(:shortname)?");
        OptionSet options = o.parse(args);
        if (options.has("h") || args.length == 0) {
            o.printHelpOn((OutputStream)System.out);
            System.out.println("See the README for additional information.");
            System.exit(0);
        }
        BufferedWriter output = new BufferedWriter(new FileWriter((File)options.valueOf((OptionSpec)outf)));
        hyperModelFile = (File)options.valueOf((OptionSpec)ht_s);
        posModelFile = (File)options.valueOf((OptionSpec)pos_s);
        posPriorModelFile = (File)options.valueOf((OptionSpec)posPrior_s);
        posVocabFile = (File)options.valueOf((OptionSpec)pos_vocab_s);
        htPriorModelFile = (File)options.valueOf((OptionSpec)htPrior_s);
        htVocabFile = (File)options.valueOf((OptionSpec)ht_vocab_s);
        argnames = (String)options.valueOf((OptionSpec)argnames_s);
        if (options.has("q")) {
            quiet = true;
        }
        LFLoader lfs = new LFLoader((File)options.valueOf((OptionSpec)gr_s), (File)options.valueOf((OptionSpec)corpusDir_s), options.nonOptionArguments());
        if (options.has("pos")) {
            tex = new ZLPOSTagger();
            if (argnames != null) {
                TagExtract.debug("Setting arg names to " + argnames + "\n");
            }
            tex.setArgNames(argnames);
            if (posPriorModelFile != null && posVocabFile != null) {
                TagExtract.debug("Loading POS model priors from " + posPriorModelFile + "\n");
                TagExtract.debug("Loading POS model vocab from " + posVocabFile + "\n");
                tex.loadPriorModel(posPriorModelFile, posVocabFile);
            }
            TagExtract.debug("Extracting POS features...\n");
            t = new TagExtract(tex);
        } else {
            tex = new ZLMaxentHypertagger();
            if (argnames != null) {
                TagExtract.debug("Setting arg names to " + argnames + "\n");
            }
            tex.setArgNames(argnames);
            if (htPriorModelFile != null && htVocabFile != null) {
                TagExtract.debug("Loading HT model priors from " + htPriorModelFile + "\n");
                TagExtract.debug("Loading HT model vocab from " + htVocabFile + "\n");
                tex.loadPriorModel(htPriorModelFile, htVocabFile);
            }
            if (hyperModelFile != null) {
                TagExtract.debug("Loading proto-HT model from " + hyperModelFile + "\n");
                tex.loadProtoModel(hyperModelFile);
            }
            TagExtract.debug("Extracting hypertagger features...\n");
            t = new TagExtract(tex);
        }
        t.setOutput(output);
        while (lfs.hasNext()) {
            LFInfo lfi = lfs.next();
            LF lf = lfi.getLF();
            try {
                t.extract(lf, lfi.getFullWords());
            }
            catch (FeatureExtractionException e) {
                TagExtract.debug("In LF #" + lfi.getLFNum() + ":\n");
                TagExtract.debug(e.toString() + "\n");
            }
        }
        output.close();
        TagExtract.debug("\n");
    }

    private void extract(LF flatLF, String fullWords) throws FeatureExtractionException {
        this.tex.storeGoldStdPredInfo(fullWords);
        this.tex.setLF(flatLF);
        try {
            this.output.write(this.tex.getAllFeaturesAndAnswer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setOutput(BufferedWriter output) {
        this.output = output;
    }

    public static void debug(String string) {
        if (!quiet) {
            System.err.print(string);
        }
    }

    static class XmlFilenameFilter
    implements FileFilter {
        XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".xml");
        }
    }

    static class PairComparator
    implements Comparator {
        PairComparator() {
        }

        public int compare(Pair<Double, Integer> p, Pair<Double, Integer> q) {
            if ((Double)p.a > (Double)q.a) {
                return 1;
            }
            if (p.a == q.a) {
                return 0;
            }
            return -1;
        }

        public int compare(Object p, Object q) {
            return this.compare((Pair)p, (Pair)q);
        }
    }
}

