/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.perceptron;

import java.util.ArrayList;
import opennlp.ccg.perceptron.Alphabet;
import opennlp.ccg.perceptron.ComposedFeatureVector;
import opennlp.ccg.perceptron.FeatureExtractor;
import opennlp.ccg.perceptron.FeatureVector;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;

public class ComposedFeatureExtractor
implements FeatureExtractor {
    public final FeatureExtractor[] featureExtractors;

    public ComposedFeatureExtractor(FeatureExtractor[] featureExtractors) {
        this.featureExtractors = featureExtractors;
    }

    public ComposedFeatureExtractor(FeatureExtractor featureExtractor1, FeatureExtractor featureExtractor2) {
        this.featureExtractors = new FeatureExtractor[]{featureExtractor1, featureExtractor2};
    }

    public ComposedFeatureExtractor(SignScorer[] models) {
        ArrayList<FeatureExtractor> feList = new ArrayList<FeatureExtractor>(models.length);
        for (int i = 0; i < models.length; ++i) {
            if (!(models[i] instanceof FeatureExtractor)) continue;
            feList.add((FeatureExtractor)((Object)models[i]));
        }
        this.featureExtractors = feList.toArray(new FeatureExtractor[feList.size()]);
    }

    @Override
    public FeatureVector extractFeatures(Sign sign, boolean complete) {
        FeatureVector[] featureVectors = new FeatureVector[this.featureExtractors.length];
        for (int i = 0; i < this.featureExtractors.length; ++i) {
            featureVectors[i] = this.featureExtractors[i].extractFeatures(sign, complete);
        }
        return new ComposedFeatureVector(featureVectors);
    }

    @Override
    public void setAlphabet(Alphabet alphabet) {
        for (FeatureExtractor fe : this.featureExtractors) {
            fe.setAlphabet(alphabet);
        }
    }
}

