/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.parse.supertagger.io;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import opennlp.ccg.parse.supertagger.util.STTaggerWordDictionary;
import opennlp.ccg.util.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLWordDictionaryReader {
    private File dictFile;
    private XMLReader reader;
    private Map<String, Pair<Integer, Collection<String>>> dict;

    public XMLWordDictionaryReader(File df) {
        if (!df.exists()) {
            throw new RuntimeException("File " + df.getAbsolutePath().toString() + " does not exist.");
        }
        this.dictFile = df;
    }

    public STTaggerWordDictionary read() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            this.reader = parser.getXMLReader();
            this.reader.setContentHandler(new wdContentHandler());
            this.reader.parse(this.dictFile.toURI().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new STTaggerWordDictionary(this.dict);
    }

    public static void main(String[] args) {
        String fname = args[0];
        XMLWordDictionaryReader rdr = new XMLWordDictionaryReader(new File(fname));
        STTaggerWordDictionary dct = rdr.read();
        Iterator<Pair<String, Pair<Integer, Collection<String>>>> it = dct.getMappings();
        Pair<String, Pair<Integer, Collection<String>>> tempP = null;
        System.out.println("<wdict>");
        while (it.hasNext()) {
            tempP = it.next();
            System.out.println("     <entry word=\"" + (String)tempP.a + "\" freq=\"" + ((Pair)tempP.b).a + "\">");
            Iterator stgs = ((Collection)((Pair)tempP.b).b).iterator();
            while (stgs.hasNext()) {
                System.out.println("          <supertag> " + ((String)stgs.next()).trim() + " </supertag>");
            }
            System.out.println("     </entry>");
        }
        System.out.print("</wdict>");
    }

    class wdContentHandler
    extends DefaultHandler {
        private boolean inEntry = false;
        private boolean inSupertag = false;
        private String curWord = null;
        private String currSTFrag = null;

        wdContentHandler() {
        }

        @Override
        public void startDocument() {
            XMLWordDictionaryReader.this.dict = new TreeMap();
        }

        @Override
        public void startElement(String namespaceURI, String lname, String qname, Attributes attrs) throws SAXException {
            if (qname.equalsIgnoreCase("entry")) {
                if (this.inEntry) {
                    throw new SAXException("Something is wrong.\nThis is not a well-formed dictionary.");
                }
                this.inEntry = true;
                String word = attrs.getValue(0).trim();
                String freq = attrs.getValue(1).trim();
                word = word.replace("&amp;", "&");
                word = word.replace("&gt;", ">");
                word = word.replace("&lt;", "<");
                word = word.replace("&apos;", "'");
                word = word.replace("&quot;", "\"");
                XMLWordDictionaryReader.this.dict.put(word, new Pair(new Integer(Integer.parseInt(freq)), new HashSet()));
                this.curWord = word;
            } else if (qname.equalsIgnoreCase("supertag")) {
                if (!this.inEntry) {
                    throw new SAXException("Something is wrong.\nThis is not a well-formed dictionary.");
                }
                this.inSupertag = true;
                this.currSTFrag = "";
            }
        }

        @Override
        public void endElement(String uri, String lName, String qName) {
            if (qName.equalsIgnoreCase("entry")) {
                this.inEntry = false;
                this.curWord = null;
            } else if (qName.equalsIgnoreCase("supertag")) {
                this.inSupertag = false;
                Pair tempL = (Pair)XMLWordDictionaryReader.this.dict.get(this.curWord);
                ((Collection)tempL.b).add(this.currSTFrag.trim());
                XMLWordDictionaryReader.this.dict.put(this.curWord, tempL);
                this.currSTFrag = null;
            }
        }

        @Override
        public void characters(char[] ch, int start2, int length) {
            if (this.inSupertag && this.curWord != null) {
                String temp = new String(ch);
                temp = temp.substring(start2, start2 + length);
                this.currSTFrag = this.currSTFrag + temp;
            } else if (this.inSupertag) {
                System.err.println("Something is wrong.\nThis is not a well-formed dictionary.");
            }
        }
    }
}

