/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.ngrams;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import opennlp.ccg.ngrams.StandardNgramModel;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.test.CrossValidateRealizer;
import opennlp.ccg.test.ScorerMaker;

public class SRILM_ScorerMaker
implements ScorerMaker {
    public boolean useSemClasses = true;
    public boolean unk = true;
    public String minCountOptions = "-gt1min 1 -gt2min 1 -gt3min 1 -gt4min 1 -gt5min 1 -gt6min 1";
    public String discountOptions = "-ndiscount1 -ndiscount2 -ndiscount3 -ndiscount4 -ndiscount5 -ndiscount6";
    public static final String N_DISCOUNT_PARAMS = "-ndiscount1 -ndiscount2 -ndiscount3 -ndiscount4 -ndiscount5 -ndiscount6";
    public static final String WB_DISCOUNT_PARAMS = "-wbdiscount1 -wbdiscount2 -wbdiscount3 -wbdiscount4 -wbdiscount5 -wbdiscount6";
    public static final String KN_DISCOUNT_PARAMS = "-kndiscount1 -kndiscount2 -kndiscount3 -kndiscount4 -kndiscount5 -kndiscount6";
    public String discountOptionsStr = "n";
    public int debugLevel = 1;
    public CrossValidateRealizer cvr = null;
    protected List<Double> perplexities = new ArrayList<Double>();

    @Override
    public void setCVR(CrossValidateRealizer cvr) {
        this.cvr = cvr;
    }

    protected int getOrder() {
        int order = this.cvr.tester.ngramOrder;
        return order > 0 ? order : 3;
    }

    protected String filename(int foldNum) {
        String retval = "fold" + foldNum + "-" + this.discountOptionsStr;
        if (this.useSemClasses) {
            retval = retval + "-sc";
        }
        retval = retval + "." + this.getOrder() + "bo";
        return retval;
    }

    @Override
    public void prepScorer(File tmpDir, int foldNum, File trainFile, File testFile) throws IOException {
        this.writeTrainingAndTestFiles(tmpDir, foldNum, trainFile, testFile);
        String cmd = this.countNgrams(foldNum);
        System.out.print("Writing " + this.getOrder() + "-gram model: " + this.filename(foldNum) + "\n");
        Process makeLM = Runtime.getRuntime().exec(cmd, null, tmpDir);
        try {
            int b;
            InputStream istr = makeLM.getErrorStream();
            while ((b = istr.read()) != -1) {
                System.out.print((char)b);
            }
            int exitval = makeLM.waitFor();
            if (exitval != 0) {
                System.out.println("(f)ngram-count exitval: " + exitval);
            }
        }
        catch (InterruptedException exc) {
            throw (RuntimeException)new RuntimeException().initCause(exc);
        }
        System.out.println();
        String cmd2 = this.scoreNgrams(foldNum);
        System.out.print("Measuring perplexity with: " + this.filename(foldNum) + "\n");
        Process measurePPL = Runtime.getRuntime().exec(cmd2, null, tmpDir);
        try {
            int b;
            InputStream istr = measurePPL.getInputStream();
            StringBuffer sb = new StringBuffer();
            while ((b = istr.read()) != -1) {
                System.out.print((char)b);
                sb.append((char)b);
            }
            int exitval = measurePPL.waitFor();
            String pplOut = sb.toString();
            int pplStart = pplOut.indexOf("ppl= ") + "ppl= ".length();
            int pplEnd = pplOut.indexOf(" ", pplStart);
            String pplStr = pplOut.substring(pplStart, pplEnd);
            try {
                this.perplexities.add(new Double(pplStr));
            }
            catch (NumberFormatException exc) {
                System.out.println("Warning, unable to extract perplexity from: " + pplStr);
                System.out.println(exc.toString());
            }
            if (exitval != 0) {
                System.out.println("(f)ngram exitval: " + exitval);
            }
        }
        catch (InterruptedException exc) {
            throw (RuntimeException)new RuntimeException().initCause(exc);
        }
        System.out.println();
    }

    protected void writeTrainingAndTestFiles(File tmpDir, int foldNum, File trainFile, File testFile) throws IOException {
        File testFoldFile;
        File trainingFoldFile = new File(tmpDir, this.trainingfile(foldNum));
        if (!trainingFoldFile.exists()) {
            String trainingFoldPath = trainingFoldFile.getCanonicalPath();
            this.writeTargets(trainFile, trainingFoldPath);
        }
        if (!(testFoldFile = new File(tmpDir, this.testfile(foldNum))).exists()) {
            String testFoldPath = testFoldFile.getCanonicalPath();
            this.writeTargets(testFile, testFoldPath);
        }
    }

    protected String trainingfile(int foldNum) {
        return "fold" + foldNum + "-train.txt";
    }

    protected String testfile(int foldNum) {
        return "fold" + foldNum + "-test.txt";
    }

    protected void writeTargets(File tbFile, String textfile) throws IOException {
        if (!this.useSemClasses) {
            this.cvr.tester.writeTargets(tbFile, textfile);
        } else {
            this.cvr.tester.writeTargetsSC(tbFile, textfile);
        }
    }

    protected String countNgrams(int foldNum) {
        String lmfile = this.filename(foldNum);
        String cmd = "ngram-count -order " + this.getOrder() + " " + (this.unk ? "-unk " : "") + this.minCountOptions + " " + this.discountOptions + " -text " + this.trainingfile(foldNum) + " -lm " + lmfile + " -debug " + this.debugLevel;
        return cmd;
    }

    protected String scoreNgrams(int foldNum) {
        String lmfile = this.filename(foldNum);
        String cmd2 = "ngram -order " + this.getOrder() + " " + (this.unk ? "-unk " : "") + "-ppl " + this.testfile(foldNum) + " -lm " + lmfile;
        return cmd2;
    }

    protected String pplFileRoot() {
        return this.discountOptionsStr + this.getOrder();
    }

    @Override
    public void prepScorersSummary(File tmpDir) throws IOException {
        double sum = 0.0;
        System.out.print("Perplexities: ");
        for (int i = 0; i < this.perplexities.size(); ++i) {
            double ppl = this.perplexities.get(i);
            System.out.print(ppl + " ");
            sum += ppl;
        }
        System.out.println();
        double avg = sum / (double)this.perplexities.size();
        System.out.println("Avg: " + avg);
        String filename = "ppl";
        if (this.useSemClasses) {
            filename = filename + "-sc";
        }
        filename = filename + "." + this.pplFileRoot() + ".xml";
        System.out.println("Writing perplexities: " + filename);
        PrintWriter pw = new PrintWriter(new FileWriter(new File(tmpDir, filename)));
        pw.println("<perplexities avg=\"" + avg + "\">");
        for (int i = 0; i < this.perplexities.size(); ++i) {
            pw.println("  <fold num=\"" + i + "\" ppl=\"" + this.perplexities.get(i) + "\"/>");
        }
        pw.println("</perplexities>");
        pw.close();
    }

    @Override
    public SignScorer loadScorer(File tmpDir, int foldNum, File trainFile) throws IOException {
        String lmfile = this.filename(foldNum);
        String lmPath = new File(tmpDir, lmfile).getCanonicalPath();
        return new StandardNgramModel(this.getOrder(), lmPath, this.useSemClasses);
    }
}

