/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.lexicon.EntriesItem;
import opennlp.ccg.lexicon.Word;
import org.jdom.Element;

public class MorphItem {
    private static final String[] emptyStringArray = new String[0];
    private Word surfaceWord;
    private Word word;
    private Word coartIndexingWord = null;
    private String[] macros = emptyStringArray;
    private String[] excluded = emptyStringArray;
    private boolean coart = false;

    public MorphItem() {
    }

    public MorphItem(Element e) {
        String excludedString;
        String coartString = e.getAttributeValue("coart");
        if ("true".equals(coartString)) {
            this.coart = true;
        }
        String wordString = e.getAttributeValue("word");
        boolean strictFactors = this.coart;
        Word tokenizedWord = Grammar.theGrammar.lexicon.tokenizer.parseToken(wordString, strictFactors);
        this.surfaceWord = Word.createSurfaceWord(tokenizedWord);
        String stem = e.getAttributeValue("stem");
        if (stem == null) {
            stem = this.surfaceWord.getForm();
        }
        String POS = e.getAttributeValue("pos");
        String supertag = null;
        String semClass = e.getAttributeValue("class");
        this.word = Word.createFullWord(this.surfaceWord, stem, POS, supertag, semClass);
        String macrosString = e.getAttributeValue("macros");
        if (macrosString != null) {
            this.macros = macrosString.split("\\s+");
        }
        if ((excludedString = e.getAttributeValue("excluded")) != null) {
            this.excluded = excludedString.split("\\s+");
        }
        if (this.coart) {
            String indexAttr = wordString.substring(0, wordString.indexOf("-"));
            String indexVal = this.surfaceWord.getVal(indexAttr);
            this.coartIndexingWord = Word.createWord(indexAttr, indexVal);
        }
    }

    public boolean excluded(EntriesItem eItem) {
        if (this.excluded.length == 0) {
            return false;
        }
        for (int i = 0; i < this.excluded.length; ++i) {
            if (eItem.getName().equals(this.excluded[i])) {
                return true;
            }
            if (eItem.getQualifiedName().equals(this.excluded[i])) {
                return true;
            }
            if (!eItem.getFamilyName().equals(this.excluded[i])) continue;
            return true;
        }
        return false;
    }

    public Word getWord() {
        return this.word;
    }

    public Word getSurfaceWord() {
        return this.surfaceWord;
    }

    public String[] getMacros() {
        return this.macros;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    public boolean isCoart() {
        return this.coart;
    }

    public Word getCoartIndexingWord() {
        return this.coartIndexingWord;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < this.macros.length; ++i) {
            sb.append(this.macros[i]);
            if (i >= this.macros.length - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return "{" + this.word + " => " + sb + "}";
    }
}

