/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.lexicon;

import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloVar;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.lexicon.DataItem;
import opennlp.ccg.lexicon.DefaultTokenizer;
import opennlp.ccg.lexicon.EntriesItem;
import opennlp.ccg.lexicon.Family;
import opennlp.ccg.lexicon.LexException;
import opennlp.ccg.lexicon.LicensingFeature;
import opennlp.ccg.lexicon.MacroAdder;
import opennlp.ccg.lexicon.MacroItem;
import opennlp.ccg.lexicon.MorphItem;
import opennlp.ccg.lexicon.SupertaggerAdapter;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.lexicon.Word;
import opennlp.ccg.synsem.AtomCat;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.CategoryFcn;
import opennlp.ccg.synsem.CategoryFcnAdapter;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignHash;
import opennlp.ccg.unify.FeatureStructure;
import opennlp.ccg.unify.GFeatStruc;
import opennlp.ccg.unify.GFeatVar;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.Mutable;
import opennlp.ccg.unify.SimpleType;
import opennlp.ccg.unify.UnifyControl;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.util.GroupMap;
import opennlp.ccg.util.IntHashSetMap;
import opennlp.ccg.util.Interner;
import opennlp.ccg.util.Pair;
import opennlp.ccg.util.XmlScanner;
import org.jdom.Element;

public class Lexicon {
    public static final String NO_SEM_FLAG = "*NoSem*";
    public static final String DEFAULT_VAL = "[*DEFAULT*]";
    private SupertaggerAdapter _supertagger = null;
    private GroupMap<Word, MorphItem> _words;
    private GroupMap<String, Object> _stems;
    private GroupMap<String, FeatureStructure> _macros;
    private HashMap<String, MacroItem> _macroItems;
    private GroupMap<String, EntriesItem[]> _posToEntries;
    private GroupMap<String, EntriesItem> _stagToEntries;
    private GroupMap<String, Word> _predToWords;
    private GroupMap<String, String> _relsToPreds;
    private GroupMap<String, String> _coartRelsToPreds;
    private Set<String> _coartAttrs;
    private Set<String> _indexedCoartAttrs;
    private GroupMap<String, String> _catsToAttrs;
    private Set<String> _lfAttrs;
    private String[] _distributiveAttrs = null;
    private LicensingFeature[] _licensingFeatures = null;
    private HashMap<String, Integer> _relationIndexMap = new HashMap();
    private Interner<Object> lookupCache = new Interner(true);
    public final Grammar grammar;
    public final Tokenizer tokenizer;
    public boolean openlex = false;
    public boolean debugSemClasses = false;
    private CategoryFcn gatherAttrs = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            String type = ((AtomCat)c).getType();
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            for (String att : fs.getAttributes()) {
                Lexicon.this._catsToAttrs.put(type, att);
                if (!(fs.getValue(att) instanceof LF)) continue;
                Lexicon.this._lfAttrs.add(att);
            }
        }
    };
    private TIntObjectHashMap featStrucMap = new TIntObjectHashMap();
    private CategoryFcn indexFeatStrucs = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            FeatureStructure fs = c.getFeatureStructure();
            if (fs != null && fs.getIndex() != 0) {
                Lexicon.this.featStrucMap.put(fs.getIndex(), (Object)fs);
            }
        }
    };
    private CategoryFcn doInheritsFrom = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            String type = ((AtomCat)c).getType();
            FeatureStructure fs = c.getFeatureStructure();
            GFeatStruc gfs = (GFeatStruc)fs;
            if (gfs == null || gfs.getInheritsFrom() == 0) {
                return;
            }
            int inhf = gfs.getInheritsFrom();
            FeatureStructure inhfFS = (FeatureStructure)Lexicon.this.featStrucMap.get(inhf);
            if (inhfFS != null) {
                for (String att : inhfFS.getAttributes()) {
                    if (gfs.hasAttribute(att)) continue;
                    gfs.setFeature(att, UnifyControl.copy(inhfFS.getValue(att)));
                }
                Set attrs = Lexicon.this._catsToAttrs.get(type);
                if (attrs == null) {
                    return;
                }
                for (String att : attrs) {
                    if (gfs.hasAttribute(att)) continue;
                    String varName = att.toUpperCase() + inhf;
                    if (Lexicon.this._lfAttrs.contains(att)) {
                        gfs.setFeature(att, new HyloVar(varName));
                        inhfFS.setFeature(att, new HyloVar(varName));
                        continue;
                    }
                    gfs.setFeature(att, new GFeatVar(varName));
                    inhfFS.setFeature(att, new GFeatVar(varName));
                }
            } else {
                System.err.println("Warning: no feature structure with inheritsFrom index of " + inhf + " found in category " + c);
            }
        }
    };
    private SimpleType SEMCLASS = null;
    private ModFcn defaultNomvarUnifier = new ModFcn(){

        @Override
        public void modify(Mutable m) {
            if (!(m instanceof SatOp)) {
                return;
            }
            SatOp satop = (SatOp)m;
            if (!(satop.getArg() instanceof Proposition)) {
                return;
            }
            Proposition prop = (Proposition)satop.getArg();
            if (!prop.getName().equals(Lexicon.DEFAULT_VAL)) {
                return;
            }
            if (!(satop.getNominal() instanceof NominalVar)) {
                return;
            }
            NominalVar nv = (NominalVar)satop.getNominal();
            SimpleType st = nv.getType();
            if (st.equals(Lexicon.this.SEMCLASS)) {
                return;
            }
            try {
                SimpleType stU = (SimpleType)st.unify(Lexicon.this.SEMCLASS, null);
                nv.setType(stU);
            }
            catch (UnifyFailure uf) {
                throw new TypePropagationException(st, Lexicon.this.SEMCLASS);
            }
        }
    };
    private String REPLACEMENT = "";
    private ModFcn defaultReplacer = new ModFcn(){

        @Override
        public void modify(Mutable m) {
            if (m instanceof Proposition) {
                Proposition prop = (Proposition)m;
                if (prop.getName().equals(Lexicon.DEFAULT_VAL)) {
                    prop.setAtomName(Lexicon.this.REPLACEMENT);
                }
            } else if (m instanceof FeatureStructure) {
                FeatureStructure fs = (FeatureStructure)m;
                for (String attr : fs.getAttributes()) {
                    Object val = fs.getValue(attr);
                    if (!(val instanceof SimpleType) || !((SimpleType)val).getName().equals(Lexicon.DEFAULT_VAL)) continue;
                    fs.setFeature(attr, Lexicon.this.grammar.types.getSimpleType(Lexicon.this.REPLACEMENT));
                }
            }
        }
    };
    private Map<MorphItem, MacroAdder> macAdderMap = new HashMap<MorphItem, MacroAdder>();
    private Map<NominalVar, SimpleType> nomvarMap = new THashMap(new TObjectHashingStrategy(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(Object o) {
            return ((NominalVar)o).getName().hashCode();
        }

        public boolean equals(Object o1, Object o2) {
            return ((NominalVar)o1).getName().equals(((NominalVar)o2).getName());
        }
    });
    private ModFcn nomvarTypePropagater = new ModFcn(){

        @Override
        public void modify(Mutable m) {
            if (m instanceof NominalVar) {
                NominalVar nv = (NominalVar)m;
                SimpleType st = nv.getType();
                SimpleType st0 = (SimpleType)Lexicon.this.nomvarMap.get(nv);
                if (st0 == null) {
                    Lexicon.this.nomvarMap.put(nv, st);
                    return;
                }
                if (st.equals(st0)) {
                    return;
                }
                try {
                    SimpleType stU = (SimpleType)st.unify(st0, null);
                    nv.setType(stU);
                    Lexicon.this.nomvarMap.put(nv, stU);
                }
                catch (UnifyFailure uf) {
                    throw new TypePropagationException(st, st0);
                }
            }
        }
    };
    private List[] distrAttrVals = null;
    private CategoryFcn gatherDistrAttrVals = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            for (int i = 0; i < Lexicon.this._distributiveAttrs.length; ++i) {
                String attr = Lexicon.this._distributiveAttrs[i];
                Object val = fs.getValue(attr);
                if (val == null || Lexicon.this.distrAttrVals[i].contains(val)) continue;
                Lexicon.this.distrAttrVals[i].add(val);
            }
        }
    };
    private CategoryFcn propagateUniqueDistrAttrVals = new CategoryFcnAdapter(){

        @Override
        public void forall(Category c) {
            if (!(c instanceof AtomCat)) {
                return;
            }
            FeatureStructure fs = c.getFeatureStructure();
            if (fs == null) {
                return;
            }
            for (int i = 0; i < Lexicon.this._distributiveAttrs.length; ++i) {
                if (Lexicon.this.distrAttrVals[i].size() != 1) continue;
                Object distVal = Lexicon.this.distrAttrVals[i].get(0);
                String attr = Lexicon.this._distributiveAttrs[i];
                Object val = fs.getValue(attr);
                if (val != null) continue;
                fs.setFeature(attr, UnifyControl.copy(distVal));
            }
        }
    };
    private static String[] defaultRelationSortOrder = new String[]{"BoundVar", "PairedWith", "Restr", "Body", "Scope", "*", "GenRel", "Coord", "Append"};

    public Lexicon(Grammar grammar) {
        this.grammar = grammar;
        this.tokenizer = new DefaultTokenizer();
    }

    public Lexicon(Grammar grammar, Tokenizer tokenizer) {
        this.grammar = grammar;
        this.tokenizer = tokenizer;
    }

    public void setSupertagger(SupertaggerAdapter supertagger) {
        this._supertagger = supertagger;
    }

    public void init(URL lexiconUrl, URL morphUrl) throws IOException {
        List<Family> lexicon = null;
        List morph = null;
        List macroModel = null;
        lexicon = this.getLexicon(lexiconUrl);
        Pair<List<MorphItem>, List<MacroItem>> morphInfo = this.getMorph(morphUrl);
        morph = (List)morphInfo.a;
        macroModel = (List)morphInfo.b;
        this._words = new GroupMap();
        this._predToWords = new GroupMap();
        this._coartAttrs = new HashSet<String>();
        this._indexedCoartAttrs = new HashSet<String>();
        for (MorphItem morphItem : morph) {
            Word surfaceWord = morphItem.getSurfaceWord();
            this._words.put(surfaceWord, morphItem);
            this._predToWords.put(morphItem.getWord().getStem(), surfaceWord);
            if (!morphItem.isCoart()) continue;
            Word indexingWord = morphItem.getCoartIndexingWord();
            this._words.put(indexingWord, morphItem);
            Pair<String, String> first = indexingWord.getSurfaceAttrValPairs().next();
            this._indexedCoartAttrs.add((String)first.a);
            Iterator<Pair<String, String>> it = surfaceWord.getSurfaceAttrValPairs();
            while (it.hasNext()) {
                Pair<String, String> p = it.next();
                this._coartAttrs.add((String)p.a);
            }
        }
        this._stems = new GroupMap();
        this._posToEntries = new GroupMap();
        this._stagToEntries = new GroupMap();
        this._relsToPreds = new GroupMap();
        this._coartRelsToPreds = new GroupMap();
        this._catsToAttrs = new GroupMap();
        this._lfAttrs = new HashSet<String>();
        HashSet<String> familyAndEntryNames = new HashSet<String>();
        for (Family family : lexicon) {
            int j;
            familyAndEntryNames.add(family.getName());
            EntriesItem[] entries = family.getEntries();
            DataItem[] data = family.getData();
            if (!family.isClosed()) {
                this._posToEntries.put(family.getPOS(), entries);
            }
            for (j = 0; j < entries.length; ++j) {
                EntriesItem eItem = entries[j];
                this._stagToEntries.put(eItem.getSupertag() + family.getPOS(), eItem);
                if (eItem.getStem().length() > 0) {
                    this._stems.put(eItem.getStem() + family.getPOS(), eItem);
                }
                try {
                    eItem.getCat().forall(this.gatherAttrs);
                    familyAndEntryNames.add(eItem.getName());
                    familyAndEntryNames.add(eItem.getQualifiedName());
                    continue;
                }
                catch (RuntimeException exc) {
                    System.err.println("exception for: " + family.getName() + ": " + exc);
                }
            }
            for (j = 0; j < data.length; ++j) {
                DataItem dItem = data[j];
                this._stems.put(dItem.getStem() + family.getPOS(), new Pair<DataItem, EntriesItem[]>(dItem, entries));
                if (dItem.getStem().equals(dItem.getPred())) continue;
                Set<Word> words = this._predToWords.get(dItem.getStem());
                if (words == null) {
                    if (this.openlex) continue;
                    System.out.print("Warning: couldn't find words for pred '");
                    System.out.println(dItem.getPred() + "' with stem '" + dItem.getStem() + "'");
                    continue;
                }
                Iterator it = words.iterator();
                while (it.hasNext()) {
                    this._predToWords.put(dItem.getPred(), (Word)it.next());
                }
            }
            ArrayList<String> indexRels = new ArrayList<String>(3);
            String familyIndexRel = family.getIndexRel();
            if (familyIndexRel.length() > 0) {
                indexRels.add(familyIndexRel);
            }
            for (int j2 = 0; j2 < entries.length; ++j2) {
                EntriesItem eItem = entries[j2];
                String indexRel = eItem.getIndexRel();
                if (indexRel.length() <= 0 || indexRel.equals(familyIndexRel)) continue;
                indexRels.add(indexRel);
            }
            for (String indexRel : indexRels) {
                for (int j3 = 0; j3 < data.length; ++j3) {
                    DataItem dItem = data[j3];
                    this._relsToPreds.put(indexRel, dItem.getPred());
                }
            }
            String coartRel = family.getCoartRel();
            if (coartRel.length() <= 0) continue;
            for (int j4 = 0; j4 < data.length; ++j4) {
                this._coartRelsToPreds.put(coartRel, data[j4].getPred());
            }
        }
        this._macros = new GroupMap();
        this._macroItems = new HashMap();
        for (MacroItem mi : macroModel) {
            String macName = mi.getName();
            FeatureStructure[] specs = mi.getFeatureStructures();
            for (int j = 0; j < specs.length; ++j) {
                this._macros.put(macName, specs[j]);
            }
            this._macroItems.put(macName, mi);
        }
        for (MorphItem morphItem : morph) {
            Word w = morphItem.getWord();
            if (!(this.openlex || this._stems.containsKey(w.getStem() + w.getPOS()) || this._posToEntries.containsKey(w.getPOS()))) {
                System.err.println("Warning: no entries for stem '" + w.getStem() + "' and POS '" + w.getPOS() + "' found for word '" + w + "'");
            }
            String[] macroNames = morphItem.getMacros();
            for (int j = 0; j < macroNames.length; ++j) {
                if (this._macroItems.containsKey(macroNames[j])) continue;
                System.err.println("Warning: macro " + macroNames[j] + " not found for word '" + morphItem.getWord() + "'");
            }
            String[] excludedNames = morphItem.getExcluded();
            for (int j = 0; j < excludedNames.length; ++j) {
                if (familyAndEntryNames.contains(excludedNames[j])) continue;
                System.err.println("Warning: excluded family or entry '" + excludedNames[j] + "' not found for word '" + morphItem.getWord() + "'");
            }
        }
    }

    public void expandInheritsFrom(Category cat) {
        this.expandInheritsFrom(cat, null);
    }

    public void expandInheritsFrom(Category cat, Category cat2) {
        this.featStrucMap.clear();
        cat.forall(this.indexFeatStrucs);
        if (cat2 != null) {
            cat2.forall(this.indexFeatStrucs);
        }
        cat.forall(this.doInheritsFrom);
        if (cat2 != null) {
            cat2.forall(this.doInheritsFrom);
        }
    }

    public Collection<Sign> getSignsFromRel(String rel) {
        RelLookup lookup;
        RelLookup retLookup;
        if (this._supertagger == null && (retLookup = (RelLookup)this.lookupCache.getInterned(lookup = new RelLookup(rel))) != null) {
            return retLookup.signs;
        }
        Set<String> preds = this._relsToPreds.get(rel);
        if (preds == null) {
            return null;
        }
        Collection<Sign> retval = this.getSignsFromRelAndPreds(rel, preds);
        if (this._supertagger == null && retval != null) {
            RelLookup lookup2 = new RelLookup(rel);
            lookup2.signs = retval;
            this.lookupCache.intern(lookup2);
        }
        return retval;
    }

    private Collection<Sign> getSignsFromRelAndPreds(String rel, Collection<String> preds) {
        ArrayList<Sign> retval = new ArrayList<Sign>();
        for (String pred : preds) {
            Collection<Sign> signs = this.getSignsFromPredAndTargetRel(pred, rel);
            if (signs == null) continue;
            retval.addAll(signs);
        }
        if (retval.size() > 0) {
            return retval;
        }
        return null;
    }

    public Collection<Sign> getSignsFromPred(String pred, List<String> coartRels) {
        PredLookup lookup;
        PredLookup retLookup;
        if (this._supertagger == null && (retLookup = (PredLookup)this.lookupCache.getInterned(lookup = new PredLookup(pred, coartRels))) != null) {
            return retLookup.signs;
        }
        Collection<Sign> result = this.getSignsFromPredAndTargetRel(pred, null);
        if (result == null) {
            return null;
        }
        if (coartRels != null) {
            this.applyCoarts(coartRels, result);
        }
        if (this._supertagger == null) {
            PredLookup lookup2 = new PredLookup(pred, coartRels);
            lookup2.signs = result;
            this.lookupCache.intern(lookup2);
        }
        return result;
    }

    private Collection<Sign> getSignsFromPredAndTargetRel(String pred, String targetRel) {
        Collection<Word> words = this._predToWords.get(pred);
        String specialTokenConst = null;
        int dotIndex = -1;
        if (this._supertagger != null && !Character.isDigit(pred.charAt(0)) && (dotIndex = pred.lastIndexOf(46)) > 0 && pred.length() > dotIndex + 1 && pred.charAt(dotIndex + 1) != '_') {
            String barePred = pred.substring(0, dotIndex);
            Set<Word> barePredWords = this._predToWords.get(barePred);
            if (words == null) {
                words = barePredWords;
            } else if (barePredWords != null) {
                HashSet<Word> unionWords = new HashSet<Word>(words);
                unionWords.addAll(barePredWords);
                words = unionWords;
            }
        }
        if (words == null) {
            specialTokenConst = this.tokenizer.getSpecialTokenConstant(this.tokenizer.isSpecialToken(pred));
            if (specialTokenConst == null) {
                return null;
            }
            Set<Word> specialTokenWords = this._predToWords.get(specialTokenConst);
            if (specialTokenWords == null) {
                return null;
            }
            words = new ArrayList(specialTokenWords.size());
            for (Word stw : specialTokenWords) {
                Word w = Word.createSurfaceWord(stw, pred);
                words.add(w);
            }
        }
        ArrayList<Sign> retval = new ArrayList<Sign>();
        for (Word w : words) {
            try {
                SignHash signs = this.getSignsFromWord(w, specialTokenConst, pred, targetRel);
                retval.addAll(signs.asSignSet());
            }
            catch (LexException exc) {
                System.err.println("Unexpected lex exception for word " + w + ": " + exc);
            }
        }
        return retval;
    }

    private void applyCoarts(List<String> coartRels, Collection<Sign> result) {
        ArrayList<Sign> inputSigns = new ArrayList<Sign>(result);
        result.clear();
        ArrayList<Sign> outputSigns = new ArrayList<Sign>(inputSigns.size());
        for (String rel : coartRels) {
            Collection<Sign> coartResult;
            Set<String> preds = this._coartRelsToPreds.get(rel);
            if (preds == null || (coartResult = this.getSignsFromRelAndPreds(rel, preds)) == null) continue;
            for (Sign coartSign : coartResult) {
                for (int j = 0; j < inputSigns.size(); ++j) {
                    Sign sign = (Sign)inputSigns.get(j);
                    this.grammar.rules.applyCoart(sign, coartSign, outputSigns);
                }
            }
            inputSigns.clear();
            inputSigns.addAll(outputSigns);
            outputSigns.clear();
        }
        result.addAll(inputSigns);
    }

    public List<SignHash> getEntriesFromWords(String s) throws LexException {
        ArrayList<SignHash> entries = new ArrayList<SignHash>();
        List<Word> words = this.tokenizer.tokenize(s);
        for (Word w : words) {
            SignHash signs = this.getSignsFromWord(w);
            if (signs.size() == 0) {
                throw new LexException("Word not in lexicon: \"" + w + "\"");
            }
            entries.add(signs);
        }
        return entries;
    }

    public SignHash getSignsFromWord(Word w) throws LexException {
        Word surfaceWord = Word.createSurfaceWord(w);
        Word coreWord = surfaceWord.attrsIntersect(this._coartAttrs) ? Word.createCoreSurfaceWord(surfaceWord, this._coartAttrs) : surfaceWord;
        SignHash result = this.getSignsFromWord(coreWord, null, null, null);
        if (result.size() == 0) {
            throw new LexException(coreWord + " not found in lexicon");
        }
        if (coreWord == surfaceWord) {
            return result;
        }
        this.applyCoarts(surfaceWord, result);
        return result;
    }

    private void applyCoarts(Word w, SignHash result) throws LexException {
        ArrayList<Sign> inputSigns = new ArrayList<Sign>(result.asSignSet());
        result.clear();
        ArrayList<Sign> outputSigns = new ArrayList<Sign>(inputSigns.size());
        Iterator<Pair<String, String>> it = w.getSurfaceAttrValPairs();
        while (it.hasNext()) {
            Pair<String, String> p = it.next();
            String attr = (String)p.a;
            if (!this._indexedCoartAttrs.contains(attr)) continue;
            String val = (String)p.b;
            Word coartWord = Word.createWord(attr, val);
            SignHash coartResult = this.getSignsFromWord(coartWord, null, null, null);
            Iterator it2 = coartResult.iterator();
            while (it2.hasNext()) {
                Sign coartSign = (Sign)it2.next();
                for (int j = 0; j < inputSigns.size(); ++j) {
                    Sign sign = (Sign)inputSigns.get(j);
                    this.grammar.rules.applyCoart(sign, coartSign, outputSigns);
                }
            }
            inputSigns.clear();
            inputSigns.addAll(outputSigns);
            outputSigns.clear();
        }
        result.addAll(inputSigns);
    }

    private SignHash getSignsFromWord(Word w, String specialTokenConst, String targetPred, String targetRel) throws LexException {
        Set<MorphItem> morphItems;
        Set<MorphItem> set = morphItems = specialTokenConst == null ? this._words.get(w) : null;
        if (morphItems == null) {
            if (specialTokenConst == null) {
                specialTokenConst = this.tokenizer.getSpecialTokenConstant(this.tokenizer.isSpecialToken(w.getForm()));
                targetPred = w.getForm();
            }
            if (specialTokenConst != null) {
                Word key = Word.createSurfaceWord(w, specialTokenConst);
                morphItems = this._words.get(key);
            }
            if (morphItems == null) {
                throw new LexException(w + " not in lexicon");
            }
        }
        SignHash result = new SignHash();
        Iterator MI = morphItems.iterator();
        while (MI.hasNext()) {
            this.getWithMorphItem(w, (MorphItem)MI.next(), targetPred, targetRel, result);
        }
        return result;
    }

    private void getWithMorphItem(Word w, MorphItem mi, String targetPred, String targetRel, SignHash result) throws LexException {
        Set<EntriesItem[]> entrySets;
        Map<String, Double> supertags = null;
        HashSet<String> supertagsFound = null;
        if (this._supertagger != null && (supertags = this._supertagger.getSupertags()) != null) {
            supertagsFound = new HashSet<String>(supertags.size());
        }
        MacroAdder macAdder = this.getMacAdder(mi);
        String stem = mi.getWord().getStem();
        String pos = mi.getWord().getPOS();
        HashSet<EntriesItem[]> explicitEntries = null;
        if (this._stems.containsKey(stem + pos)) {
            explicitEntries = new HashSet<EntriesItem[]>();
            Set<Object> stemItems = this._stems.get(stem + pos);
            for (Object e : stemItems) {
                if (e instanceof EntriesItem) {
                    EntriesItem entry = (EntriesItem)e;
                    this.getWithEntriesItem(w, mi, stem, stem, targetPred, targetRel, entry, macAdder, supertags, supertagsFound, result);
                    continue;
                }
                DataItem dItem = (DataItem)((Pair)e).a;
                EntriesItem[] entries = (EntriesItem[])((Pair)e).b;
                explicitEntries.add(entries);
                this.getWithDataItem(w, mi, dItem, entries, targetPred, targetRel, macAdder, supertags, supertagsFound, result);
            }
        }
        if ((entrySets = this._posToEntries.get(pos)) != null) {
            for (EntriesItem[] entriesItemArray : entrySets) {
                if (explicitEntries != null && explicitEntries.contains(entriesItemArray)) continue;
                String pred = targetPred != null ? targetPred : stem;
                this.getWithDataItem(w, mi, new DataItem(stem, pred), entriesItemArray, targetPred, targetRel, macAdder, supertags, supertagsFound, result);
            }
        }
        if (supertags != null) {
            for (String string : supertags.keySet()) {
                Set<EntriesItem> entries;
                if (supertagsFound.contains(string) || (entries = this._stagToEntries.get(string + pos)) == null) continue;
                String pred = targetPred != null ? targetPred : stem;
                for (EntriesItem entry : entries) {
                    if (!entry.getStem().equals(DEFAULT_VAL)) continue;
                    this.getWithEntriesItem(w, mi, stem, pred, targetPred, targetRel, entry, macAdder, supertags, supertagsFound, result);
                }
            }
        }
    }

    private void getWithDataItem(Word w, MorphItem mi, DataItem item, EntriesItem[] entries, String targetPred, String targetRel, MacroAdder macAdder, Map<String, Double> supertags, Set<String> supertagsFound, SignHash result) {
        for (int i = 0; i < entries.length; ++i) {
            EntriesItem entry = entries[i];
            if (!entry.getStem().equals(DEFAULT_VAL)) continue;
            this.getWithEntriesItem(w, mi, item.getStem(), item.getPred(), targetPred, targetRel, entry, macAdder, supertags, supertagsFound, result);
        }
    }

    private void getWithEntriesItem(Word w, MorphItem mi, String stem, String pred, String targetPred, String targetRel, EntriesItem item, MacroAdder macAdder, Map<String, Double> supertags, Set<String> supertagsFound, SignHash result) {
        if (targetPred != null && !targetPred.equals(pred)) {
            return;
        }
        if (targetRel != null && !targetRel.equals(item.getIndexRel()) && !targetRel.equals(item.getCoartRel())) {
            return;
        }
        if (!item.getActive().booleanValue()) {
            return;
        }
        if (mi.excluded(item)) {
            return;
        }
        try {
            Category cat = item.getCat().copy();
            macAdder.addMacros(cat);
            this.unifySemClass(cat, mi.getWord().getSemClass());
            this.REPLACEMENT = pred;
            cat.deepMap(this.defaultReplacer);
            if (supertags != null) {
                String stag = cat.getSupertag();
                if (!supertags.containsKey(stag)) {
                    return;
                }
                supertagsFound.add(stag);
            }
            this.propagateTypes(cat);
            this.propagateDistributiveAttrs(cat);
            this.expandInheritsFrom(cat);
            Word word = Word.createFullWord(w, mi.getWord(), cat.getSupertag());
            Sign sign = new Sign(word, cat);
            sign.setOrigin();
            result.insert(sign);
        }
        catch (RuntimeException exc) {
            System.err.println("Warning: ignoring entry: " + item.getName() + " of family: " + item.getFamilyName() + " for stem: " + stem + " b/c: " + exc.toString());
        }
    }

    private void unifySemClass(Category cat, String semClass) {
        block3: {
            if (semClass == null || cat.getLF() == null) {
                return;
            }
            this.SEMCLASS = this.grammar.types.getSimpleType(semClass);
            try {
                cat.getLF().deepMap(this.defaultNomvarUnifier);
            }
            catch (TypePropagationException tpe) {
                if (!this.debugSemClasses) break block3;
                System.err.println("Warning: unable to unify types '" + tpe.st1 + "' and '" + tpe.st2 + "' in unifying sem class in cat: \n" + cat);
            }
        }
    }

    private MacroAdder getMacAdder(MorphItem mi) {
        MacroAdder retval = this.macAdderMap.get(mi);
        if (retval != null) {
            return retval;
        }
        IntHashSetMap macrosFromLex = new IntHashSetMap();
        String[] newMacroNames = mi.getMacros();
        ArrayList<MacroItem> macroItems = new ArrayList<MacroItem>();
        for (int i = 0; i < newMacroNames.length; ++i) {
            MacroItem macroItem;
            Set<FeatureStructure> featStrucs = this._macros.get(newMacroNames[i]);
            if (featStrucs != null) {
                for (FeatureStructure fs : featStrucs) {
                    macrosFromLex.put(fs.getIndex(), fs);
                }
            }
            if ((macroItem = this._macroItems.get(newMacroNames[i])) != null) {
                macroItems.add(macroItem);
                continue;
            }
            System.err.println("Warning: macro " + newMacroNames[i] + " not found for word '" + mi.getWord() + "'");
        }
        retval = new MacroAdder(macrosFromLex, macroItems);
        this.macAdderMap.put(mi, retval);
        return retval;
    }

    public void propagateTypes(Category cat) {
        this.propagateTypes(cat, null);
    }

    public void propagateTypes(Category cat, Category cat2) {
        block4: {
            try {
                this.nomvarMap.clear();
                cat.deepMap(this.nomvarTypePropagater);
                if (cat2 != null) {
                    cat2.deepMap(this.nomvarTypePropagater);
                }
                cat.deepMap(this.nomvarTypePropagater);
                if (cat2 != null) {
                    cat2.deepMap(this.nomvarTypePropagater);
                }
            }
            catch (TypePropagationException tpe) {
                if (!this.debugSemClasses) break block4;
                System.err.println("Warning: unable to unify types '" + tpe.st1 + "' and '" + tpe.st2 + "' in cat: \n" + cat);
                if (cat2 == null) break block4;
                System.err.println("and cat: \n" + cat2);
            }
        }
    }

    public String[] getDistributiveAttrs() {
        return this._distributiveAttrs;
    }

    public void propagateDistributiveAttrs(Category cat) {
        this.propagateDistributiveAttrs(cat, null);
    }

    public void propagateDistributiveAttrs(Category cat, Category cat2) {
        if (this._distributiveAttrs == null) {
            return;
        }
        this.resetDistrAttrVals();
        cat.forall(this.gatherDistrAttrVals);
        if (cat2 != null) {
            cat2.forall(this.gatherDistrAttrVals);
        }
        cat.forall(this.propagateUniqueDistrAttrVals);
        if (cat2 != null) {
            cat2.forall(this.propagateUniqueDistrAttrVals);
        }
    }

    private void resetDistrAttrVals() {
        if (this.distrAttrVals == null) {
            this.distrAttrVals = new List[this._distributiveAttrs.length];
            for (int i = 0; i < this.distrAttrVals.length; ++i) {
                this.distrAttrVals[i] = new ArrayList(3);
            }
            return;
        }
        for (int i = 0; i < this.distrAttrVals.length; ++i) {
            this.distrAttrVals[i].clear();
        }
    }

    public LicensingFeature[] getLicensingFeatures() {
        return this._licensingFeatures;
    }

    public Integer getRelationSortIndex(String rel) {
        Integer retval = this._relationIndexMap.get(rel);
        if (retval != null) {
            return retval;
        }
        retval = this._relationIndexMap.get("*");
        if (retval != null) {
            return retval;
        }
        return new Integer(-1);
    }

    public boolean isCoartRel(String rel) {
        return this._coartRelsToPreds.containsKey(rel);
    }

    private Pair<List<MorphItem>, List<MacroItem>> getMorph(URL url) throws IOException {
        MorphScanner morphScanner = new MorphScanner();
        morphScanner.parse(url);
        return new Pair<List<MorphItem>, List<MacroItem>>(morphScanner.morphItems, morphScanner.macroItems);
    }

    private List<Family> getLexicon(URL url) throws IOException {
        LexiconScanner lexiconScanner = new LexiconScanner();
        lexiconScanner.parse(url);
        if (lexiconScanner.distrElt != null) {
            String distrAttrs = lexiconScanner.distrElt.getAttributeValue("attrs");
            this._distributiveAttrs = distrAttrs.split("\\s+");
        }
        this.loadLicensingFeatures(lexiconScanner.licensingElt);
        this.loadRelationSortOrder(lexiconScanner.relationSortingElt);
        return lexiconScanner.lexicon;
    }

    private void loadLicensingFeatures(Element licensingElt) {
        ArrayList<LicensingFeature> licensingFeats = new ArrayList<LicensingFeature>();
        boolean containsLexFeat = false;
        if (licensingElt != null) {
            for (Element featElt : licensingElt.getChildren("feat")) {
                String locStr;
                String inst;
                String lec;
                String attr = featElt.getAttributeValue("attr");
                if (attr.equals("lex")) {
                    containsLexFeat = true;
                }
                String val = featElt.getAttributeValue("val");
                List<String> alsoLicensedBy = null;
                String alsoVals = featElt.getAttributeValue("also-licensed-by");
                if (alsoVals != null) {
                    alsoLicensedBy = Arrays.asList(alsoVals.split("\\s+"));
                }
                boolean licenseEmptyCats = true;
                boolean licenseMarkedCats = false;
                boolean instantiate = true;
                byte loc = 0;
                String lmc = featElt.getAttributeValue("license-marked-cats");
                if (lmc != null) {
                    licenseMarkedCats = Boolean.valueOf(lmc);
                    licenseEmptyCats = false;
                    loc = 1;
                    instantiate = false;
                }
                if ((lec = featElt.getAttributeValue("license-empty-cats")) != null) {
                    licenseEmptyCats = Boolean.valueOf(lec);
                }
                if ((inst = featElt.getAttributeValue("instantiate")) != null) {
                    instantiate = Boolean.valueOf(inst);
                }
                if ((locStr = featElt.getAttributeValue("location")) != null) {
                    if (locStr.equals("target-only")) {
                        loc = 1;
                    }
                    if (locStr.equals("args-only")) {
                        loc = 2;
                    }
                    if (locStr.equals("both")) {
                        loc = 0;
                    }
                }
                licensingFeats.add(new LicensingFeature(attr, val, alsoLicensedBy, licenseEmptyCats, licenseMarkedCats, instantiate, loc));
            }
        }
        if (!containsLexFeat) {
            licensingFeats.add(LicensingFeature.defaultLexFeature);
        }
        this._licensingFeatures = new LicensingFeature[licensingFeats.size()];
        licensingFeats.toArray(this._licensingFeatures);
    }

    private void loadRelationSortOrder(Element relationSortingElt) {
        if (relationSortingElt == null) {
            for (int i = 0; i < defaultRelationSortOrder.length; ++i) {
                this._relationIndexMap.put(defaultRelationSortOrder[i], new Integer(i));
            }
            return;
        }
        String orderAttr = relationSortingElt.getAttributeValue("order");
        String[] relSortOrder = orderAttr.split("\\s+");
        for (int i = 0; i < relSortOrder.length; ++i) {
            this._relationIndexMap.put(relSortOrder[i], new Integer(i));
        }
    }

    public GroupMap<Word, MorphItem> getWords() {
        return this._words;
    }

    private class LexiconScanner
    extends XmlScanner {
        List<Family> lexicon = new ArrayList<Family>();
        Element distrElt = null;
        Element licensingElt = null;
        Element relationSortingElt = null;

        private LexiconScanner() {
        }

        @Override
        public void handleElement(Element e) {
            if (e.getName().equals("family")) {
                try {
                    this.lexicon.add(new Family(e));
                }
                catch (RuntimeException exc) {
                    System.err.println("Skipping family: " + e.getAttributeValue("name"));
                    System.err.println(exc.toString());
                }
            } else if (e.getName().equals("distributive-features")) {
                this.distrElt = e;
            } else if (e.getName().equals("licensing-features")) {
                this.licensingElt = e;
            } else if (e.getName().equals("relation-sorting")) {
                this.relationSortingElt = e;
            }
        }
    }

    private class MorphScanner
    extends XmlScanner {
        List<MorphItem> morphItems = new ArrayList<MorphItem>();
        List<MacroItem> macroItems = new ArrayList<MacroItem>();

        private MorphScanner() {
        }

        @Override
        public void handleElement(Element e) {
            if (e.getName().equals("entry")) {
                try {
                    this.morphItems.add(new MorphItem(e));
                }
                catch (RuntimeException exc) {
                    System.err.println("Skipping morph item: " + e.getAttributeValue("word"));
                    System.err.println(exc.toString());
                }
            } else if (e.getName().equals("macro")) {
                try {
                    this.macroItems.add(new MacroItem(e));
                }
                catch (RuntimeException exc) {
                    System.err.println("Skipping macro item: " + e.getAttributeValue("name"));
                    System.err.println(exc.toString());
                }
            }
        }
    }

    private static class PredLookup {
        String pred;
        List<String> coartRels;
        Collection<Sign> signs;

        PredLookup(String s, List<String> l) {
            this.pred = s;
            this.coartRels = l;
        }

        public int hashCode() {
            return this.pred.hashCode() + (this.coartRels != null ? this.coartRels.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PredLookup)) {
                return false;
            }
            PredLookup pLook = (PredLookup)obj;
            if (!this.pred.equals(pLook.pred)) {
                return false;
            }
            if (this.coartRels == null) {
                return pLook.coartRels == null;
            }
            return this.coartRels.equals(pLook.coartRels);
        }
    }

    private static class RelLookup {
        String rel;
        Collection<Sign> signs;

        RelLookup(String s) {
            this.rel = s;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof RelLookup && this.rel.equals(((RelLookup)obj).rel);
        }
    }

    private class TypePropagationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        SimpleType st1;
        SimpleType st2;

        TypePropagationException(SimpleType st1, SimpleType st2) {
            this.st1 = st1;
            this.st2 = st2;
        }
    }
}

