/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo.graph;

import opennlp.ccg.hylo.graph.LFEdgeLabel;
import opennlp.ccg.hylo.graph.LFVertex;

public class LFEdge {
    final LFVertex source;
    final LFVertex target;
    final LFEdgeLabel label;

    public LFEdge(LFVertex source, LFVertex target) {
        this(source, target, null);
    }

    public LFEdge(LFVertex source, LFVertex target, LFEdgeLabel label) {
        this.checkVertex(source, "source");
        this.checkVertex(target, "target");
        this.source = source;
        this.target = target;
        this.label = label;
    }

    void checkVertex(LFVertex v, String name) {
        if (v == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public LFEdgeLabel getLabel() {
        return this.label;
    }

    public LFVertex getSource() {
        return this.source;
    }

    public LFVertex getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (o instanceof LFEdge) {
            LFEdge e = (LFEdge)o;
            return this.source.equals(e.source) && this.target.equals(e.target) && this.label != null ? this.label.equals(e.label) : e.label == null;
        }
        return false;
    }

    public int hashCode() {
        int h = 37 * this.source.hashCode() + this.target.hashCode();
        if (this.label != null) {
            h += this.label.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.source.toString());
        sb.append(" --");
        sb.append(this.label == null ? "(no label)" : this.label.toString());
        sb.append("--> ");
        sb.append(this.target.toString());
        return sb.toString();
    }
}

