/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import gnu.trove.TObjectIntHashMap;
import java.util.List;
import opennlp.ccg.hylo.HyloFormula;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Mode;
import opennlp.ccg.hylo.ModeLabel;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.unify.ModFcn;
import opennlp.ccg.unify.UnifyFailure;
import opennlp.ccg.unify.Variable;
import org.jdom.Element;

public abstract class ModalOp
extends HyloFormula {
    private static final long serialVersionUID = 1L;
    protected Mode _mode;
    protected LF _arg;

    protected ModalOp(Element e) {
        String atomLabel = e.getAttributeValue("mode");
        if (atomLabel == null) {
            atomLabel = e.getAttributeValue("m");
        }
        if (atomLabel != null) {
            this._mode = new ModeLabel(atomLabel);
            this._arg = HyloHelper.getLF_FromChildren(e);
        } else {
            List children = e.getChildren();
            this._mode = (Mode)HyloHelper.getLF((Element)children.get(0));
            this._arg = HyloHelper.getLF((Element)children.get(1));
        }
    }

    protected ModalOp(Mode mode, LF arg) {
        this._mode = mode;
        this._arg = arg;
    }

    public Mode getMode() {
        return this._mode;
    }

    public void setMode(Mode mode) {
        this._mode = mode;
    }

    public LF getArg() {
        return this._arg;
    }

    public void setArg(LF arg) {
        this._arg = arg;
    }

    @Override
    public void deepMap(ModFcn mf) {
        this._arg.deepMap(mf);
        mf.modify(this);
    }

    @Override
    public boolean occurs(Variable var) {
        return this._mode.occurs(var) || this._arg.occurs(var);
    }

    protected boolean equals(ModalOp mo) {
        return this._mode.equals(mo._mode) && this._arg.equals(mo._arg);
    }

    protected void unifyCheck(ModalOp mo) throws UnifyFailure {
        this._mode.unifyCheck(mo._mode);
        this._arg.unifyCheck(mo._arg);
    }

    public int hashCode() {
        return this._mode.hashCode() + this._arg.hashCode();
    }

    @Override
    public int hashCode(TObjectIntHashMap varMap) {
        return this._mode.hashCode(varMap) + this._arg.hashCode(varMap);
    }

    @Override
    public boolean equals(Object obj, TObjectIntHashMap varMap, TObjectIntHashMap varMap2) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ModalOp mo = (ModalOp)obj;
        return this._mode.equals(mo._mode, varMap, varMap2) && this._arg.equals(mo._arg, varMap, varMap2);
    }

    public abstract String modalOpString();

    public String toString() {
        return new StringBuffer().append(this.modalOpString()).append(this._arg.toString()).toString();
    }

    @Override
    public String prettyPrint(String indent) {
        StringBuffer ibuf = new StringBuffer();
        ibuf.append(indent).append(' ');
        String modalOpString = this.modalOpString();
        for (int i = 0; i < modalOpString.length(); ++i) {
            ibuf.append(' ');
        }
        String newIndent = ibuf.toString();
        StringBuffer sb = new StringBuffer();
        sb.append('\n').append(indent).append(modalOpString);
        sb.append(this._arg.prettyPrint(newIndent));
        return sb.toString();
    }
}

