/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.hylo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import opennlp.ccg.TextCCG;
import opennlp.ccg.hylo.Diamond;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.hylo.NominalAtom;
import opennlp.ccg.hylo.NominalVar;
import opennlp.ccg.hylo.Op;
import opennlp.ccg.hylo.Proposition;
import opennlp.ccg.hylo.SatOp;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.LexSemOrigin;
import opennlp.ccg.synsem.Sign;

public class Converter {
    public static final String USE_WORD_POSITIONS_FOR_ATOM_CONVERSION = "Use Word Positions To Convert Atoms";
    private Map<Nominal, Nominal> nominalMap = new HashMap<Nominal, Nominal>();
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private boolean skipAbsentProp = true;

    static void convertNominals(LF lf) {
        Converter.convertNominals(lf, null, null);
    }

    static Nominal convertNominals(LF lf, Sign root, Nominal nominalRoot) {
        Preferences prefs = Preferences.userNodeForPackage(TextCCG.class);
        boolean useWordPositions = prefs.getBoolean(USE_WORD_POSITIONS_FOR_ATOM_CONVERSION, true);
        if (!useWordPositions) {
            root = null;
        }
        Converter converter = new Converter();
        converter.convertNoms(lf, root);
        converter.skipAbsentProp = false;
        converter.convertNoms(lf, root);
        Nominal retval = null;
        if (nominalRoot != null) {
            retval = converter.nominalMap.get(nominalRoot);
        }
        return retval;
    }

    private void convertNoms(LF lf, Sign root) {
        block10: {
            block11: {
                LF arg;
                block12: {
                    block9: {
                        Op op2;
                        LF first;
                        LexSemOrigin origin;
                        if (!(lf instanceof SatOp)) break block9;
                        SatOp satOp = (SatOp)lf;
                        int wordIndex = -1;
                        if (root != null && (origin = satOp.getOrigin()) instanceof Sign) {
                            Sign lexSign = (Sign)origin;
                            String lexPred = HyloHelper.getLexPred(satOp);
                            if (lexPred != null && !lexPred.equals("elem") && !Converter.lexDominated(lexPred, lexSign)) {
                                wordIndex = root.wordIndex(lexSign);
                            }
                        }
                        Nominal oldNom = satOp.getNominal();
                        Proposition prop = null;
                        LF arg2 = satOp.getArg();
                        if (arg2 instanceof Proposition) {
                            prop = (Proposition)arg2;
                        } else if (arg2 instanceof Op && (first = (op2 = (Op)arg2).getArguments().get(0)) instanceof Proposition) {
                            prop = (Proposition)first;
                        }
                        Nominal convertedNom = this.convertNominal(oldNom, prop, wordIndex);
                        satOp.setNominal(convertedNom);
                        this.convertNoms(arg2, root);
                        break block10;
                    }
                    if (!(lf instanceof Diamond)) break block11;
                    Diamond d = (Diamond)lf;
                    arg = d.getArg();
                    if (!(arg instanceof Nominal)) break block12;
                    Nominal oldNom = (Nominal)arg;
                    Nominal convertedNom = this.convertNominal(oldNom, null, -1);
                    d.setArg(convertedNom);
                    break block10;
                }
                if (!(arg instanceof Op)) break block10;
                Op op3 = (Op)arg;
                List<LF> args = op3.getArguments();
                LF first = args.get(0);
                if (first instanceof Nominal) {
                    Nominal oldNom = (Nominal)first;
                    LF second = args.get(1);
                    Proposition prop = null;
                    if (second instanceof Proposition) {
                        prop = (Proposition)second;
                    }
                    Nominal convertedNom = this.convertNominal(oldNom, prop, -1);
                    args.set(0, convertedNom);
                }
                this.convertNoms(arg, root);
                break block10;
            }
            if (lf instanceof Op) {
                List<LF> args = ((Op)lf).getArguments();
                for (int i = 0; i < args.size(); ++i) {
                    this.convertNoms(args.get(i), root);
                }
            }
        }
    }

    private Nominal convertNominal(Nominal oldNom, Proposition prop, int wordIndex) {
        if (oldNom instanceof NominalAtom) {
            return oldNom;
        }
        if (wordIndex >= 0) {
            return this.convertNominal(oldNom, "w" + wordIndex);
        }
        if (prop == null && this.skipAbsentProp) {
            return oldNom;
        }
        Nominal alreadyConvertedNom = this.nominalMap.get(oldNom);
        if (alreadyConvertedNom != null) {
            return (Nominal)alreadyConvertedNom.copy();
        }
        String nameBase = "x";
        if (prop != null && !Character.isLetter((nameBase = prop.toString().toLowerCase().substring(0, 1)).charAt(0))) {
            nameBase = "n";
        }
        int ext = 1;
        Integer baseCount = this.nameMap.get(nameBase);
        if (baseCount != null) {
            ext = baseCount + 1;
        }
        this.nameMap.put(nameBase, new Integer(ext));
        String name = nameBase + ext;
        return this.convertNominal(oldNom, name);
    }

    private Nominal convertNominal(Nominal oldNom, String name) {
        NominalAtom retval = new NominalAtom(name, oldNom.getType());
        this.nominalMap.put(oldNom, retval);
        return retval;
    }

    private static boolean lexDominated(String lexPred, Sign lexSign) {
        Category cat = lexSign.getCategory();
        LF lf = cat.getLF();
        Nominal index = cat.getIndexNominal();
        List<SatOp> preds = HyloHelper.getPreds(lf);
        SatOp lexEP = null;
        ArrayList<SatOp> otherLexPreds = new ArrayList<SatOp>();
        for (SatOp pred : preds) {
            if (!HyloHelper.isLexPred(pred)) continue;
            if (lexPred.equals(HyloHelper.getLexPred(pred))) {
                lexEP = pred;
                continue;
            }
            otherLexPreds.add(pred);
        }
        if (lexEP == null) {
            throw new RuntimeException("Couldn't find lexPred: " + lexPred);
        }
        Nominal lexNom = HyloHelper.getPrincipalNominal(lexEP);
        for (SatOp pred : otherLexPreds) {
            Nominal otherNom = HyloHelper.getPrincipalNominal(pred);
            Stack<Nominal> seen = new Stack<Nominal>();
            seen.push(index);
            if (!Converter.dominates(otherNom, lexNom, preds, seen)) continue;
            return true;
        }
        return false;
    }

    private static boolean dominates(Nominal a, Nominal b, List<SatOp> preds, Stack<Nominal> seen) {
        if (a.equals(b)) {
            return false;
        }
        seen.push(a);
        for (SatOp pred : preds) {
            Nominal c;
            if (!a.equals(HyloHelper.getPrincipalNominal(pred)) || (c = HyloHelper.getSecondaryNominal(pred)) == null) continue;
            if (b.equals(c)) {
                return true;
            }
            if (seen.contains(c) || !Converter.dominates(c, b, preds, seen)) continue;
            return true;
        }
        seen.pop();
        return false;
    }

    static void convertNominalsToVars(List<SatOp> preds) {
        Converter.convertNominalsToVars(preds, null);
    }

    static Nominal convertNominalsToVars(List<SatOp> preds, Nominal nominalRoot) {
        Nominal retval = null;
        for (SatOp pred : preds) {
            Diamond dArg;
            LF arg2;
            Nominal nom = pred._nominal;
            Nominal nv = Converter.convertNominalToVar(nom);
            if (nom.equals(nominalRoot)) {
                retval = nv;
            }
            pred.setNominal(nv);
            LF arg = pred.getArg();
            if (!(arg instanceof Diamond) || !((arg2 = (dArg = (Diamond)arg).getArg()) instanceof Nominal)) continue;
            Nominal nv2 = Converter.convertNominalToVar((Nominal)arg2);
            dArg.setArg(nv2);
        }
        return retval;
    }

    static Nominal convertNominalToVar(Nominal nom) {
        return new NominalVar(nom.getName().toUpperCase(), nom.getType());
    }
}

