/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg.alignment;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import opennlp.ccg.alignment.Alignment;
import opennlp.ccg.alignment.EncodingScheme;
import opennlp.ccg.alignment.IdentifiedPhraseReader;
import opennlp.ccg.alignment.IdentifiedPhraseWriter;
import opennlp.ccg.alignment.IndexBase;
import opennlp.ccg.alignment.Mapping;
import opennlp.ccg.alignment.MappingFormat;
import opennlp.ccg.alignment.MappingGroup;
import opennlp.ccg.alignment.MappingReader;
import opennlp.ccg.alignment.MappingWriter;
import opennlp.ccg.alignment.MosesEncodingScheme;
import opennlp.ccg.alignment.NAACLEncodingScheme;
import opennlp.ccg.alignment.Phrase;
import opennlp.ccg.alignment.PhrasePosition;
import opennlp.ccg.alignment.PhraseReader;
import opennlp.ccg.alignment.PhraseWriter;
import opennlp.ccg.alignment.Status;

public final class Alignments {
    public static final Status DEFAULT_STATUS = Status.SURE;
    public static final Double DEFAULT_CONFIDENCE = 1.0;
    public static final IndexBase DEFAULT_PHRASE_NUMBER_BASE = IndexBase.ZERO;
    public static final IndexBase DEFAULT_INDEX_BASE = IndexBase.ZERO;
    public static final PhrasePosition DEFAULT_PHRASE_POSITION = PhrasePosition.A;
    public static final Pattern DEFAULT_WORD_DELIMITER = Pattern.compile("\\s+");
    public static final String DEFAULT_WORD_SEPARATOR = " ";
    public static final String DEFAULT_PHRASE_IDENTIFIER_ATTRIBUTE = "snum";
    public static final String DEFAULT_PHRASE_TAG = "s";
    public static final EncodingScheme MOSES_ENCODING_SCHEME;
    public static final EncodingScheme NAACL_ENCODING_SCHEME;
    public static final Set<MappingFormat.Field> MOSES_DEFAULT_FIELDS;
    public static final Set<MappingFormat.Field> NAACL_DEFAULT_FIELDS;
    public static final Set<MappingFormat.Field> MOSES_SHORT_FIELDS;
    public static final Set<MappingFormat.Field> NAACL_SHORT_FIELDS;
    public static final Set<MappingFormat.Field> NAACL_VERY_SHORT_FIELDS;
    public static final boolean DEFAULT_STRICTNESS = false;
    public static final boolean DEFAULT_PHRASE_PADDING = false;

    private Alignments() {
    }

    public static String[] tokenize(String s) {
        return Alignments.tokenize(s, DEFAULT_WORD_DELIMITER);
    }

    public static String[] tokenize(String s, Pattern wordDelimiter) {
        return wordDelimiter.split(s);
    }

    public static String untokenize(List<String> tokens) {
        return Alignments.untokenize(tokens, DEFAULT_WORD_SEPARATOR);
    }

    public static String untokenize(List<String> tokens, String delimiter) {
        return Alignments.untokenize(tokens.toArray(new String[tokens.size()]));
    }

    public static String untokenize(String[] tokens) {
        return Alignments.untokenize(tokens, DEFAULT_WORD_SEPARATOR);
    }

    public static String untokenize(String[] tokens, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String w : tokens) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(w.toString());
        }
        return sb.toString();
    }

    public static List<Phrase> readPhrases(File f) throws IOException {
        return Alignments.readPhrases(new BufferedReader(new FileReader(f)));
    }

    public static List<Phrase> readPhrases(Reader r) throws IOException {
        return Alignments.readPhrases(r, DEFAULT_PHRASE_NUMBER_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Phrase> readPhrases(Reader r, IndexBase phraseNumberBase) throws IOException {
        try (PhraseReader reader = new PhraseReader(r, phraseNumberBase);){
            List<Phrase> list = Alignments.readPhrases(reader);
            return list;
        }
    }

    public static List<Phrase> readIdentifiedPhrases(File f) throws IOException {
        return Alignments.readIdentifiedPhrases(new BufferedReader(new FileReader(f)));
    }

    public static List<Phrase> readIdentifiedPhrases(Reader r) throws IOException {
        return Alignments.readIdentifiedPhrases(r, DEFAULT_PHRASE_NUMBER_BASE, DEFAULT_PHRASE_TAG, DEFAULT_PHRASE_IDENTIFIER_ATTRIBUTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Phrase> readIdentifiedPhrases(Reader r, IndexBase phraseNumberBase, String phraseTag, String phraseIdentifierAttribute) throws IOException {
        try (IdentifiedPhraseReader reader = new IdentifiedPhraseReader(r, phraseNumberBase, phraseTag, phraseIdentifierAttribute);){
            List<Phrase> list = Alignments.readPhrases(reader);
            return list;
        }
    }

    public static List<Phrase> readPhrases(PhraseReader reader) throws IOException {
        Phrase p;
        ArrayList<Phrase> l = new ArrayList<Phrase>();
        while ((p = reader.readPhrase()) != null) {
            l.add(p);
        }
        return l;
    }

    public static void writeIdentifiedPhrases(List<Phrase> phrases, File f) throws IOException {
        Alignments.writeIdentifiedPhrases(phrases, new BufferedWriter(new FileWriter(f)));
    }

    public static void writeIdentifiedPhrases(List<Phrase> phrases, Writer w) throws IOException {
        Alignments.writeIdentifiedPhrases(phrases, w, DEFAULT_WORD_SEPARATOR, DEFAULT_PHRASE_TAG, DEFAULT_PHRASE_IDENTIFIER_ATTRIBUTE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIdentifiedPhrases(List<Phrase> phrases, Writer w, String wordSeparator, String phraseTag, String phraseIdentifierAttribute, boolean padding) throws IOException {
        try (IdentifiedPhraseWriter pw = new IdentifiedPhraseWriter(w, wordSeparator, phraseTag, phraseIdentifierAttribute, padding);){
            Alignments.writePhrases(phrases, pw);
        }
    }

    public static void writePhrases(List<Phrase> phrases, File f) throws IOException {
        Alignments.writePhrases(phrases, new BufferedWriter(new FileWriter(f)));
    }

    public static void writePhrases(List<Phrase> phrases, Writer w) throws IOException {
        Alignments.writePhrases(phrases, w, DEFAULT_WORD_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePhrases(List<Phrase> phrases, Writer w, String wordSeparator) throws IOException {
        try (PhraseWriter pw = new PhraseWriter(w, wordSeparator);){
            Alignments.writePhrases(phrases, pw);
        }
    }

    public static void writePhrases(List<Phrase> phrases, PhraseWriter writer) throws IOException {
        for (Phrase p : phrases) {
            writer.writePhrase(p);
        }
    }

    public static Map<Integer, Set<Mapping>> readMappings(File f, MappingFormat format) throws IOException {
        return Alignments.readMappings(new BufferedReader(new FileReader(f)), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Set<Mapping>> readMappings(Reader r, MappingFormat format) throws IOException {
        try (MappingReader mr = new MappingReader(r, format);){
            Map<Integer, Set<Mapping>> map = Alignments.readMappings(mr);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Set<Mapping>> readMappings(MappingReader reader) throws IOException {
        LinkedHashMap<Integer, Set<Mapping>> am = new LinkedHashMap<Integer, Set<Mapping>>();
        try {
            MappingGroup ag = null;
            while ((ag = reader.nextGroup()) != null) {
                LinkedHashSet<Mapping> as = (LinkedHashSet<Mapping>)am.get(ag.phraseNumber);
                if (as == null) {
                    as = new LinkedHashSet<Mapping>();
                    am.put(ag.phraseNumber, as);
                }
                while (reader.canRead()) {
                    Mapping m = reader.readMapping();
                    if (as.add(m)) continue;
                    throw new IOException("duplicate mapping in group " + ag + ": " + m);
                }
            }
        }
        finally {
            reader.close();
        }
        return am;
    }

    public static SortedMap<Integer, SortedSet<Mapping>> readSortedMappings(File f, MappingFormat format) throws IOException {
        return Alignments.readSortedMappings(new BufferedReader(new FileReader(f)), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<Integer, SortedSet<Mapping>> readSortedMappings(Reader r, MappingFormat format) throws IOException {
        try (MappingReader mr = new MappingReader(r, format);){
            SortedMap<Integer, SortedSet<Mapping>> sortedMap = Alignments.readSortedMappings(mr);
            return sortedMap;
        }
    }

    public static SortedMap<Integer, SortedSet<Mapping>> readSortedMappings(MappingReader mr) throws IOException {
        TreeMap<Integer, SortedSet<Mapping>> sm = new TreeMap<Integer, SortedSet<Mapping>>();
        Map<Integer, Set<Mapping>> m = Alignments.readMappings(mr);
        for (Integer k : m.keySet()) {
            sm.put(k, new TreeSet(m.get(k)));
        }
        return sm;
    }

    public static void writeMappings(Map<Integer, Set<Mapping>> map, File f, MappingFormat format) throws IOException {
        Alignments.writeMappings(map, new BufferedWriter(new FileWriter(f)), format);
    }

    public static void writeMappings(Map<Integer, Set<Mapping>> map, Writer w, MappingFormat format) throws IOException {
        Alignments.writeMappings(map, new MappingWriter(w, format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMappings(Map<Integer, Set<Mapping>> map, MappingWriter writer) throws IOException {
        try {
            for (Integer k : map.keySet()) {
                Set<Mapping> as = map.get(k);
                writer.startGroup(new MappingGroup(k, as.size()));
                for (Mapping a : as) {
                    writer.writeMapping(a);
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public static List<Alignment> readAlignments(File phraseA, File phraseB, File mappings, Pattern wordDelimiter, MappingFormat format) throws IOException {
        return Alignments.readAlignments(new BufferedReader(new FileReader(phraseA)), new BufferedReader(new FileReader(phraseB)), (Reader)new BufferedReader(new FileReader(mappings)), format);
    }

    public static List<Alignment> readAlignments(Reader phraseA, Reader phraseB, Reader mappings, MappingFormat format) throws IOException {
        IndexBase idBase = format.encodingScheme.getPhraseNumberBase();
        return Alignments.readAlignments(new PhraseReader(phraseA, idBase), new PhraseReader(phraseB, idBase), mappings, format);
    }

    public static List<Alignment> readIdentifiedAlignments(File phraseA, File phraseB, File mappings, Pattern wordDelimiter, MappingFormat format) throws IOException {
        return Alignments.readIdentifiedAlignments(new BufferedReader(new FileReader(phraseA)), new BufferedReader(new FileReader(phraseB)), new BufferedReader(new FileReader(mappings)), format);
    }

    public static List<Alignment> readIdentifiedAlignments(Reader phraseA, Reader phraseB, Reader mappings, MappingFormat format) throws IOException {
        return Alignments.readAlignments(new IdentifiedPhraseReader(phraseA), new IdentifiedPhraseReader(phraseB), mappings, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Alignment> readAlignments(PhraseReader phraseA, PhraseReader phraseB, Reader mappings, MappingFormat format) throws IOException {
        ArrayList<Alignment> m = new ArrayList<Alignment>();
        try {
            List<Phrase> ps1 = Alignments.readPhrases(phraseA);
            List<Phrase> ps2 = Alignments.readPhrases(phraseB);
            Map<Integer, Set<Mapping>> mm = Alignments.readMappings(mappings, format);
            if (ps1.size() != ps2.size()) {
                throw new IOException("number of phrases different between first and second");
            }
            for (int i = 0; i < ps1.size(); ++i) {
                m.add(new Alignment(ps1.get(i), ps2.get(i), (Collection<? extends Mapping>)mm.get(i)));
            }
        }
        finally {
            phraseA.close();
            phraseA.close();
            mappings.close();
        }
        return m;
    }

    public static void writeAlignments(List<Alignment> alignments, File phraseA, File phraseB, File mappings, String wordSeparator, MappingFormat format) throws IOException {
        Alignments.writeAlignments(alignments, new BufferedWriter(new FileWriter(phraseA)), new BufferedWriter(new FileWriter(phraseB)), new BufferedWriter(new FileWriter(mappings)), wordSeparator, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAlignments(List<Alignment> alignments, Writer phraseA, Writer phraseB, Writer mappings, String wordSeparator, MappingFormat format) throws IOException {
        PhraseWriter pw1 = new PhraseWriter(phraseA, wordSeparator);
        PhraseWriter pw2 = new PhraseWriter(phraseB, wordSeparator);
        MappingWriter mw = new MappingWriter(mappings, format);
        try {
            for (int i = 0; i < alignments.size(); ++i) {
                Alignment a = alignments.get(i);
                pw1.writePhrase(a.a);
                pw2.writePhrase(a.b);
                mw.startGroup(new MappingGroup(i, a.size()));
                for (Mapping m : a) {
                    mw.writeMapping(m);
                }
            }
        }
        finally {
            pw1.close();
            pw2.close();
            mw.close();
        }
    }

    static {
        HashSet<MappingFormat.Field> msf = new HashSet<MappingFormat.Field>();
        HashSet<MappingFormat.Field> nsf = new HashSet<MappingFormat.Field>();
        HashSet<MappingFormat.Field> nvsf = new HashSet<MappingFormat.Field>();
        msf.add(MappingFormat.Field.A_INDEX_FIELD);
        msf.add(MappingFormat.Field.B_INDEX_FIELD);
        nsf.add(MappingFormat.Field.PHRASE_NUMBER_FIELD);
        nsf.add(MappingFormat.Field.A_INDEX_FIELD);
        nsf.add(MappingFormat.Field.B_INDEX_FIELD);
        nsf.add(MappingFormat.Field.STATUS_FIELD);
        nvsf.add(MappingFormat.Field.PHRASE_NUMBER_FIELD);
        nvsf.add(MappingFormat.Field.A_INDEX_FIELD);
        nvsf.add(MappingFormat.Field.B_INDEX_FIELD);
        MOSES_SHORT_FIELDS = Collections.unmodifiableSet(msf);
        NAACL_SHORT_FIELDS = Collections.unmodifiableSet(nsf);
        NAACL_VERY_SHORT_FIELDS = Collections.unmodifiableSet(nvsf);
        MOSES_DEFAULT_FIELDS = MOSES_SHORT_FIELDS;
        NAACL_DEFAULT_FIELDS = NAACL_SHORT_FIELDS;
        MOSES_ENCODING_SCHEME = new MosesEncodingScheme();
        NAACL_ENCODING_SCHEME = new NAACLEncodingScheme();
    }
}

